<?php
header("Access-Control-Allow-Origin: *");
header('Content-Type: text/html; charset=utf-8');

require_once(__DIR__.'/vendor/autoload.php');

session_name(config('app.LGPD_KEY'));
session_start([
    'cookie_lifetime' => config('app.LGPD_EXPIRE')
]);

date_default_timezone_set(config('app.TIMEZONE'));

switch (Request::seo(1)) {
    case config('app.CMSKEY'):
        if (!Request::seo(2)) {
            header('Location: '.config('app.PATH_CMS').'/login/');
            exit;
        }

        if (Request::seo(2) == 'login') {
            include(config('app.ROOT_CMS_SYSTEM').'/cms_index.php');
        }
        if (Request::seo(2) == 'recuperar-senha') {
            include(config('app.ROOT_CMS_SYSTEM').'/cms_forgout.php');
        }
        else if (Request::seo(2) == 'sistema') {
            include(config('app.ROOT_CMS_SYSTEM').'/cms_system.php');
        }
    break;

    default:
        require_once(config('app.ROOT_CORE').'/class.controller.php');

        $execute = new ControllerSite();

        unset($execute);
    break;
}

exit;
