<?php

// CoreSlim - Última atualização 02/03/2023 15:26

namespace CoreSlim\Stats;

class StatsMetrics
{
    public static function unique($metrics, $operation = 'add')
    {
        if ($operation == 'add') {
            $metrics = $metrics + 1;
        }
        else if ($operation == 'decrease') {
            $metrics = $metrics - 1;
        }

        return $metrics;
    }

    public static function global($metrics, $global = null, $operation = 'add')
    {
        if (!isset($metrics['total'])) {
            $metrics['total'] = 0;
        }

        if (!is_null($global) && !isset($metrics['unique'][$global])) {
            $metrics['unique'][$global] = 0;
        }

        if ($operation == 'add') {
            $metrics['total'] = $metrics['total'] + 1;

            if (!is_null($global)) {
                $metrics['unique'][$global] = $metrics['unique'][$global] + 1;
            }
        }
        else if ($operation == 'decrease') {
            $metrics['total'] = $metrics['total'] - 1;

            if (!is_null($global)) {
                $metrics['unique'][$global] = $metrics['unique'][$global] - 1;
            }
        }

        return $metrics;
    }

    public static function group($metrics, $group, $operation = 'add')
    {
        if (!isset($metrics[$group])) {
            $metrics[$group] = 0;
        }

        if ($operation == 'add') {
            if (is_int($metrics[$group])) {
                $metrics[$group]++;
            }
        }
        else if ($operation == 'decrease') {
            if (is_int($metrics[$group])) {
                $metrics[$group]++;
            }
        }

        return $metrics;
    }

    public static function period($metrics, $unique = null, $date = null, $operation = 'add')
    {
        if (is_null($date)) {
            $data = date('Y-m-d H:i:s');
        }

        $date = new \DateTime($date);

        if ($unique) {
            if (!isset($metrics[$unique])) {
                $metrics[$unique] = [];
            }

            $restoreMetrics = $metrics;

            $metrics = $metrics[$unique];
        }

        if (!isset($metrics[$date->format('Y')])) {
            $metrics[$date->format('Y')]['total'] = 0;
            $metrics[$date->format('Y')]['months'] = [];
        }

        if (!isset($metrics[$date->format('Y')]['months'][$date->format('m')])) {
            $metrics[$date->format('Y')]['months'][$date->format('m')]['total'] = 0;
            $metrics[$date->format('Y')]['months'][$date->format('m')]['days'] = [];
        }

        if (!isset($metrics[$date->format('Y')]['months'][$date->format('m')]['days'][$date->format('d')])) {
            $metrics[$date->format('Y')]['months'][$date->format('m')]['days'][$date->format('d')] = 0;
        }

        if ($operation == 'add') {
            $metrics[$date->format('Y')]['total']++;
            $metrics[$date->format('Y')]['months'][$date->format('m')]['total']++;
            $metrics[$date->format('Y')]['months'][$date->format('m')]['days'][$date->format('d')]++;
        }
        else if ($operation == 'decrease') {
            $metrics[$date->format('Y')]['total']--;
            $metrics[$date->format('Y')]['months'][$date->format('m')]['total']--;
            $metrics[$date->format('Y')]['months'][$date->format('m')]['days'][$date->format('d')]--;
        }

        if ($unique) {
            $restoreMetrics[$unique] = $metrics;

            $metrics = $restoreMetrics;
        }

        return $metrics;
    }

    public static function combinePeriodMonths()
    {
        foreach ($stats[$this->get('target')] as $year => $yearData) {
            if (!isset($multipleStats[$year]['total'])) {
                $multipleStats[$year]['total'] = 0;
                $multipleStats[$year]['months'] = [];
            }

            $multipleStats[$year]['total'] = $multipleStats[$year]['total'] + $yearData['total'];

            if (isset($yearData['months'])) {
                foreach ($yearData['months'] as $month => $monthData) {
                    if (!isset($multipleStats[$year]['months'][$month])) {
                        $multipleStats[$year]['months'][$month]['total'] = 0;
                        $multipleStats[$year]['months'][$month]['days'] = [];
                    }

                    $multipleStats[$year]['months'][$month]['total'] = $multipleStats[$year]['months'][$month]['total'] + $monthData['total'];

                    if (isset($monthData['days'])) {
                        foreach ($monthData['days'] as $day => $total) {
                            if (!isset($multipleStats[$year]['months'][$month]['days'][$day])) {
                                $multipleStats[$year]['months'][$month]['days'][$day] = 0;
                            }

                            $multipleStats[$year]['months'][$month]['days'][$day] = $multipleStats[$year]['months'][$month]['days'][$day] + $total;
                        }
                    }
                }
            }
        }
    }
}
