<?php

// CoreSlim - Última atualização 02/03/2023 15:26

namespace CoreSlim\Stats;

class StatsCentral
{
    private $active = true;
    private $type = null;
    private $unique = null;
    private $table = null;
    private $prefix = 'mod';
    private $date = null;
    private $key = 'stats';
    private $data = [];
    private $blockDuplicated = false;
    private $operation = null;

    public function __construct($type, $unique = null, $table = null, $date = null, $operation = 'click')
    {
        $this->type = $type;
        $this->unique = $unique;
        $this->table = $table;
        $this->date = $date;
        $this->operation = $operation;

        if ($this->table) {
            $this->prefix = str_replace('_'.$this->type, '', $this->table);
        }
    }

    public function add()
    {
        if ($this->active) {
            $this->createSession();

            $this->load();

            if ($this->check()) {
                $this->calcule()->save();
            }
        }
    }

    public function save()
    {
        if ($this->data) {
            $base = new StatsBase($this->key);
            $base->update($this->data);

            if ($this->unique) {
                $repository = new \Repository($this->type, ['prefixKey' => $this->prefix]);
                $repository->setSum('view', 1);
                $repository->setDefaultInstance('id');
                $repository->update($this->unique);
            }
        }
    }

    public function addDownload($data)
    {
        if (isset($data['inSufix']) && isset($data['id'])) {
            $repository = new \Repository($data['inSufix'], ['prefixKey' => 'sub']);

            $repository->setSum('download', 1);
            $repository->setDefaultInstance('id');
            $repository->update($data['id']);
        }
    }

    public function clear()
    {
        $this->load();

        if (isset($this->data[$this->type])) {
            $this->data[$this->type] = [];

            $base = new StatsBase($this->key);
            $base->update($this->data);

            $repository = new \Repository($this->type, ['prefixKey' => $this->prefix]);
            $repository->select('id');

            if ($result = $repository->all()) {
                foreach ($result as $key => $value) {
                    $repository->set('view', 0);
                    $repository->setDefaultInstance('id');
                    $repository->update($value['id']);
                }
            }

            return true;
        }
    }

    public function check()
    {
        if ($this->checkSession()) {
            $this->setSession();

            if (!isset($this->data[$this->type])) {
                $this->data[$this->type] = [];
            }

            if (!isset($this->data[$this->type]['global'])) {
                $this->data[$this->type]['global'] = [];
            }

            if (!isset($this->data[$this->type]['period'])) {
                $this->data[$this->type]['period'] = [];
            }

            return true;
        }
    }

    public function calcule($operation = 'add')
    {
        if (is_null($this->date)) {
            $this->date = date('Y-m-d');
        }

        $this->data[$this->type]['global'] = StatsMetrics::global($this->data[$this->type]['global'], $this->unique, $operation);
        $this->data[$this->type]['period'] = StatsMetrics::period($this->data[$this->type]['period'], $this->unique, $this->date, $operation);

        return $this;
    }

    public function load()
    {
        $base = new StatsBase($this->key);

        if ($result = $base->load()) {
            $this->data = $result;

            return true;
        }
    }

    public function createSession()
    {
        if ($this->blockDuplicated && $this->operation == 'click') {
            $sessionKey = md5($this->key.config('app.SECRET_KEY'));

            if (!isset($_SESSION[$sessionKey])) {
                $_SESSION[$sessionKey] = [];
            }
        }
    }

    public function checkSession()
    {
        if ($this->blockDuplicated && $this->operation == 'click') {
            $sessionKey = md5($this->key.config('app.SECRET_KEY'));

            if ($this->unique) {
                if (isset($_SESSION[$sessionKey][$this->type][$this->unique])) {
                    return false;
                }
            }
            else {
                if (isset($_SESSION[$sessionKey][$this->type])) {
                    return false;
                }
            }

            return true;
        }
        else {
            return true;
        }
    }

    public function setSession()
    {
        if ($this->blockDuplicated && $this->operation == 'click') {
            $sessionKey = md5($this->key.config('app.SECRET_KEY'));

            if ($this->unique) {
                $_SESSION[$sessionKey][$this->type][$this->unique] = true;
            }
            else {
                $_SESSION[$sessionKey][$this->type] = true;
            }
        }
    }
}
