<?php

// CoreSlim - Última atualização 02/03/2023 15:26

namespace CoreSlim\Stats;

class StatsBase
{
    public $key = null;

    public function __construct($key)
    {
        $this->key = $key;

        if (!$this->check()) {
            $this->create();
        }
    }

    public function create()
    {
        $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);
        $repository->set('key', $this->key);

        if ($repository->create()) {
            return true;
        }
    }

    public function update($value)
    {
        $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);
        $repository->setDefaultInstance('key');

        $repository->set('value', json_encode($value));

        if ($repository->update($this->key)) {
            return true;
        }
    }

    public function load()
    {
        $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);
        $repository->select('value');
        $repository->where('key', $this->key);

        if ($result = $repository->find()) {
            if (@json_decode($result['value'])) {
                return json_decode($result['value'], true);
            }
        }
    }

    public function check()
    {
        $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);

        if ($repository->compare(['key'], [$this->key])) {
            return true;
        }
    }

    public function clear()
    {
        $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);
        $repository->set('value', null);
        $repository->setDefaultInstance('key');

        if ($repository->update($this->key)) {
            return true;
        }
    }

    public function delete()
    {
        $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);
        $repository->setDefaultInstance('key');

        if ($repository->delete($this->key)) {
            return true;
        }
    }
}
