<?php

// CoreSlim - Última atualização 17/05/2023 10:19

namespace CoreSlim;

use CoreSlim\Tools;

trait Session
{
    public static function getNameSessionPrivate($name)
    {
        $session = md5(config('app.SECRET_KEY').$name);

        return $session;
    }

    public static function createSessionPrivate($name)
    {
        $session = self::getNameSessionPrivate($name);

        if (self::hasNotSession($session)) {
            $data['create'] = date('Y-m-d H:i:s');
            $data['provider'] = $name;

            self::setSession($session, $data);
        }
    }

    public static function setSessionPrivate($private, $group, $data, $overwrite = true)
    {
        if (self::hasSessionPrivate($private)) {
            $session = self::getSessionPrivate($private, []);
            $session['update'] = date('Y-m-d H:i:s');

            if ($overwrite) {
                $session[$group] = $data;
            }
            else {
                if (!array_key_exists($group, $session)) {
                    $session[$group] = $data;
                }
            }

            self::setSession(self::getNameSessionPrivate($private), $session);
        }
    }

    public static function hasSessionPrivate($private, $array = null)
    {
        if (self::hasSession(self::getNameSessionPrivate($private))) {
            if (!is_null($array)) {
                if (!self::getSessionPrivate($private, $array, false)) {
                    return false;
                }
            }

            return true;
        }
    }

    public static function getSessionPrivate($private, $array, $force = true)
    {
        if (self::hasSessionPrivate($private)) {
            $session = self::getSession(self::getNameSessionPrivate($private));

            return Tools::getArray($session, $array, $force);
        }
    }

    public static function deleteSessionPrivate($private, $group = null, $params = null)
    {
        if (self::hasSessionPrivate($private)) {
            if (!is_null($group)) {
                if (array_key_exists($group, $_SESSION[$private])) {
                    if (!$params) {
                        unset($_SESSION[$private][$group]);
                    }
                    else {
                        if (!is_array($params)) {
                            if (array_key_exists($params, $_SESSION[$private][$group])) {
                                unset($_SESSION[$private][$group][$params]);
                            }
                        }
                        else {
                            foreach ($params as $params) {
                                if (array_key_exists($param, $_SESSION[$private][$group])) {
                                    unset($_SESSION[$private][$group][$param]);
                                }
                            }
                        }
                    }
                }
            }
            else {
                self::clearSession($private);
            }
        }
    }

    public static function setSession($session, $data)
    {
        $_SESSION[$session] = $data;
    }

    public static function getSession($session)
    {
        if (self::hasSession($session)) {
            return $_SESSION[$session];
        }
    }

    public static function hasSession($session)
    {
        if (isset($_SESSION)) {
            if (array_key_exists($session, $_SESSION)) {
                return true;
            }
        }
    }

    public static function hasNotSession($session)
    {
        if (isset($_SESSION)) {
            if (!array_key_exists($session, $_SESSION)) {
                return true;
            }
        }
    }

    public static function clearSession($session)
    {
        if (self::hasSession($session)) {
            unset($_SESSION[$session]);
        }
    }
}
