<?php

// CoreSlim - Última atualização 05/09/2023 11:16

namespace CoreSlim;

use CoreSlim\Request;

class Pagination
{
    public $locale = null;
    public $query = null;
    public $queryLimit = null;
    public $item = 5;
    public $page = 1;
    public $total = null;
    public $keyPage = null;

    public function __construct($setParams = [])
    {
        if (isset($setParams['locale'])) {
            $this->locale = $setParams['locale'];
        }

        if (isset($setParams['item'])) {
            $this->item = $setParams['item'];
        }

        if (isset($setParams['query'])) {
            $this->query = $setParams['query'];
        }

        if (is_null($this->locale)) {
            $this->locale = lang('site::default.pagination');
        }
    }

    public function execute()
    {
        $this->setPage();

        $database = new Database();
        $queryTotal = $database->dbNumRows($this->query);

        if ($queryTotal) {
            $this->total = intval($queryTotal);

            $this->queryLimit = ($this->page - 1) * $this->item.','.$this->item;

            return $this->query.' LIMIT '.$this->queryLimit;
        }

        return $this->query;
    }

    public function setPage()
    {
        if ($page = Request::get($this->locale[1])) {
            $this->page = intval($page);
        }
    }

    public function navigation($provider = null, $notVars = null)
    {
        $dataReturn = null;

        if ($this->page > 1) {
            $dataReturn['prev'] = [
                'title' => $this->locale[2],
                'link' => $this->setNewPath($this->page - 1, $provider, $notVars),
                'class' => null
            ];
        }
        else {
            $dataReturn['prev'] = [
                'title' => $this->locale[3],
                'link' => '#',
                'class' => 'disabled'
            ];
        }

        for ($index = ($this->page - 3); $index <= ($this->page + 3); $index++) {
            if ($index == $this->page) {
                $dataReturn['pages'][] = [
                    'title' => $index,
                    'label' => $this->locale[4].' '.$index,
                    'link' => $this->setNewPath($index, $provider, $notVars),
                    'class' => 'active'
                ];
            }
            else {
                if ($index >= 1 && $index <= ceil($this->total / $this->item)) {
                    $dataReturn['pages'][] = [
                        'title' => $index,
                        'label' => $this->locale[4].' '.$index,
                        'link' => $this->setNewPath($index, $provider, $notVars),
                        'class' => null
                    ];
                }
            }
        }

        if ($this->page < ceil($this->total / $this->item)) {
            $dataReturn['next'] = [
                'title' => $this->locale[5],
                'link' => $this->setNewPath($this->page + 1, $provider, $notVars),
                'class' => null
            ];
        }
        else {
            $dataReturn['next'] = [
                'title' => $this->locale[6],
                'link' => '#',
                'class' => 'disabled'
            ];
        }

        return $dataReturn;
    }

    public function setNewPath($page, $provider, $notVars = null)
    {
        return Request::injectVars(null, [[$this->locale[1] => $page]], $notVars);
    }
}
