<?php

// CoreSlim - Última atualização 02/03/2023 15:26

namespace CoreSlim;

use CoreSlim\Tools;

class Filesystem
{
    public $sentence = null;

    public $folderPrimary = null;

    public $cache = [];

    public function __construct($sentence, $folderFile, $lang = false)
    {
        $this->init($sentence, $folderFile, $lang);
    }

    public function setSentence(array $values)
    {
        array_values($values);

        $this->sentence = $values;
    }

    public function unsetSentence($key)
    {
        if (isset($this->sentence[$key])) {
            unset($this->sentence[$key]);

            $this->sentence = array_values($this->sentence);
        }
    }

    public function setFolderPrimary($folder)
    {
        $this->folderPrimary = $folder;
    }

    public function init($sentence, $folderFile, $lang)
    {
        $varsConfigCore = varsConfigCore();

        $folder = $varsConfigCore['BASE_ROOT'].'/app';
        $folderDefault = $varsConfigCore['BASE_ROOT'].'/bootstrap';

        $sentenceProvider = explode('::', $sentence);

        if (count($sentenceProvider) == 2) {
            $folder = $folder.'/'.$sentenceProvider[0].'/'.$folderFile;

            $this->setSentence(explode('.', $sentenceProvider[1]));
        }
        else {
            $this->setSentence(explode('.', $sentenceProvider[0]));

            $folder = $folderDefault.'/'.$folderFile;
        }

        if ($lang) {
            $folder = $folder.'/'.config('app.LANG');
        }

        $this->setFolderPrimary($folder);
    }

    public function search()
    {
        if (is_array($this->sentence) && isset($this->sentence[0])) {
            if ($this->isDir($this->sentence[0])) {
                return $this->search();
            }
            else if ($file = $this->isFile($this->sentence[0])) {
                return $file;
            }
        }
    }

    public function isDir($fragment)
    {
        $folder = $this->folderPrimary.'/'.$fragment;

        if (is_dir($folder)) {
            $this->setFolderPrimary($folder);

            $this->unsetSentence(0);

            return true;
        }
    }

    public function isFile($fragment)
    {
        $file = $this->folderPrimary.'/'.$fragment.'.php';

        if (file_exists($file)) {
            $this->unsetSentence(0);

            $vars = include $file;

            return Tools::getInArray($vars, $this->sentence);
        }
    }

    public static function getConfig($sentence)
    {
        $filesystem = new Filesystem($sentence, 'config');

        $search = $filesystem->search();

        if ($search) {
            return $search;
        }
    }

    public static function getGlobalConfig($sentence)
    {
        $filesystem = new Filesystem($sentence, 'config');

        $search = $filesystem->search();

        if ($search) {
            return $search;
        }

        return $sentence;
    }

    public static function getConfigMerged($sentence = null, $method = null, $controller = null, $instance = null)
    {
        $sentenceMethod = $instance.'::controllers.'.$controller.'.methods.'.$method;

        if ($sentence) {
            $sentenceMethod = $sentenceMethod.'.'.$sentence;
        }

        $lang = self::mergeConfigDefault($sentenceMethod);

        if ($lang == $sentenceMethod) {
            $sentenceController = $instance.'::controllers.'.$controller.'.'.$sentence;

            $lang = self::getConfig($sentenceController);
        }

        return $lang;
    }

    public static function mergeConfigDefault($sentence)
    {
        $configDefault  = null;

        $explode = explode('methods.', $sentence);

        $configProvider = self::getConfig($sentence);

        if (count($explode) == 2) {
            $configDefault = self::getConfig('doop::defaults.methods.'.$explode[1]);

            if (!is_array($configProvider)) {
                $configProvider = [];
            }

            if (is_array($configDefault)) {
                $configProvider = array_replace_recursive($configDefault, $configProvider);
            }
        }

        if (is_array($configProvider) && count($configProvider) == 0) {
            return $sentence;
        }

        return $configProvider;
    }

    public static function getLang($sentence)
    {
        $filesystem = new Filesystem($sentence, 'lang', true);

        $search = $filesystem->search();

        if ($search) {
            return $search;
        }
    }

    public static function getGlobalLang($sentence, $acceptRoute = null)
    {
        $filesystem = new Filesystem(self::prepareSentenceGlobal($sentence, $acceptRoute), 'lang', true);

        $search = $filesystem->search();

        if ($search) {
            return $search;
        }

        $filesystem = new Filesystem($sentence, 'lang', true);

        $search = $filesystem->search();

        if ($search) {
            return $search;
        }

        return $sentence;
    }

    public static function mergeSentence($sentence)
    {
        $langMerge = $configMerge = null;

        $langMerge = self::getLangMerged($sentence, $method, $controller, $instance);
        $configMerge = self::getConfigMerged($sentence, $method, $controller, $instance);

        if (is_array($langMerge) && is_array($configMerge)) {
            return array_replace_recursive($langMerge, $configMerge);
        }
    }

    public static function increment($folder, $filename, $extension = null, $min = true, $version = true)
    {
        $path = $folder.'/'.$filename;

        if ($version) {
            $path = $path.'-'.config('app.VERSION_ASSETS');
        }

        if ($min) {
            $path = $path.'.min';
        }

        if ($extension) {
            $path = $path.'.'.$extension;
        }

        return $path;
    }

    public static function css($filename, $folderPrivate = 'provider', $min = true, $version = true)
    {
        return self::increment(config('app.PATH_PUBLIC').'/assets/'.$folderPrivate.'/css', $filename, 'css', $min, $version);
    }

    public static function js($filename, $folderPrivate = 'provider', $min = true, $version = true)
    {
        return self::increment(config('app.PATH_PUBLIC').'/assets/'.$folderPrivate.'/js', $filename, 'js', $min, $version);
    }

    public static function img($filename, $folderPrivate = 'provider')
    {
        return self::increment(config('app.PATH_PUBLIC').'/assets/'.$folderPrivate.'/img', $filename, null, false, false);
    }

    public static function prepareLangProviderMethod($sentence, $acceptRoute = null)
    {
        $langPrepare = self::prepareSentenceGlobal($sentence, $acceptRoute);

        return $langPrepare;
    }

    public static function check($sentence)
    {
        $filesystem = new Filesystem($sentence, 'lang', true);

        $search = $filesystem->search();

        if ($search) {
            return $sentence;
        }
    }

    public static function prepareSentenceGlobal($sentence, $acceptRoute = null, $folderPrimary = 'controllers', $folderSecondary = 'methods')
    {
        $langSentence = $sentence;

        $ARROBA = explode('@', $sentence);

        if (count($ARROBA) > 1 && $acceptRoute) {
            if ($ARROBA[0]) {
                $DOISPONTOS = explode('::', $ARROBA[0]);
            }
            else {
                $DOISPONTOS = explode('::', $ARROBA[1]);
            }

            if (count($DOISPONTOS) == 1) {
                $PONTO = explode('.', $DOISPONTOS[0]);

                $instance = $PONTO[0];
                $controller = $PONTO[1];

                unset($PONTO[0], $PONTO[1]);
            }
            else if (count($DOISPONTOS) == 2 && $acceptRoute) {
                $instance = $acceptRoute['instance'];
                $controller = $DOISPONTOS[0];

                $PONTO = explode('.', $DOISPONTOS[1]);
            }

            if ($folderPrimary) {
                $langSentence = $instance.'::'.$folderPrimary.'.';
            }

            $langSentence .= $controller;

            if ($folderSecondary) {
                $langSentence .= '.'.$folderSecondary;
            }

            if (count($PONTO) > 0) {
                $langSentence = $langSentence.'.'.implode('.', $PONTO);
            }
        }
        else {
            $DOISPONTOS = explode('::', $sentence);

            if (count($DOISPONTOS) == 2) {
                $langSentence = $sentence;
            }
        }

        return $langSentence;
    }

    public static function sentenceCallback($sentence, $acceptRoute)
    {
        $sentence = self::prepareSentenceGlobal($sentence, $acceptRoute, 'controllers', 'callbacks');

        return $sentence;
    }
}
