<?php

// CoreSlim - Última atualização 02/03/2023 15:26

namespace CoreSlim;

class Email
{
    public $config = [
        'template' => 'default.html',
        'form' => 'pageConfigFormDefault',
        'callback' => null,
        'to' => null,
        'reply' => null,
        'cc' => null,
        'title' => null,
        'title_full' => false,
        'body' => null,
        'params' => null,
        'data' => null,
        'container_header' => true,
        'container_footer' => true,
        'path_header' => null,
        'path_footer' => null,
        'smtp' => false,
        'configForm' => false,
        'emailVars' => null,
        'colors' => [
            'primary' => null
        ]
    ];

    public $attachment = null;

    public function __construct()
    {
        $this->config['colors']['primary'] = config('app.COLOR_PRIMARY_COMPANY');
    }

    public function setConfig($key, $parameter)
    {
        $this->config[$key] = $parameter;
    }

    public function getConfig($key)
    {
        if (array_key_exists($key, $this->config)) {
            return $this->config[$key];
        }
    }

    public function setColors($key, $parameter)
    {
        $this->config['colors'][$key] = $parameter;
    }

    public function processMail($string)
    {
        return strtolower($string);
    }

    public function processMailString($string)
    {
        return Treatment::string($string);
    }

    public function send()
    {
        if (!$this->getConfig('configForm')) {
            $repository = new Repository('base', ['prefixKey' => 'sis']);

            $configForm = $repository->base($this->getConfig('form'));
        }
        else {
            $configForm = $this->getConfig('configForm');
        }

        if (!$this->getConfig('smtp')) {
            $repository = new Repository('base', ['prefixKey' => 'sis']);

            $smtp = $repository->base('pageSmtp');
        }
        else {
            $smtp = $this->getConfig('smtp');
        }

        $mail = new \PHPMailer\PHPMailer\PHPMailer;
        $mail->clearAddresses();
        $mail->isSMTP();
        $mail->isHTML(true);
        $mail->CharSet = 'utf-8';
        $mail->Host = $smtp['host'];
        $mail->Port = $smtp['port'];
        $mail->SMTPSecure = $smtp['secure'];
        $mail->SMTPAuth = true;
        $mail->Username = Treatment::string($smtp['user']);
        $mail->Password = Treatment::string($smtp['password']);

        $configForm['emailFrom'] = $this->processMail($configForm['emailFrom']);
        $configForm['nameFrom'] = $this->processMailString($configForm['nameFrom']);

        $configForm['emailTo'] = $this->processMail($configForm['emailTo']);
        $configForm['nameTo'] = $this->processMailString($configForm['nameTo']);

        $mail->setFrom($configForm['emailFrom'], $configForm['nameFrom']);

        if (!$to = $this->getConfig('to')) {
            if (is_array($this->getConfig('reply'))) {
                $reply = $this->getConfig('reply');

                $mail->addReplyTo($this->processMail($reply[0]), $this->processMailString($reply[1]));
            }

            $mail->addAddress($configForm['emailTo'], $configForm['nameTo']);

            if ($configForm['nameCC'] && $configForm['emailCC']) {
                $name = $configForm['nameCC'];
                $email = $configForm['emailCC'];

                for ($i = 0; $i < count($name); $i++) {
                    $mail->addCC($this->processMail($email[$i]), $this->processMailString($name[$i]));
                }
            }
        }
        else {
            $mail->addAddress($this->processMail($to[0]), $this->processMailString($to[1]));

            $mail->addReplyTo($configForm['emailTo'], $configForm['nameTo']);
        }

        $configForm['header'] = $this->processMailString($configForm['header']);

        $subject = $this->getSubject($configForm['header']);

        $mail->Subject = $subject;

        if (is_array($this->getConfig('emailVars'))) {
            $this->setConfig('template', 'basic.html');

            $mail->Body = $this->getBodyBasic();
        }
        else {
            $mail->Body = $this->getBody($subject);
        }

        if (is_array($this->attachment)) {
            foreach ($this->attachment as $key => $value) {
                $mail->addAttachment($value['path'], $value['name']);
            }
        }

        return $this->executeSend($mail);
    }

    public function executeSend($mail)
    {
        if ($mail->send()) {
            unset($mail);

            return true;
        }
        else {
            dd($mail);
            return false;
        }
    }

    public function getSubject($subject)
    {
        $manipuleTitle = $this->getConfig('title');

        if ($manipuleTitle && !$this->getConfig('title_full')) {
            $subject = $subject . ' ' . $manipuleTitle;
        }
        else if ($manipuleTitle && $this->getConfig('title_full')) {
            $subject = $manipuleTitle;
        }

        return $this->processMailString($subject);
    }

    public function getBody($subject)
    {
        $assets = $this->repository->base('assets');

        $file = config('app.ROOT_SITE').'/template/emails/'.$this->getConfig('template');
        $template = fread(fopen($file, 'r'), filesize($file));

        $bodyConfig = $this->getConfig('body');

        $data[] = ['content_subject', $subject];
        $data[] = ['content_body', $bodyConfig];

        $container_header = null;

        if ($this->getConfig('container_header')) {
            $container_header = '
                <a href="%%path_root%%" title="%%path_root%%" target="_blank"><img src="%%path_header%%" style="display:block;" /></a>
            ';

            $template = str_replace('%%container_header%%', $container_header, $template);
        }
        else {
            $template = str_replace('%%container_header%%', '', $template);
        }

        $container_footer = null;

        if ($this->getConfig('container_footer')) {
            $container_footer = '
                <a href="%%path_root%%" title="%%path_root%%" target="_blank"><img src="%%path_footer%%" style="display:block;" /></a>
            ';

            $template = str_replace('%%container_footer%%', $container_footer, $template);
        }
        else {
            $template = str_replace('%%container_footer%%', '', $template);
        }

        if (is_null($this->getConfig('path_header'))) {
            $filename = $assets['emailheader']['file']['name'];

            $file = config('app.PATH_UPLOAD').'/configuration/images/'.$filename;

            $path_header = $file;
        }
        else {
            $path_header = $this->getConfig('path_header');
        }

        if (is_null($this->getConfig('path_footer'))) {
            $filename = $assets['emailfooter']['file']['name'];

            $file = config('app.PATH_UPLOAD').'/configuration/images/'.$filename;

            $path_footer = $file;
        }
        else {
            $path_footer = $this->getConfig('path_footer');
        }

        $data[] = ['path_header', $path_header];
        $data[] = ['path_footer', $path_footer];
        $data[] = ['path_root', BASE_PATH];

        foreach ($data as $key => $value) {
            $template = str_replace('%%'.$value[0].'%%', $value[1], $template);
        }

        $body = stripslashes($template);

        return $body;
    }

    public function getBodyBasic()
    {
        $file = config('app.ROOT_SITE').'/template/emails/'.$this->getConfig('template');

        $template = fread(fopen($file, 'r'), filesize($file));

        $emailVars = $this->getConfig('emailVars');

        foreach ($emailVars as $key => $value) {
            $template = str_replace('%%'.$key.'%%', $value, $template);
        }

        if (is_null($emailVars['button_link']) && is_null($emailVars['button_label'])) {
            $template = str_replace('%%button_active%%', 'display: none;', $template);
        }
        else {
            $template = str_replace('%%button_active%%', '', $template);
        }

        $template = str_replace('%%color_primary%%', $this->config['colors']['primary'], $template);

        $body = stripslashes($template);

        return $body;
    }

    public function setAnexx($path, $name = '')
    {
        $this->attachment[] = [
            'path' => $path,
            'name' => $name
        ];
    }

    public function signature($type = 'signature_label')
    {
        if ($type == 'signature_label') {
            $repository = new Repository('base', ['prefixKey' => 'sis']);

            $site = $repository->base('pageSite');

            return date('Y').' &copy; '.$site['title'];
        }
        else if ($type == 'signature_link') {
            return Request::permalink();
        }
        else if ($type == 'company') {
            $repository = new Repository('base', ['prefixKey' => 'sis']);

            $site = $repository->base('pageSite');

            return $site['title'];
        }
    }
}
