<?php

// CoreSlim - Última atualização 02/03/2023 15:26

namespace CoreSlim;

class Assets
{
    public static function loadThumb($file, $folder, $type = null, $extra = null, $oldSystem = false)
    {
        $image = null;

        if ($file) {
            if (is_array($file)) {
                if (array_key_exists('name', $file)) {
                    $image = self::systemThumb($file, $folder, $type, $oldSystem);
                }
                else if (array_key_exists($extra[1], $file)) {
                    $image = self::avatarThumbSrc($file, $extra);
                }
            }
            else if (@json_decode($file)) {
                $file = json_decode($file, true);

                if (array_key_exists('name', $file)) {
                    $image = self::systemThumb($file, $folder, $type, $oldSystem);
                }
                else if (array_key_exists($extra[1], $file)) {
                    $image = self::avatarThumbSrc($file, $extra);
                }
            }
            else if ($file) {
                $image = self::systemThumb($file, $folder, $type, $oldSystem);
            }
        }

        if ($extra === 'system' && !$image) {
            $repository = new \CoreSlim\Repository('base', ['prefixKey' => 'sis']);

            $assets = $repository->base('pageAssets');

            $noimage = $assets['noimage']['file']['name'];

            $pathRoot = config('app.ROOT_UPLOAD').'/configuration/images/default/'.$noimage;
            $pathWeb = config('app.PATH_UPLOAD').'/configuration/images/default/'.$noimage;

            if ($noimage && file_exists($pathRoot) && $noimage) {
                $image['image'] = self::getImageSizeAllFiles($pathRoot);
                $image['image']['src'] = $pathWeb;
            }
        }

        if (is_array($extra) && !$image) {
            $noimage = $extra[0];

            $pathRoot = config('app.ROOT_SITE').'/public/img/'.$noimage;
            $pathWeb = config('app.PATH_SIT').'/public/img/'.$noimage;

            if (file_exists($pathRoot) && $noimage) {
                $image['image'] = self::getImageSizeAllFiles($pathRoot);
                $image['image']['src'] = $pathWeb;
            }
        }

        return $image;
    }

    public static function systemThumb($file, $folder, $type, $oldSystem = false)
    {
        $image = null;

        if ($oldSystem === false) {
            $folder = $folder.'/images';
        }

        $image = self::defineFilesImage($folder, $file, [$type], $oldSystem);

        if (!is_array($image)) {
            $image = self::defineFilesImage($folder, $file, ['', 'original', 'temp'], $oldSystem);
        }

        return $image;
    }

    public static function defineFilesImage($folderPrimary, $file, $sequenceFolders, $oldSystem)
    {
        if (is_array($file) && array_key_exists('name', $file)) {
            $fileArray = self::webpConvertSite($file['name'], $folderPrimary);
        }
        else {
            $fileArray = self::webpConvertSite($file, $folderPrimary);
        }

        $image = null;
        $exists = false;

        foreach ($sequenceFolders as $folder) {
            if (!$exists) {
                foreach ($fileArray as $keyArray => $filename) {
                    if (!is_null($filename)) {
                        if ($folder && $folder != '') {
                            $path_file = config('app.ROOT_UPLOAD').'/'.$folderPrimary.'/'.$folder.'/'.$filename;
                            $web_file = config('app.PATH_UPLOAD').'/'.$folderPrimary.'/'.$folder.'/'.$filename;
                        }
                        else {
                            $path_file = config('app.ROOT_UPLOAD').'/'.$folderPrimary.'/'.$filename;
                            $web_file = config('app.PATH_UPLOAD').'/'.$folderPrimary.'/'.$filename;
                        }

                        if (file_exists($path_file)) {
                            $finfo = new \finfo(FILEINFO_MIME_TYPE);

                            if ($oldSystem === false) {
                                $image[$keyArray] = self::getImageSizeAllFiles($path_file);
                                $image[$keyArray]['src'] = $web_file;
                                $image[$keyArray]['mimetype'] = $finfo->file($path_file);
                            }
                            else {
                                $image = self::getImageSizeAllFiles($path_file);
                                $image['src'] = $web_file;
                                $image['mimetype'] = $finfo->file($path_file);
                            }

                            $exists = true;
                        }
                    }
                }
            }
        }

        return $image;
    }

    public static function getImageSizeAllFiles($file)
    {
        $dataReturn['width'] = 0;
        $dataReturn['height'] = 0;

        if (file_exists($file)) {
            if (!$getImageSize = @getimagesize($file)) {
                $img = @imagecreatefromwebp($file);

                if ($img) {
                    $dataReturn['width'] = imagesx($img);
                    $dataReturn['height'] = imagesy($img);
                }
            }

            else {
                if (array_key_exists(0, $getImageSize) && array_key_exists(1, $getImageSize)) {
                    $dataReturn['width'] = $getImageSize[0];
                    $dataReturn['height'] = $getImageSize[1];
                }
            }
        }

        return $dataReturn;
    }

    public static function webpConvertSite($file, $folder)
    {
        if (is_array($file)) {
            $nameArray = explode('.', $file['name']);

            $name = $nameArray[0];
            $extension = end($nameArray);
        }
        else {
            $nameArray = explode('.', $file);

            $name = $nameArray[0];
            $extension = end($nameArray);
        }

        $dataimage['image'] = $name.'.'.$extension;

        $dataimage['webp'] = $name.'.webp';


        return $dataimage;
    }

    public static function deleteImages($fileName, $folderModule)
    {
        $name = explode('.', $fileName);

        if (is_array($name)) {
            $exts = [$name[1], 'webp'];
            $folders = ['default', 'temp', 'thumb', 'smaller', 'larger'];

            foreach ($folders as $folder) {
                if ($folder == 'default') {
                    $dir = config('app.ROOT_UPLOAD').'/'.$folderModule.'/images';
                }
                else {
                    $dir = config('app.ROOT_UPLOAD').'/'.$folderModule.'/images/'.$folder;
                }

                foreach ($exts as $ext) {
                    $file = $dir.'/'.$name[0].'.'.$ext;

                    if (file_exists($file)) {
                        unlink($file);
                    }
                }
            }
        }
    }

    public static function extraPhoto($key, $tuple, $params, $zoom = true)
    {
        $limit = 500;

        if ($params['limit']) {
            $limit = $params['limit'];
        }

        $repository = new Repository('photo', 'sub');
        $repository->setArray(['file', 'legend', 'credit']);

        $repository->where('table', 'mod_'.$key);
        $repository->whereAnd('tuple', $tuple);
        $repository->whereAnd('status', 'active');

        $repository->orderBy('order');
        $repository->limit($limit);

        $index = 0;
        $dataReturn = null;

        if ($result = $repository->all()) {
            if ($params['title']) {
                $dataReturn['info']['title'] = Treatment::string($params['title'], 'text');
            }
            else {
                $extra = $this->getExtra('global');

                $dataReturn['info']['title'] = Treatment::string($extra['additional']['gallery-photo'], 'text');
            }

            if ($params['cols']) {
                $dataReturn['info']['cols'] = $params['cols'];
            }

            foreach ($result as $key => $value) {
                $dataReturn['gallery'][$index]['title'] = Treatment::string($value['legend'], 'text');

                if ($value['credit'] != '') {
                    if ($value['legend'] != '') {
                        $dataReturn['gallery'][$index]['title'] .= ' - ';
                    }

                    $dataReturn['gallery'][$index]['title'] .= Treatment::string($value['credit'], 'text');
                }

                if (@json_encode($value['file'])) {
                    $photoJson = json_decode($value['file'], true);

                    $value['file'] = $photoJson['name'];
                }

                if ($zoom != false) {
                    $dataReturn['gallery'][$index]['original'] = self::loadThumb($value['file'], $key, 'larger');
                }

                $dataReturn['gallery'][$index]['thumb'] = self::loadThumb($value['file'], $key, 'smaller');

                $index++;
            }

            return $dataReturn;
        }
    }

    public static function getVideo($parameter, $type = null)
    {
        $return = null;

        if (@json_encode($parameter)) {
            $newParamater = json_decode($parameter, true);

            $parameter = $newParamater['code'];
            $type = $newParamater['type'];
        }

        if ($type === 'youtube') {
          if (isset($newParamater['list'])) {
                $return['url'] = 'https://www.youtube.com/embed/videoseries?list='.$newParamater['list'];
                $return['embed'] = '//www.youtube.com/embed/videoseries?list='.$newParamater['list'];
                $return['code'] = $parameter;

                if (isset($newParamater['index'])) {
                    $return['url'] = 'https://www.youtube.com/embed/videoseries?list='.$newParamater['list'].'&index='.$newParamater['index'];
                    $return['embed'] = '//www.youtube.com/embed/videoseries?list='.$newParamater['list'].'&index='.$newParamater['index'];
                    $return['code'] = $parameter;
                }
            }
            else {
                $return['url'] = 'https://www.youtube.com/watch?v='.$parameter;
                $return['embed'] = '//www.youtube.com/embed/'.$parameter;
                $return['code'] = $parameter;
            }
        }
        else if ($type === 'vimeo') {
            $return['url'] = 'https://vimeo.com/'.$parameter;
            $return['embed'] = '//player.vimeo.com/video/'.$parameter.'?badge=0&amp;color=ffffff';
            $return['code'] = $parameter;
        }

        $return['type'] = $type;

        return $return;
    }

    public static function getVideoThumbnail($parameter, $typeImage = 'hq')
    {
        $return = null;

        if (@json_encode($parameter)) {
            $newParamater = json_decode($parameter, true);

            $parameter = $newParamater['code'];
            $type = $newParamater['type'];
        }

        if ($type === 'youtube') {
            switch ($typeImage) {
                case 'hq':
                    $return['url'] = 'https://img.youtube.com/vi/'.$parameter.'/hqdefault.jpg';
                break;

                default:
                    $return['url'] = 'https://img.youtube.com/vi/'.$parameter.'/default.jpg';
                break;
            }
        }
        else if ($type === 'vimeo') {
            $vimeo = unserialize(file_get_contents('http://vimeo.com/api/v2/video/'.$parameter.'.php'));

            $return['url'] = $vimeo[0]['thumbnail_large'];
        }

        return $return;
    }

    public static function avatarThumbSrc($file, $extra)
    {
        $image = null;

        if (array_key_exists($extra[1], $file)) {
            $image = ['src' => $file[$extra[1]]];
        }

        return $image;
    }

    public static function setVideoTemplate($url)
    {
        if (strpos($url, 'youtube.com')) {
            $urlParse = parse_url($url);

            if (array_key_exists('query', $urlParse)) {
                $vid = parse_str($urlParse['query'], $output);

                $id_video = $output['v'];

                $data['type'] = 'youtube';
                $data['code'] = $id_video;

                return json_encode($data);
            }
        }
        else if(strpos($url, 'youtu.be')) {
            $urlParse = parse_url($url);

            if (array_key_exists('path', $urlParse)) {
                $data['type'] = 'youtube';
                $data['code'] = str_replace('/', '', $urlParse['path']);

                return json_encode($data);
            }
        }
        else if (strpos($url, 'vimeo.com')) {
            $id_video = explode('vimeo.com/', $url);
            $id_video = $id_video[1];

            $data['type'] = 'vimeo';
            $data['code'] = $id_video;

            return json_encode($data);
        }
        else {
            return null;
        }
    }
}
