<?php

class Services extends ModulesInstanceSite
{
    public $key = 'services';

    public function __construct($controller)
    {
        parent::__construct($controller);

        $instanceModule = $this->getInfoAllModule($this->key);

        if (isset($instanceModule['scope'])) {
            $this->keyLang = [
                'archive' => $instanceModule['scope']['key'],
                'view' => $instanceModule['scope']['key_view']
            ];
        }
    }

    public function archive()
    {
        $dataReturn = null;

        $this->type = 'archive';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('archive'));

        $searchAction = false;

        if ($querySearch = $this->search()) {
            if (is_array($querySearch)) {
                $dataReturn = $querySearch;

                $searchAction = true;
            }
            else if ($querySearch == 'execute-search') {
                $searchAction = true;
            }
        }

        if (!$searchAction) {
            $dataReturn = $this->loadData(null, "`order_".$module->sufix."`", 12);
        }

        $dataReturn['page'] = $module->manipulePage();

        $module->setOpenGraph($dataReturn);

        if (!$searchAction) {
            $dataReturn['actions']['search']['placeholder'] = 'Pesquise em serviços...';
        }
        else {
            $dataReturn['actions']['search']['placeholder'] = 'Sua pesquisa: '.$_SESSION['string_search'];
        }

        $dataReturn['actions']['search']['active'] = $searchAction;
        $dataReturn['actions']['search']['title'] = 'Clique para pesquisar em serviços';
        $dataReturn['actions']['search']['action'] = Request::injectVars($this->locale['key'], [['pesquisa' => 'sim']]);

        unset($module);

        return $dataReturn;
    }

    public function view()
    {
        $dataReturn = null;

        $this->type = 'view';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('view'));

        $dataReturn = $this->loadData("AND `slug_".$module->sufix."` = '".Request::seo(2)."'", "`order_".$module->sufix."`", 1, true, $module);

        $dataReturn['page'] = $module->manipulePage();

        $dataReturn['page']['breadcrumb'][] = [
            'key' => $this->locale['key'].'-'.$dataReturn['data']['slug'],
            'title' => $dataReturn['data']['title'],
            'url' => $dataReturn['data']['url']
        ];

        //$dataReturn['page']['header']['title'] = $dataReturn['data']['title'];
        $dataReturn['page']['header']['url'] = $dataReturn['data']['url'];

        $module->setOpenGraph($dataReturn);

        $dataReturn['og'] = $module->og;

        $core = $this->controller()->render()->getVars('core');

        $dataReturn['othersData'] = $this->others($dataReturn['data']['id']);

        unset($module);

        return $dataReturn;
    }

    public function index()
    {
        $dataReturn = null;

        $this->type = 'index';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $dataReturn = $this->loadData(null, "`order_".$module->sufix."`", 9, false, $module);

        unset($dataReturn['pagination']);

        $dataReturn['page'] = $module->manipulePage();

        unset($module);

        return $dataReturn;
    }

    public function others($idNot)
    {
        $dataReturn = null;

        $this->type = 'index';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $dataReturn = $this->loadData("AND `id_".$module->sufix."` <> '".$idNot."'", "`order_".$module->sufix."`", 10);
        $dataReturn['page'] = $module->manipulePage();

        unset($dataReturn['page']['breadcrumb']);
        unset($dataReturn['pagination']);

        unset($module);

        $dataReturn['page']['header']['title'] = '+ '.$dataReturn['page']['header']['title'];

        return $dataReturn;
    }

    public function loadData($where, $orderby, $limit = 12, $view = false, $module = null)
    {
        $controller = $this->controller();
        $database = $this->database();

        $database->setTable('mod_services');
        $database->setSufix('services');

        $query = "SELECT `id_services` as id,
                         `title_services` as title,
                         `slug_services` as slug,
                         `subtitle_services` as subtitle,
                         `text_services` as text,
                         `cover_services` as cover,
                         `user_services` as user
                  FROM `mod_services`
                  WHERE `status_services` = 'active' ".$where."
                  ORDER BY ".$orderby;

        $pagination = new \CoreSlim\PaginationGet([
            'locale' => $controller->locale['pagination'],
            'item' => $limit,
            'query' => $query
        ]);

        $result = $database->dbFetchAll($pagination->execute());

        if ($result) {
            foreach ($result as $key => $value) {
                if ($module) {
                    foreach($module->features as $keyFeatures => $params) {
                        if ($module->features[$keyFeatures]['active'] && array_key_exists('id', $value)) {
                            $box = $module->extraBox($module->features[$keyFeatures]['key'], $value['id'], $params);

                            if ($box) {
                                $dataReturn['data'][$key][$keyFeatures] = $box;
                            }
                        }
                    }
                }

                if (isset($dataReturn['data'][$key]['galleryVideo'])) {
                    $dataReturn['data'][$key]['galleryVideo']['info']['title'] = null;
                    $dataReturn['data'][$key]['galleryVideo']['info']['cols'] = 'flex-content-grid-12';
                }

                $dataReturn['data'][$key]['id'] = $dataReturn['data'][$key]['value'] = intval($value['id']);
                $dataReturn['data'][$key]['slug'] = $value['slug'];

                $dataReturn['data'][$key]['title'] = Treatment::string($value['title']);
                $dataReturn['data'][$key]['label'] = Treatment::string($value['title']);
                $dataReturn['data'][$key]['subtitle'] = Treatment::string($value['subtitle'], 'text');

                $dataReturn['data'][$key]['text'] = Treatment::string($value['text'], 'text');
                $dataReturn['data'][$key]['url'] = Request::permalink($this->keyLang['view'].'/'.$value['slug']);

                $dataReturn['data'][$key]['thumb'] = Assets::loadThumb($value['cover'], 'services', 'thumb');
                $dataReturn['data'][$key]['original'] = Assets::loadThumb($value['cover'], 'services', 'default');

                $dataReturn['data'][$key]['jsonin'] = Tools::jsonEncode($dataReturn['data'][$key]);
            }

            $dataReturn['pagination'] = $pagination->navigation($this->keyLang['archive']);

            if ($view) {
                $dataReturn['data'] = $dataReturn['data'][0];

                unset($dataReturn['pagination']);

                $this->modules()->setStats('services', $dataReturn['data']['id'], 'mod_services');
            }

            return $dataReturn;
        }
    }

    public function search($action = 'submitSearch_internal', $string = 'stringSearch_internal', $limit = 13)
    {
        $controller = $this->controller();

        if (Request::post($action) == $action) {
            $_SESSION['string_search'] = Request::post($string);

            $searchTables = ['mod_services'];

            $where = null;

            foreach ($searchTables as $table) {
                $queryRelative = "SELECT * FROM `".$table."`";

                if ($relative = $controller->database()->dbFieldsSearch($queryRelative, $table)) {
                    foreach ($relative as $key => $fieldRelative) {
                        if (isset($fieldRelative['native_type']) && ($fieldRelative['native_type'] == 'DATE' || $fieldRelative['native_type'] == 'DATETIME') && \DateTime::createFromFormat('Y-m-d H:i:s', Treatment::date($_SESSION['string_search'], 'mysql').' 00:00:00') !== false) {
                            $where[] = "(`".$fieldRelative['name']."` = '".Treatment::date($_SESSION['string_search'], 'mysql')."')";
                        }
                        else if (isset($fieldRelative['native_type']) && $fieldRelative['native_type'] == 'VAR_STRING') {
                            $where[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'])."%')";
                        }
                        else {
                            $where[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'], 'text')."%')";
                        }
                    }
                }
            }

            $_SESSION['string_query'] = "AND (".implode(' OR ', $where).")";

            $module = $this->loadData($_SESSION['string_query'], "`title_services`");

            if ($module) {
                return $module;
            }
            else {
                return 'execute-search';
            }
        }
        else if (Request::get('pesquisa') == 'sim') {
            $module = $this->loadData($_SESSION['string_query'], "`title_services`");

            if ($module) {
                return $module;
            }
        }
        else if (Request::get('pesquisa') != 'sim') {
            $_SESSION['string_search'] = null;
            $_SESSION['string_query'] = null;
        }
    }
}
