<?php

class Protocol extends ModulesInstanceSite
{
    public $key = 'protocol';
    public $keyForm = 'configFormProtocol';
    public $config = null;

    public $template = [
        'module' => 'modules/forms/protocol/index',
        'access' => 'modules/forms/protocol/access'
    ];

    public function __construct($controller, $config = null)
    {
        parent::__construct($controller, false);

        $this->setConfig($config);

        unset($controler, $config);
    }

    public function setConfig($config)
    {
        if (is_null($config)) {
            $config = $this->getExtra($this->key);
        }

        $this->config = $config;
    }

    public function route()
    {
        $controller = $this->controller();
        $database = $this->database();

        $database->setTable('ex_protocol');
        $database->setSufix('protocol');

        $controller->callback()->injectMessages($this->config['callback']);

        $this->monitorActions();

        $submitKey = 'submitAccess_protocolAccess';

        if (Request::post($submitKey) == $submitKey){
            return $this->access();
        }

        if ($this->config['scope']['key'] == Request::seo(1)) {
            return $this->view(true);
        }
    }

    public function monitorActions()
    {
        $submitKey = $this->database()->sufix('submit');

        if (Request::post($submitKey) == $submitKey){
            $this->storeProtocol();
        }
    }

    public function view($template = true)
    {
        $controller = $this->controller();

        $info = [
            'title' => $this->config['scope']['title'],
            'text' => $this->config['scope']['text'],
            'key' => $this->config['scope']['key']
        ];

        $dataReturn['module'] = parent::generatePageStatic($info);

        $dataReturn['form']['action'] = Request::permalink($this->config['scope']['key']);

        $dataReturn['date'] = date('d/m/Y');

        $controller->render()->setTemplate(parent::getTemplate('module'));

        return $dataReturn;
    }

    public function access()
    {
        $controller = $this->controller();
        $database = $this->database();

        $data = [
            'number_protocol' => Request::post('number_protocolAccess')
        ];

        $query = "SELECT * FROM `ex_protocol`
                  WHERE `protocol_protocol` = '".$data['number_protocol']."'";

        if ($database->dbNumRows($query) == 1) {
            $protocol = $database->dbFetch($query);

            $dataReturn['data'] = [
                'id' => $protocol['id_protocol'],
                'protocol' => $protocol['protocol_protocol'],
                'date' => Treatment::date($protocol['date_protocol'], 'brazil'),
                'name' => Treatment::string($protocol['name_protocol']),
                'address' => Treatment::string($protocol['address_protocol']),
                'phone' => $protocol['phone_protocol'],
                'email' => $protocol['email_protocol'],
                'notification' => Treatment::string($protocol['notification_protocol'], 'text'),
                'ip' => $protocol['ip_protocol'],
                'status' => $this->getStatus($protocol['status_protocol']),
                'time' => Treatment::date($protocol['time_protocol'], 'timestamp_brazil')
            ];

            $queryReply = "SELECT * FROM `ex_protocol-reply`
                           WHERE `protocol_protocol-reply` = '".$protocol['id_protocol']."' AND `status_protocol-reply` = 'active'";

            $replyQuery = $database->dbFetchAll($queryReply);

            if ($replyQuery) {
                foreach ($replyQuery as $id => $reply) {
                    $dataReturn['reply'][] = [
                        'text' => Treatment::string($reply['text_protocol-reply'], 'text'),
                        'time' => Treatment::date($reply['time_protocol-reply'], 'timestamp_brazil')
                    ];
                }
            }

            $dataReturn['module'] = null;

            $controller->render()->setTemplate(parent::getTemplate('access'));

            $info = [
                'title' => $this->config['scope']['title'],
                'text' => $this->config['scope']['text'],
                'key' => $this->config['scope']['key']
            ];

            $dataReturn['module'] = parent::generatePageStatic($info);

            return $dataReturn;
        }
    }

    public function storeProtocol()
    {
        $controller = $this->controller();
        $database = $controller->database();

        $params = [
            'date' => ['label' => $this->config['label']['date'], 'format' => 'date'],
            'name' => ['label' => $this->config['label']['name'], 'format' => 'string'],
            'address' => ['label' => $this->config['label']['address'], 'format' => 'string'],
            'phone' => ['label' => $this->config['label']['phone'], 'format' => 'phone'],
            'email' => ['label' => $this->config['label']['email'], 'format' => 'email'],
            'notification' => ['label' => $this->config['label']['notification'], 'format' => 'text']
        ];

        $urlCallback = Request::permalink($this->config['scope']['key']);

        if ($controller->checkFormIntegrity($database->sufix('key'), $urlCallback, true)) {
            $data = $this->loadDataPost($params);

            $dataExecute = $this->execute($data);

            $body = $this->templateEmailClient($dataExecute);

            $protocolCapture = $dataExecute[$database->sufix('protocol')];
            $emailCapture = $dataExecute[$database->sufix('email')];
            $nameCapture = $dataExecute[$database->sufix('name')];

            $email = new \CoreSlim\Email();

            $emailsVars['body_title'] = 'Olá '.Treatment::string($nameCapture, 'first-name').',';
            $emailsVars['button_link'] = Request::permalink();
            $emailsVars['button_label'] = 'ACESSAR SITE';
            $emailsVars['body_text'] = $body;
            $emailsVars['signature_label'] = $email->signature('signature_label');
            $emailsVars['signature_link'] = $email->signature('signature_link');

            $email->setConfig('template', 'basic.html');
            $email->setConfig('callback', $urlCallback);
            $email->setConfig('to', [$emailCapture, $nameCapture]);
            $email->setConfig('emailVars', $emailsVars);
            $email->setConfig('form', $this->keyForm);
            $email->setConfig('recaptcha', true);
            $email->setConfig('title', '- Protocolo: '.$protocolCapture);

            if ($email->send()) {
                $email = new \CoreSlim\Email();

                $body = $this->templateEmailServer($dataExecute);

                $emailsVars['body_title'] = 'NOVO PROTOCOLO';
                $emailsVars['button_link'] = config('app.PATH_CMS');
                $emailsVars['button_label'] = 'ACESSAR PAINEL';
                $emailsVars['body_text'] = $body;
                $emailsVars['signature_label'] = $email->signature('signature_label');
                $emailsVars['signature_link'] = $email->signature('signature_link');

                $email->setConfig('template', 'basic.html');
                $email->setConfig('callback', $urlCallback);
                $email->setConfig('reply', [$emailCapture, $nameCapture]);
                $email->setConfig('emailVars', $emailsVars);
                $email->setConfig('form', $this->keyForm);
                $email->setConfig('recaptcha', false);
                $email->setConfig('title', '- Novo Protocolo: '.$protocolCapture);

                if ($email->send()) {

                }
            }

            $controller->callback()->injectMessages($this->config['callback']);
            $controller->callback()->set('sendKey', $urlCallback);
        }
    }

    public function execute($data)
    {
        $controller = $this->controller();
        $database = $this->database();

        $database->setTable('ex_protocol');
        $database->setSufix('protocol');

        $access = Tools::generateUuid(uniqid());
        $access = explode('-', $access);

        $data[$database->sufix('uuid')] = Tools::generateUuid(uniqid());
        $data[$database->sufix('protocol')] =  $this->generateCodeProtocol();
        $data[$database->sufix('access')] = $access[0];
        $data[$database->sufix('ip')] = $_SERVER['REMOTE_ADDR'];
        $ua = parse_user_agent($_SERVER['HTTP_USER_AGENT']);
        $data[$database->sufix('agent')] = $ua['platform'].' / '.$ua['browser'].' / '.$ua['version'];
        $data[$database->sufix('time')] = date('Y-m-d H:i:s');
        $data[$database->sufix('user')] = 1;
        $data[$database->sufix('status')] = 'pendent';

        return $database->dataSave($data, 'insert', false, false);
    }

    public function loadDataPost($params)
    {
        $controller = $this->controller();
        $database = $this->database();

        $data = null;

        foreach ($params as $key => $value) {
            $data[$database->sufix($key)] = Request::post($database->sufix($key), $value['format']);
        }

        if ($data) {
            return $data;
        }
    }

    public function setEmailBody($data, $params)
    {
        $controller = $this->controller();
        $database = $this->database();

        $body = null;

        if ($params && $data) {
            foreach ($params as $key => $value) {
                if ($key == 'date') {
                    $body .= '<p><b>'.$value['label'].':</b> '.Treatment::date($data[$database->sufix($key)], 'brazil').'</p>';
                }
                else {
                    $body .= '<p><b>'.$value['label'].':</b> '.$data[$database->sufix($key)].'</p>';
                }
            }
        }

        if ($body) {
            return $body;
        }
    }

    public function generateCodeProtocol()
    {
        $newId = $this->database()->generatorOrder();

        $newCode = 'PRT-'.date('Ym').'-'.$newId.'-'.rand(1000, 9999);

        if ($this->database()->dataDuplicated(['protocol'], [$newCode])) {
            return $this->generateCodeProtocol();
        }

        return $newCode;
    }

    public function templateEmailClient($data)
    {
        $controller = $this->controller();
        $database = $this->database();

        $body = '
            <p>Recebemos seu protocolo em '.Treatment::date($data[$database->sufix('time')], 'timestamp_brazil').'.</p>
            <hr>
            <p><b>Protocolo nº:</b> '.$data[$database->sufix('protocol')].'</p>
            <p><b>Data da ocorrência:</b> '.Treatment::date($data[$database->sufix('date')], 'brazil').'</p>
            <hr>
            <p><b>Nome:</b> '.$data[$database->sufix('name')].'</p>
            <p><b>Endereço:</b> '.$data[$database->sufix('address')].'</p>
            <p><b>Telefone:</b> '.$data[$database->sufix('phone')].'</p>
            <p><b>E-mail:</b> '.$data[$database->sufix('email')].'</p>
            <p><b>Observações:</b> '.$data[$database->sufix('notification')].'</p>
            <p><b>IP:</b> '.$data[$database->sufix('ip')].'</p>
            <hr>
            <small>E-mail automático, favor não responder essa mensagem.</small>';

        return $body;
    }

    public function templateEmailServer($data)
    {
        $controller = $this->controller();
        $database = $this->database();

        $body = '
            <p><b>Protocolo nº:</b> '.$data[$database->sufix('protocol')].'</p>
            <p><b>Data da ocorrência:</b> '.Treatment::date($data[$database->sufix('date')], 'brazil').'</p>
            <hr>
            <p><b>Nome:</b> '.$data[$database->sufix('name')].'</p>
            <p><b>Endereço:</b> '.$data[$database->sufix('address')].'</p>
            <p><b>Telefone:</b> '.$data[$database->sufix('phone')].'</p>
            <p><b>E-mail:</b> '.$data[$database->sufix('email')].'</p>
            <p><b>Observações:</b> '.$data[$database->sufix('notification')].'</p>
            <p><b>IP:</b> '.$data[$database->sufix('ip')].'</p>
            <hr>
            <p><b>Registrado em:</b> '.Treatment::date($data[$database->sufix('time')], 'timestamp_brazil').'</p>
            <hr>
            <small>E-mail automático, favor não responder essa mensagem.</small>';

        return $body;
    }

    public function getStatus($status)
    {
        if ($status == 'active') {
            return '<span class="badge badge-success">atendido</span></td>';
        }
        else if ($status == 'pendent') {
            return '<span class="badge badge-info">análise pendente</span></td>';
        }
        else if ($status == 'disabled') {
            return '<span class="badge badge-danger">indeferido</span>';
        }
    }
}
