<?php

class Pages extends ModulesInstanceSite
{
    public $key = 'page';
    public $type = 'page';

    public function __construct($controller)
    {
        parent::__construct($controller);
    }

    public function instanceModules($view)
    {
        $module = clone parent::modules();

        $module->init($this->key, $view, $this->type);

        $module->extra['imagedefault'] = false;

        return $module;
    }

    public function init($view = null)
    {
        if (!$view) {
            $view = parent::seo(2);
        }

        $module = $this->instanceModules($view);

        $dataReturn['module'] = $module->start();

        unset($module);

        $this->render()->setTemplate('modules/pages/page');

        return $dataReturn;
    }

    public function call($view, $notOg = false, $template = null)
    {
        $dataReturn = null;

        $this->type = 'page-call';

        $module = $this->instanceModules($view);

        $module->notOg = $notOg;

        $dataReturn = $module->start();

        if ($template) {
            $this->render()->setTemplate($template);
        }

        if (isset($dataReturn['data']['slug'])) {
            $dataReturn['page']['header']['key'] = $dataReturn['data']['slug'];
        }

        unset($module);

        return $dataReturn;
    }

    public function group($key = 'page', $view = null, $type = 'group', $group = null)
    {
        $module = clone $this->modules();

        $module->init($key, $view, $type);

        $groupsAll = $module->start();

        $dataReturn['actions']['group']['info'] = [
            'type' => 'list',
            'title' => $group['title'],
            'label' => $group['title'],
            'url' => null,
            'internal' => null,
            'notitle' => false
        ];

        foreach ($groupsAll as $key => $value) {
            $dataReturn['actions']['group']['list'] = $groupsAll['data'];
        }

        $keyPage = $this->seo(2);

        if (is_null($keyPage)) {
            $pagesGroup = $this->manipuleMenu($group['id']);
            $firstKey = array_key_first($pagesGroup);

            if (isset($pagesGroup[$firstKey]['key'])) {
                $keyPage = $pagesGroup[$firstKey]['key'];
            }
        }

        $page = $this->call($keyPage, true, null, $group['id']);

        $dataReturn['active'] = $group;

        $info = [
            'title' => $page['data']['title'].' / '.$group['title'],
            'key' => $page['page']['header']['key'],
            'url' => $this->permalink($group['slug'].'/'.$page['data']['slug'])
        ];

        $page['data']['url'] = $info['url'];

        $dataReturn['data'] = $page['data'];
        $dataReturn = $this->generatePageStatic($info, $dataReturn);

        $this->render()->setTemplate('modules/pages/group');

        $dataReturn['module'] = $this->alterBreadcrumb($dataReturn);

        return $dataReturn;
    }

    public function monitorPages($monitor)
    {
        $query = "SELECT `slug_page` as slug FROM `mod_page` WHERE `status_page` = 'active'";

        if ($result = $this->database()->dbFetchAll($query)) {
            foreach ($result as $key => $value) {
                if ($value['slug'] == $monitor) {
                    return $this->init($value['slug']);
                }
            }
        }

        return $this->monitorPagesGroup();
    }

    public function monitorPagesGroup()
    {
        $query = "SELECT `id_page-type` as id, `title_page-type` as title, `slug_page-type` as slug FROM `mod_page-type` WHERE `status_page-type` = 'active'";

        if ($result = $this->database()->dbFetchAll($query)) {
            foreach ($result as $key => $value) {
                if ($value['slug'] == $this->seo(1)) {
                    return $this->group('page', $value['slug'], 'group', $value);
                }
            }
        }
    }

    public function alterBreadcrumb($data)
    {
        unset($data['page']['breadcrumb'][1]);

        $data['page']['breadcrumb'][6]['key'] = $data['active']['slug'];
        $data['page']['breadcrumb'][6]['title'] = $data['active']['title'];
        $data['page']['breadcrumb'][6]['url'] = null;

        $data['page']['breadcrumb'][7]['key'] = $data['data']['slug'];
        $data['page']['breadcrumb'][7]['title'] = $data['data']['title'];
        $data['page']['breadcrumb'][7]['url'] = $data['data']['url'];

        $data['page']['header']['title'] = $data['data']['title'];

        ksort($data['page']['breadcrumb']);

        return $data;
    }

    public function manipuleMenu($type = 2)
    {
        $query = "SELECT `id_page` as id,
                         `title_page` as title,
                         `slug_page` as slug,
                         `order_page` as orderin,
                         `title_page-type` as title_type,
                         `slug_page-type` as slug_type
                  FROM `mod_page`
                  INNER JOIN `mod_page-type` ON (`id_page-type` = `type_page`)
                  WHERE `status_page` = 'active' AND `type_page` = '".intval($type)."'
                  GROUP BY `id_page`
                  ORDER BY `order_page`
                  LIMIT 200";

        $result = $this->database()->dbFetchAll($query);

        if ($result) {
            foreach ($result as $key => $value) {
                $menuReturn[$value['id']]['key'] = $value['slug'];
                $menuReturn[$value['id']]['title'] = Treatment::string($value['title']);
                $menuReturn[$value['id']]['url'] = \Request::injectVars($value['slug_type'].'/'.$value['slug']);
                $menuReturn[$value['id']]['target'] = '_parent';
                $menuReturn[$value['id']]['image'] = null;
                $menuReturn[$value['id']]['order'] = intval($value['orderin']);
                $menuReturn[$value['id']]['active'] = null;
            }

            return $menuReturn;
        }
    }
}
