<?php

class Newsletter extends ModulesInstanceSite
{
    public $key = 'newsletter';
    public $callback = 'index';

    public $config = null;

    public $template = [
        'module' => 'modules/forms/newsletter'
    ];

    public function __construct($controller, $config = null)
    {
        parent::__construct($controller);

        $this->setConfig($config);

        $this->setMessagesCallback();

        $this->monitorPost();

        unset($controler, $config);
    }

    public function setConfig($config)
    {
        if (is_null($config)) {
            $config = $this->getExtra($this->key);
        }

        $this->config = $config;
    }

    public function route()
    {
        return $this->init();
    }

    public function monitorPost()
    {
        if (Request::post('submit_'.$this->key) == 'submit_'.$this->key) {
            $this->insertNewsletter();
        }

        if (Request::post('submit_newsletterRemove') == 'submit_newsletterRemove') {
            $this->deleteNewsletter();
        }
    }

    public function init()
    {
        $info = [
            'title' => $this->config['scope']['title'],
            'text' => $this->config['scope']['text'],
            'key' => $this->config['scope']['key']
        ];

        $dataReturn['module'] = parent::generatePageStatic($info);

        parent::render()->setTemplate($this->template['module']);

        return $dataReturn;

        return false;
    }

    public function setMessagesCallback()
    {
        if (array_key_exists('callback', $this->config)) {
            $controller = parent::controller();

            $controller->callback()->injectMessages($this->config['callback']);
        }
    }

    public function insertNewsletter()
    {
        $this->callback = $this->key;

        $data = ['name_newsletter' => Request::post('name_newsletter'),
                 'email_newsletter' => Request::post('email_newsletter')];

        $data['phone_newsletter'] = null;

        if (Request::post('phone_newsletter')) {
            $data['phone_newsletter'] = Request::post('phone_newsletter');
        }

        $data['checked_newsletter'] = 1;

        if ($data['name_newsletter'] && $data['email_newsletter']) {
            if ($this->storeNewsletter($data)) {
                parent::controller()->callback()->set($this->config['callback']['insertKey'], parent::permalink($this->callback));
            }
            else {
                parent::controller()->callback()->set($this->config['callback']['existsKey'], parent::permalink($this->callback));
            }
        }
    }

    public function storeNewsletter($data)
    {
        $database = parent::database();

        $database->setTable('ex_newsletter');
        $database->setSufix('newsletter');

        $queryPhone = null;

        if (array_key_exists($database->sufix('phone'), $data)) {
            $queryPhone = " OR `".$database->sufix('phone')."` = '".$data[$database->sufix('phone')]."')";
        }

        if (array_key_exists($database->sufix('email'), $data) && $data[$database->sufix('email')]) {
            $query = "SELECT `".$database->sufix('id')."` FROM `".$database->getTable()."`
                      WHERE (`".$database->sufix('email')."` = '".$data[$database->sufix('email')]."'".$queryPhone." AND
                             `".$database->sufix('status')."` = 'active' AND
                             `".$database->sufix('checked')."` = '1'";

            if ($database->dbNumRows($query) == 0) {
                $database->dataSave($data, 'insert');

                return true;
            }
            else {
                return false;
            }
        }
    }

    public function deleteNewsletter()
    {
        $this->callback = $this->key;

        $data = ['email' => Request::post('email_newsletterRemove')];

        if ($data['email']) {
            if ($this->destroyNewsletter($data['email'])) {
                parent::controller()->callback()->set($this->config['callback']['removeKey'], parent::permalink($this->callback));
            }
            else {
                parent::controller()->callback()->set($this->config['callback']['noexistsKey'], parent::permalink($this->callback));
            }
        }
        else {
            parent::controller()->callback()->set($this->config['callback']['noexistsKey'], parent::permalink($this->callback));
        }
    }

    public function destroyNewsletter($email)
    {
        $query = "SELECT `id_newsletter` FROM `ex_newsletter` WHERE `email_newsletter` = '".$email."' AND `status_newsletter` = 'active'";

        if (parent::database()->dbNumRows($query) == 1) {
            parent::database()->dbQuery("UPDATE `ex_newsletter` SET `checked_newsletter` = '0' WHERE `email_newsletter` = '".$email."'");

            return true;
        }
        else {
            return false;
        }
    }
}
