<?php

class News extends ModulesInstanceSite
{
    public $key = 'news';

    public $keyLang = [
        'archive' => null,
        'view' => null
    ];

    public function __construct($controller)
    {
        parent::__construct($controller);

        $instanceModule = $this->getInfoAllModule($this->key);

        if (isset($instanceModule['scope'])) {
            $this->keyLang = [
                'archive' => $instanceModule['scope']['key'],
                'view' => $instanceModule['scope']['key_view']
            ];
        }
    }

    public function archive()
    {
        $dataReturn = null;

        $this->type = 'archive';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('archive'));

        $searchAction = false;

        if ($querySearch = $this->search()) {
            if (is_array($querySearch)) {
                $dataReturn = $querySearch;

                $searchAction = true;
            }
            else if ($querySearch == 'execute-search') {
                $searchAction = true;
            }
        }

        if (!$searchAction) {
            $dataReturn = $this->loadData("AND `date_news` <= CURDATE()", "`date_news` DESC, `time_news` DESC", 10);
        }

        $dataReturn['page'] = $module->manipulePage();
        $dataReturn['actions'] = $this->generateActions();

        if (Request::get('periodo') && isset($_SESSION['period'])) {
            $dataReturn['page']['breadcrumb'][] = $_SESSION['period'];
        }

        if (Request::get('categoria') && isset($_SESSION['category'])) {
            $dataReturn['page']['breadcrumb'][] = $_SESSION['category'];

            $dataReturn['page']['header']['title'] = $dataReturn['page']['header']['title']. ' / '.$_SESSION['category']['title'];
        }

        $module->setOpenGraph($dataReturn);

        if (!$searchAction) {
            $dataReturn['actions']['search']['placeholder'] = 'Pesquise em notícias...';
        }
        else {
            $dataReturn['actions']['search']['placeholder'] = 'Sua pesquisa: '.$_SESSION['string_search'];
        }

        $dataReturn['actions']['search']['active'] = $searchAction;
        $dataReturn['actions']['search']['title'] = 'Clique para pesquisar em notícias';
        $dataReturn['actions']['search']['action'] = Request::injectVars($this->locale['key'], [['pesquisa' => 'sim']], ['periodo']);

        unset($module);

        return $dataReturn;
    }

    public function view()
    {
        $dataReturn = null;

        $this->type = 'view';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $this->render()->setTemplate($this->getTemplate('view'));

        $dataReturn = $this->loadData("AND `date_news` <= CURDATE() AND `slug_news` = '".Request::seo(2)."'", "`date_news` DESC, `time_news` DESC", 1, ['view', 'view'], $module);

        $dataReturn['page'] = $module->manipulePage();

        $module->setOpenGraph($dataReturn);

        $dataReturn['og'] = $module->og;

        $core = $this->controller()->render()->getVars('core');

        $dataReturn['othersData'] = $this->last($dataReturn['data']['id']);

        unset($module);

        return $dataReturn;
    }

    public function index()
    {
        $dataReturn = null;

        $this->type = 'index';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $dataReturn = $this->loadData(null, "`date_news` DESC, `time_news` DESC", 8, [60, 40]);

        unset($dataReturn['pagination']);

        $dataReturn['page'] = $module->manipulePage();

        unset($module);

        return $dataReturn;
    }

    public function last($idNot)
    {
        $dataReturn = null;

        $this->type = 'last';

        $module = clone $this->modules();

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'], 'title' => $this->locale['title'], 'url' => Request::permalink($module->key)];

        $dataReturn = $this->loadData("AND `date_news` <= CURDATE() AND `id_news` <> '".$idNot."'", "`date_news` DESC, `time_news` DESC", 10);
        $dataReturn['page'] = $module->manipulePage();

        unset($dataReturn['page']['breadcrumb']);
        unset($dataReturn['pagination']);

        unset($module);

        $dataReturn['page']['header']['title'] = 'Últimas Notícias';

        return $dataReturn;
    }

    public function loadData($where, $orderby, $limit = 13, $qtndChars = [60, 160], $module = null)
    {
        $controller = $this->controller();
        $database = $this->database();

        $database->setTable('mod_news');
        $database->setSufix('news');

        $whereCategory = $wherePeriod = null;

        if (Request::get('categoria')) {
            $whereCategory = " AND `slug_news-category` = '".Request::get('categoria')."'";
        }

        if (Request::get('periodo')) {
            $month = substr(Request::get('periodo'), 0, 2);
            $year = intval(substr(Request::get('periodo'), 3, 4));

            $wherePeriod = " AND YEAR(`date_news`) = '".$year."' AND MONTH(`date_news`) = '".$month."'";
        }

        $query = "SELECT `id_news` as id,
                         `title_news` as title,
                         `slug_news` as slug,
                         `date_news` as date,
                         `subtitle_news` as subtitle,
                         `text_news` as text,
                         `covertype_news` as covertype,
                         `cover_news` as cover,
                         `legend_news` as legend,
                         `user_news` as user,
                         `name_administrator` as user_name,
                         `signature_administrator` as user_signature,
                         `title_news-category` as category_title,
                         `slug_news-category` as category_slug
                  FROM `mod_news`
                  INNER JOIN `mod_news-category` ON (`id_news-category` = `category_news`".$whereCategory.")
                  LEFT JOIN `mod_administrator` ON (`id_administrator` = `user_news`)
                  WHERE `status_news` = 'active' ".$where.$wherePeriod."
                  ORDER BY ".$orderby;

        $pagination = new CoreSlim\PaginationGet([
            'locale' => $controller->locale['pagination'],
            'item' => $limit,
            'query' => $query
        ]);

        $result = $database->dbFetchAll($pagination->execute());

        if ($result) {
            foreach ($result as $key => $value) {
                if ($qtndChars[0] == 'view' && $module) {
                  foreach($module->features as $keyFeatures => $params) {
                        if ($module->features[$keyFeatures]['active'] && array_key_exists('id', $value)) {
                            $box = $module->extraBox($module->features[$keyFeatures]['key'], $value['id'], $params);

                            if ($box) {
                                $dataReturn['data'][$key][$keyFeatures] = $box;
                            }
                        }
                    }
                }

                $dataReturn['data'][$key]['id'] = intval($value['id']);

                if ($value['user'] && $value['user_name']) {
                    $dataReturn['data'][$key]['user'] = intval($value['user']);

                    $name = Treatment::string($value['user_name']);

                    if ($value['user_signature']) {
                        $name = Treatment::string($value['user_signature']);
                    }

                    $dataReturn['data'][$key]['user_signature'] = $name;
                }

                $dataReturn['data'][$key]['title'] = Treatment::string($value['title']);
                $dataReturn['data'][$key]['label'] = Treatment::string($value['title']);

                $dataReturn['data'][$key]['subtitle'] = Treatment::string($value['subtitle']);

                $dataReturn['data'][$key]['legend'] = Treatment::string($value['legend']);

                $dataReturn['data'][$key]['text'] = Treatment::string($value['text'], 'text');

                $dataReturn['data'][$key]['date'] = Treatment::date($value['date'], 'brazil');
                $dataReturn['data'][$key]['dateextensive'] = Treatment::date($value['date'], 'extensive_weekday');

                $dataReturn['data'][$key]['url'] = Request::permalink($this->keyLang['view'].'/'.$value['slug']);

                if ($value['covertype'] == 2) {
                    $dataReturn['data'][$key]['thumb'] = Assets::loadThumb($value['cover'], 'news', 'thumb');
                    $dataReturn['data'][$key]['original'] = Assets::loadThumb($value['cover'], 'news', 'default');
                }
                elseif ($value['covertype'] == 3) {
                    $dataReturn['data'][$key]['video'] = Request::getVideo($value['cover']);
                    $dataReturn['data'][$key]['video']['thumb'] = Request::getVideoThumbnail($value['cover'])['url'];
                }

                $dataReturn['data'][$key]['category']['title'] = Treatment::string($value['category_title']);
                $dataReturn['data'][$key]['category']['url'] = Request::injectVars($this->keyLang['archive'], [['categoria' => $value['category_slug']]]);
            }

            $dataReturn['pagination'] = $pagination->navigation($this->keyLang['archive'], ['periodo']);

            if ($qtndChars[0] == 'view' && $qtndChars[1] == 'view') {
                $dataReturn['data'] = $dataReturn['data'][0];

                unset($dataReturn['pagination']);

                $this->modules()->setStats('news', $dataReturn['data']['id'], 'mod_news');
            }

            return $dataReturn;
        }
    }

    public function generateActions()
    {
        $controller = $this->controller();
        $database = $this->database();

        $actions['category']['info'] = [
            'type' => 'list',
            'title' => 'Categoria',
            'label' => 'Selecione uma categoria...',
            'url' => Request::injectVars($this->keyLang['archive'], [['categoria' => 'empty']]),
            'internal' => 'Categoria',
            'notitle' => false,
            'cols' => 'col-sm-4 col-md-4'
        ];

        if (Request::get('categoria')) {
            $actions['options']['open'] = true;

            $actions['category']['info']['label'] = 'Resetar filtro de categorias...';
        }

        $query = "SELECT `id_news-category` as id,
                         `title_news-category` as title,
                         `slug_news-category` as slug
                  FROM `mod_news-category`
                  INNER JOIN `mod_news` ON (`category_news` = `id_news-category` AND `status_news` = 'active')
                  WHERE `status_news-category` = 'active'
                  GROUP BY `id_news-category`
                  ORDER BY `title_news-category`
                  LIMIT 200";

        $result = $database->dbFetchAll($query);

        if ($result) {
            foreach ($result as $key => $value) {
                $active = false;

                if ($value['slug'] == Request::get('categoria')) {
                    $active = true;
                }

                $actions['category']['list'][$key]['id'] = intval($value['id']);
                $actions['category']['list'][$key]['title'] = Treatment::string($value['title']);
                $actions['category']['list'][$key]['url'] = Request::injectVars($this->keyLang['archive'], [['categoria' => $value['slug']]]);
                $actions['category']['list'][$key]['active'] = $active;

                if (Request::get('categoria') && $active) {
                    $_SESSION['category'] = $actions['category']['list'][$key];
                }
            }
        }

        $actions['period']['info'] = [
            'type' => 'select',
            'title' => 'Período',
            'label' => 'Selecione um período...',
            'url' => Request::injectVars($this->keyLang['archive'], [['periodo' => 'empty']]),
            'internal' => 'Período',
            'notitle' => false,
            'cols' => 'col-sm-4 col-md-4'
        ];

        if (Request::get('periodo')) {
            $actions['options']['open'] = true;

            $actions['period']['info']['label'] = 'Resetar filtro de período...';
        }

        $query = "SELECT `date_news` as date, COUNT(`id_news`) as total
                  FROM `mod_news`
                  WHERE `status_news` = 'active' AND `date_news` <= CURDATE()
                  GROUP BY YEAR(`date_news`), MONTH(`date_news`)
                  ORDER BY `date_news` DESC";

        $result = $database->dbFetchAll($query);

        if ($result) {
            foreach ($result as $key => $value) {
                if ($value['date'] != '0000-00-00') {
                    $active = false;

                    $filter = substr($value['date'], 5, 2).'-'.substr($value['date'], 0, 4);

                    if ($filter == Request::get('periodo')) {
                        $active = true;
                    }

                    $month = Treatment::date(Treatment::date($value['date'], 'month'), 'month_name').'/';

                    $actions['period']['list'][$key]['url'] = Request::injectVars($this->keyLang['archive'], [['periodo' => $filter]]);
                    $actions['period']['list'][$key]['title'] = $month.Treatment::date($value['date'], 'year');
                    $actions['period']['list'][$key]['active'] = $active;

                    if (Request::get('periodo') && $active) {
                        $_SESSION['period'] = $actions['period']['list'][$key];
                    }
                }
            }
        }

        return $actions;
    }

    public function search($action = 'submitSearch_internal', $string = 'stringSearch_internal', $limit = 13)
    {
        $controller = $this->controller();

        if (Request::post($action) == $action) {
            $_SESSION['string_search'] = Request::post($string);

            $searchTables = ['mod_news', 'mod_news-category'];

            $where = null;

            foreach ($searchTables as $table) {
                $queryRelative = "SELECT * FROM `".$table."`";

                if ($relative = $controller->database()->dbFieldsSearch($queryRelative, $table)) {
                    foreach ($relative as $key => $fieldRelative) {
                        if (isset($fieldRelative['native_type']) && ($fieldRelative['native_type'] == 'DATE' || $fieldRelative['native_type'] == 'DATETIME') && \DateTime::createFromFormat('Y-m-d H:i:s', Treatment::date($_SESSION['string_search'], 'mysql').' 00:00:00') !== false) {
                            $where[] = "(`".$fieldRelative['name']."` = '".Treatment::date($_SESSION['string_search'], 'mysql')."')";
                        }
                        else if (isset($fieldRelative['native_type']) && $fieldRelative['native_type'] == 'VAR_STRING') {
                            $where[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'])."%')";
                        }
                        else {
                            $where[] = "(`".$fieldRelative['name']."` LIKE '%".Treatment::string($_SESSION['string_search'], 'text')."%')";
                        }
                    }
                }
            }

            $_SESSION['string_query'] = "AND (".implode(' OR ', $where).") AND `date_news` <= CURDATE()";

            $module = $this->loadData($_SESSION['string_query'], "`date_news` DESC, `time_news` DESC", $limit, [300, 300]);

            if ($module) {
                return $module;
            }
            else {
                return 'execute-search';
            }
        }
        else if (Request::get('pesquisa') == 'sim') {
            $module = $this->loadData($_SESSION['string_query'], "`date_news` DESC, `time_news` DESC", $limit, [300, 300]);

            if ($module) {
                return $module;
            }
        }
        else if (Request::get('pesquisa') != 'sim') {
            $_SESSION['string_search'] = null;
            $_SESSION['string_query'] = null;
        }
    }
}
