<?php

class LGPD extends ModulesInstanceSite
{
    public $key = 'lgpd';
    public $config = null;

    public $template = [
        'module' => 'modules/pages/page'
    ];

    public function __construct($controller, $config = null)
    {
        parent::__construct($controller);

        $this->monitorActions();

        $this->setConfig($config);

        if (!isset($_SESSION['CookieLGPDAccept'])) {
            $_SESSION['CookieLGPDAccept'] = 2;
        }

        unset($controler, $config);
    }

    public function setConfig($config)
    {
        if (is_null($config)) {
            $config = $this->getExtra($this->key);
        }

        $this->config = $config;
    }

    public function route()
    {
        if ($this->config['scope']['key'] == Request::seo(1)) {
            return $this->view(true);
        }
    }

    public function view()
    {
        $controller = parent::controller();

        $info = [
            'title' => $this->config['scope']['title'],
            'text' => null,
            'key' => $this->config['scope']['key']
        ];

        $dataReturn['module'] = parent::generatePageStatic($info);

        $dataReturn['module']['data']['title'] = $this->config['scope']['title'];
        $dataReturn['module']['data']['text'] = $this->config['scope']['text'];

        $controller->render()->setTemplate(parent::getTemplate('module'));

        return $dataReturn;
    }

    public function monitorActions()
    {
        $lgpdData = $this->getLinkPage();

        if (isset($_SESSION['CookieLGPDAccept']) && $_SESSION['CookieLGPDAccept'] == 1) {
            $lgpdData['acceptLGPD'] = 1;
        }
        else if (isset($_SESSION['CookieLGPDAccept']) && $_SESSION['CookieLGPDAccept'] == 2) {
            $lgpdData['acceptLGPD'] = 2;
        }

        $this->render()->setVars('lgpdData', $lgpdData);
    }

    public function setOk()
    {
        $_SESSION['CookieLGPDAccept'] = 1;
    }

    public function getLinkPage()
    {
        if (isset($this->render()->getVars('extra')['static']['lgpd'])) {
            $extra = $this->render()->getVars('extra')['static']['lgpd'];

            $lgpdData['status'] = intval($extra['scope']['status']);

            $lgpdData['popup']['text'] = $extra['info']['lgpd'];
            $lgpdData['popup']['buttonPage']['title'] = $extra['scope']['title'];
            $lgpdData['popup']['buttonPage']['label'] = $extra['info']['buttonPage'];
            $lgpdData['popup']['buttonAccept']['label'] = $extra['info']['buttonAccept'];

            if ($extra['scope']['status'] == 1) {
                $lgpdData['linkPage'] = Request::permalink($extra['scope']['key']);
            }

            return $lgpdData;
        }
    }
}
