<?php

class Index extends ModulesInstanceSite
{
    public function __construct($controller)
    {
        parent::__construct($controller);
    }

    public function init()
    {
        include(config('app.ROOT_MODULES').'/slideshow.php');
        include(config('app.ROOT_MODULES').'/products.php');
        include(config('app.ROOT_MODULES').'/services.php');
        include(config('app.ROOT_MODULES').'/news.php');
        include(config('app.ROOT_MODULES').'/clients.php');

        $slideshow = new Slideshow($this);
        $products = new Products($this);
        $services = new Services($this);
        $news = new News($this);
        $clients = new Clients($this);

        parent::render()->setTemplate('modules/index/master');

        $index['slideshow'] = $slideshow->index();
        $index['products'] = $products->index();
        $index['services'] = $services->index();
        $index['news'] = $news->index();
        $index['clients'] = $clients->index();

        return $index;
    }
}
