<?php

class Events extends ModulesInstanceSite
{
	public $key = 'events';

    public $template = [
        'archive' => 'archives/list',
        'view' => 'views/default'
    ];

    public $helpers = [];

	public function __construct($controller)
	{
		parent::__construct($controller);

        $keyUrl = $controller->getInfoModule('key', 'events');

        $this->helpers['next']['key'] = $controller->getInfoModule('key', 'events', 'next');
        $this->helpers['next']['title'] = $controller->getInfoModule('title', 'events', 'next');
        $this->helpers['next']['url'] = parent::permalink($keyUrl.'/'.$this->helpers['next']['key']);

        $this->helpers['previous']['key'] = $controller->getInfoModule('key', 'events', 'previous');
        $this->helpers['previous']['title'] = $controller->getInfoModule('title', 'events', 'previous');
        $this->helpers['previous']['url'] = parent::permalink($keyUrl.'/'.$this->helpers['previous']['key']);
	}

    public function instanceModules()
    {
        $module = parent::instanceCore();

        $module->selectView['hour'] = [
            'tuple' => 'hour',
            'format' => 'hour2digits'
        ];

        $module->resources['period']['type'] = 'select';

        return $module;
    }

	public function archive()
	{
		$dataReturn = null;

        $this->type = 'archive';

		$module = $this->instanceModules();

        if (parent::seo(2) == $this->helpers['next']['key']) {
            $module->query['where'][] = "AND `date_".$module->sufix."` >= CURDATE()";
        }
        else if (parent::seo(2) == $this->helpers['previous']['key']) {
            $module->query['where'][] = "AND `date_".$module->sufix."` < CURDATE()";
        }

        $module->query['orderby'] = "`date_".$module->sufix."` DESC, `hour_".$module->sufix."` DESC";
        $module->query['limit'] = 5;

        $module->extra['charText'] = 450;

		$dataReturn = parent::instanceStart($module);

        if (parent::seo(2) == $this->helpers['next']['key']) {
            $dataReturn['page']['header']['title'] = $dataReturn['page']['breadcrumb'][2]['title'] = $this->helpers['next']['title'];
            $dataReturn['page']['header']['url'] = $dataReturn['page']['breadcrumb'][2]['url'] = $this->helpers['next']['url'];
        }
        else if (parent::seo(2) == $this->helpers['previous']['key']) {
            $dataReturn['page']['header']['title'] = $dataReturn['page']['breadcrumb'][2]['title'] = $this->helpers['previous']['title'];
            $dataReturn['page']['header']['url'] = $dataReturn['page']['breadcrumb'][2]['url'] = $this->helpers['previous']['url'];
        }

        $dataReturn['actions'] = $this->addFilterList($dataReturn['actions']);

		unset($module);

		return $dataReturn;
	}

    public function view()
    {
        $dataReturn = null;

        $this->type = 'view';

        $module = $this->instanceModules();

        $dataReturn = parent::instanceStart($module);

        if (parent::seo(2) == $this->helpers['next']['key']) {
            $dataReturn['page']['header']['title'] = $dataReturn['page']['breadcrumb'][1]['title'] = $this->helpers['next']['title'];
            $dataReturn['page']['header']['url'] = $dataReturn['page']['breadcrumb'][1]['url'] = $this->helpers['next']['url'];
        }
        else if (parent::seo(2) == $this->helpers['previous']['key']) {
            $dataReturn['page']['header']['title'] = $dataReturn['page']['breadcrumb'][1]['title'] = $this->helpers['previous']['title'];
            $dataReturn['page']['header']['url'] = $dataReturn['page']['breadcrumb'][1]['url'] = $this->helpers['previous']['url'];
        }

        $dataReturn['actions'] = $this->addFilterList($dataReturn['actions']);

        unset($module);

        return $dataReturn;
    }

	public function index($type)
	{
		$dataReturn = null;

		$this->type = 'index';

		$module = $this->instanceModules();

		$module->query['limit'] = 10;

        if ($type == 'next') {
            $module->query['where'][] = "AND `date_".$module->sufix."` >= CURDATE()";
        }
        else if ($type == 'previous') {
            $module->query['where'][] = "AND `date_".$module->sufix."` < CURDATE()";
        }

        $module->query['orderby'] = "`date_".$module->sufix."` DESC, `hour_".$module->sufix."` DESC";

		$dataReturn = $module->start();

        if ($type == 'next') {
            $dataReturn['page']['header']['title'] = $this->helpers['next']['title'];
            $dataReturn['page']['header']['url'] = $this->helpers['next']['url'];
            $dataReturn['page']['readmore'] = $controller->getInfoModule('button', 'events', 'next');
        }
        else if ($type == 'previous') {
            $dataReturn['page']['header']['title'] = $this->helpers['previous']['title'];
            $dataReturn['page']['header']['url'] = $this->helpers['previous']['url'];
            $dataReturn['page']['readmore'] = $controller->getInfoModule('button', 'events', 'previous');
        }

		unset($module);

		return $dataReturn;
	}

    public function addFilterList($actions)
    {
        $info = [
            'type' => 'list',
            'title' => 'Filtros',
            'url' => 'todos',
            'internal' => null,
            'notitle' => false
        ];

        $active = false;

        if (parent::seo(2) == $this->helpers['next']['key']) {
            $active = true;
        }

        $list[] = [
            'url' => $this->helpers['next']['url'],
            'title' => $this->helpers['next']['title'],
            'active' => $active
        ];

        $active = false;

        if (parent::seo(2) == $this->helpers['previous']['key']) {
            $active = true;
        }

        $list[] = [
            'url' => $this->helpers['previous']['url'],
            'title' => $this->helpers['previous']['title'],
            'active' => $active
        ];

        $actions['filter'] = ['info' => $info, 'list' => $list];

        return $actions;
    }
}
