<?php

// doopSites v1.9.7 - Última atualização 23/05/2023 12:20

class ModulesInstanceSite
{
    private $controller = null;

    public $key = null;

    public $keyLang = null;

    public $type = null;

    public $locale = [
        'key' => null,
        'title' => null
    ];

    public $notViewArchive = null;
    public $notViewIndex = null;
    public $notViewView = null;

    public $forceView = true;

    public $manipule = [
        'order' => true
    ];

    public $template = [
        'archive' => null,
        'view' => null
    ];

    public function __construct($controller, $moduleAutomatic = true)
    {
        if (property_exists($controller, 'controller')) {
            $controller = $controller->controller;
        }

        $this->controller = $controller;

        if ($moduleAutomatic) {
            $this->template['archive'] = 'modules/'.$this->key.'/archive';
            $this->template['view'] = 'modules/'.$this->key.'/view';
        }

        $this->generateLocale();

        unset($controller);
    }

    public function route()
    {
        switch (Request::seo(1))
        {
            case $this->controller()->getInfoModule('key', $this->key):
                return $this->archive();
            break;

            case $this->controller()->getInfoModule('key_view', $this->key):
                return $this->view();
            break;
        }
    }

    public function instanceCore()
    {
        $module = clone $this->modules();

        $module->setForceView($this->forceView);

        $module->init($this->key, $this->locale['key'], $this->type);

        $module->page[] = ['key' => $this->locale['key'],
                           'title' => $this->locale['title'],
                           'url' => Request::permalink($module->key)];

        $module->extra['manipuleRouteLink'] = $this->controller()->getInfoModule('key_view', $this->key);

        if ($module->getBox() == 'archive' && is_array($this->notViewArchive)) {
            foreach ($this->notViewArchive as $notView) {
                $module->notView[$notView] = true;
            }
        }

        if ($module->getBox() == 'index' && is_array($this->notViewIndex)) {
            foreach ($this->notViewIndex as $notIndex) {
                $module->notView[$notIndex] = true;
            }
        }

        if ($module->getBox() == 'view' && is_array($this->notViewView)) {
            foreach ($this->notViewView as $notView) {
                $module->notView[$notView] = true;
            }
        }

        return $module;
    }

    public function instanceStart($module)
    {
        if ($module->getBox() == 'archive') {
            $this->render()->setTemplate($this->getTemplate('archive'));
        }
        else if ($module->getBox() == 'view') {
            $this->render()->setTemplate($this->getTemplate('view'));
        }

        $dataReturn = $module->start();

        unset($module);

        return $dataReturn;
    }

    public function controller()
    {
        return $this->controller;
    }

    public function modules()
    {
        return $this->controller()->modules();
    }

    public function database()
    {
        return $this->controller()->database();
    }

    public function render()
    {
        return $this->controller()->render();
    }

    public function callback()
    {
        return $this->controller()->callback();
    }

    public function getLocale($params1 = null, $params2 = null, $params3 = null)
    {
        return $this->controller()->getLocale($params1, $params2, $params3);
    }

    public function getExtra($type = null, $group = 'static')
    {
        return $this->controller()->getExtra($type, $group);
    }

    public function permalink($path = null, $primary = null)
    {
        return Request::permalink($path, $primary);
    }

    public function seo($position, $primary = true)
    {
        return Request::seo($position, $primary);
    }

    public function post($key, $type = 'string')
    {
        return Request::post($key, $type);
    }

    public function generatePageStatic($info, $dataReturn = null, $generateOg = true)
    {
        $dataReturn['page']['header']['key'] = $info['key'];

        if (array_key_exists('title', $info)) {
            $dataReturn['page']['header']['title'] = $info['title'];
        }

        if (array_key_exists('text', $info)) {
            $dataReturn['page']['header']['text'] = $info['text'];
        }

        $dataReturn['page']['header']['url'] = Request::permalink($info['key']);

        $dataReturn['page']['breadcrumb'][0] = [
            'title' => '<i class="fas fa-home" title="'.$this->getLocale('extra', 'start').'"></i>',
            'url' => Request::permalink()
        ];

        $dataReturn['page']['breadcrumb'][1]['key'] = $dataReturn['page']['header']['key'];

        if (array_key_exists('title', $info)) {
            $dataReturn['page']['breadcrumb'][1]['title'] = $dataReturn['page']['header']['title'];
        }

        $dataReturn['page']['breadcrumb'][1]['url'] = $dataReturn['page']['header']['url'];

        if ($generateOg) {
            $dataReturn['og'] = $this->generateOg($dataReturn['page']['header']);
        }

        return $dataReturn;
    }

    public function generateOg($dataPage)
    {
        $og = $this->controller()->modules()->openGraph();

        $og['site_name'] = $og['title'] = $dataPage['title'] . ' / ' . $og['site_name'];
        $og['url'] = $dataPage['url'];

        $core = $this->controller()->render()->getVars('core');

        $core['title'] = $core['metatitle'] = $og['site_name'];

        $this->controller()->render()->setVars('core', $core);

        return $og;
    }

    public function generateLocale()
    {
        $infoModules = $this->controller()->infoModules;

        if (is_array($infoModules) && property_exists($this, 'key')) {
            if (array_key_exists($this->key, $infoModules)) {
                $this->locale['key'] = $infoModules[$this->key]['scope']['key'];
                $this->locale['title'] = $infoModules[$this->key]['scope']['title'];
            }
        }
    }

    public function getKey()
    {
        return $this->key;
    }

    public function getLocaleKey()
    {
        return $this->locale['key'];
    }

    public function getLocaleType()
    {
        return $this->locale['type'];
    }

    public function getTemplate($type)
    {
        return $this->template[$type];
    }

    public function getPageCall($key = null, $notOg = false, $template = null)
    {
        if (is_null($key)) {
            $key = $this->getKey();
        }

        if (class_exists('Pages')) {
            $pages = new Pages($this->controller);

            $call = $pages->call($key, $notOg, $template);

            if ($call['page']) {
                return $call;
            }
        }
    }

    public function getInfoAllModule($module = null)
    {
        $infoModules = $this->controller()->infoModules;

        if (is_array($infoModules)) {
            if (is_null($module)) {
                $module = $this->getKey();
            }

            if (array_key_exists($module, $infoModules)) {
                return $infoModules[$module];
            }
        }
    }
}
