<?php

// doopSites v1.9.7 - Última atualização 05/12/2023 10:36

require_once(config('app.ROOT_CORE').'/class.model.php');
require_once(config('app.ROOT_CORE').'/class.callback.php');
require_once(config('app.ROOT_CORE').'/class.render.php');
require_once(config('app.ROOT_CORE').'/class.modulesinstance.php');
require_once(config('app.ROOT_CORE').'/class.modules.php');

require_once(config('app.ROOT_MODULES').'/menu.php');
require_once(config('app.ROOT_MODULES').'/lgpd.php');

class CoreSite
{
    public $assetsVersion = null;
    public $database = null;
    public $callback = null;
    public $render = null;
    public $modulesSystem = null;
    public $modules = null;
    public $webpConvertStatus = true;

    public $primary = [
        'id' => null,
        'title' => null,
        'key' => null
    ];

    public $langActive = false;
    public $lang = 'br';
    public $langIso = 'pt_BR';
    public $language = null;
    public $locale = null;

    public $pathsDirModules = ['modules'];

    public $infoModules = null;

    public function __construct($action = null)
    {
        Request::monitorFragmentSocial();

        $this->assetsVersion = config('app.VERSION_ASSETS');

        if ($action !== 'provider') {
            $this->defineModulesSystem();

            $this->database = new ModelSite();

            $this->setLang();

            $this->database()->setLangIso($this->getLangIso());

            Tools::setCsfrToken();

            $this->callback = new CallbackSite($this->getLocale(), $this);

            $this->render = new RenderSite();

            $this->render()->setVars('core', $this->core());

            $locale = $this->getLocale();

            $this->render()->setVars('locale', $locale);

            $extra = $this->loadExtra();

            $this->render()->setVars('extra', $extra);

            $this->prepareValidadeForms($extra, $locale);

            $header = $this->header();

            $this->render()->setVars('header', $header);

            $footer = $this->footer(false);

            $this->render()->setVars('footer', $footer);

            $this->infoModules = $this->loadModules();

            $this->modules = new ModulesSite($this);

            if ($action === 'site') {
                $this->init();
            }
        }
    }

    public function getInfoModule($view, $module, $first = 'scope')
    {
        if (is_array($this->infoModules)) {
            if (array_key_exists($module, $this->infoModules)) {
                if (array_key_exists($view, $this->infoModules[$module][$first])) {
                    return $this->infoModules[$module][$first][$view];
                }
            }
        }
    }

    public function getExtra($type = null, $group = 'static')
    {
        $extra = $this->render()->getVars('extra');

        if ($extra) {
            if (array_key_exists($group, $extra)) {
                if (array_key_exists($type, $extra[$group])) {
                    return $extra[$group][$type];
                }
                else {
                    return $extra[$group];
                }
            }
            else {
                return $extra;
            }
        }
    }

    public function routeDefault()
    {
        $maintenance = $this->database()->getBaseData('maintenance');

        if (isset($maintenance['status']) && $maintenance['status'] == 2) {
            $dataView['module']['message'] = Treatment::string($maintenance['message'], 'unserializestring');

            $this->render()->setTemplate('modules/pages/maintenance');

            $this->loadSite($dataView);
        }

        $dataView = $this->checkRoutesDoop();

        if (is_null($dataView)) {
            switch (Request::seo(1))
            {
                case '':
                case $this->getLocale('key', 'index'):
                case $this->getLocale('key', 'home'):
                    if (!class_exists('Index')) {
                        $indexFile = config('app.ROOT_MODULES').'/index.php';
                    }

                    if (file_exists($indexFile)) {
                        include(config('app.ROOT_MODULES').'/index.php');

                        $index = new Index($this);

                        $dataView['module'] = $index->init();
                    }
                break;

                case $this->getLocale('key', 'error404'):
                    if (!class_exists('Error404')) {
                        $error404File = config('app.ROOT_MODULES').'/error404.php';
                    }

                    if (file_exists($error404File)) {
                        include($error404File);

                        $error404 = new Error404($this);

                        $dataView = $error404->init();
                    }
                break;

                case $this->getLocale('key', 'search'):
                    if (!class_exists('Search')) {
                        $searchFile = config('app.ROOT_MODULES').'/search.php';
                    }

                    if (file_exists($searchFile)) {
                        include($searchFile);

                        $search = new Search($this);

                        $dataView = $search->init();
                    }
                break;

                case Request::seo(1):
                    if (!class_exists('Pages')) {
                        require_once(config('app.ROOT_MODULES').'/pages.php');
                    }

                    if (Request::seo(1) == $this->getLocale('key', 'page')) {
                        $dataView = $pages->init();
                    }
                    else {
                        $pages = new Pages($this);

                        if ($automaticPages = $pages->monitorPages(Request::seo(1))) {
                            $dataView = $automaticPages;
                        }
                    }
                break;
            }
        }

        if (!$dataView && array_key_exists('QUERY_STRING', $_SERVER)) {
            include(config('app.ROOT_MODULES').'/index.php');

            $index = new Index($this);

            $dataView['module'] = $index->init();
        }

        if ($dataView) {
            return $dataView;
        }
        else {
            $this->executerErrorUrl();
        }
    }

    public function checkRoutesDoop()
    {
        $dataView = null;

        $modules = $this->infoModules;

        $positionKeyPrimary = 1;

        if ($modules) {
            foreach ($modules as $key => $value) {
                if ($value['scope']['key'] == Request::seo($positionKeyPrimary) || $value['scope']['key_view'] == Request::seo($positionKeyPrimary)) {
                    if ($value['scope']['class'] && !class_exists($value['scope']['class'])) {
                        foreach ($this->pathsDirModules as $pathDir) {
                            $fileCheck = config('app.ROOT_SITE').'/'.$pathDir.'/'.$key .'.php';

                            if (file_exists($fileCheck)) {
                                include($fileCheck);
                            }
                        }
                    }

                    if ($value['scope']['class']) {
                        $module = new $value['scope']['class']($this);

                        $dataView['module'] = $module->route();
                    }
                }
            }
        }

        $extras = $this->getExtra();

        if ($extras && is_null($dataView)) {
            foreach ($extras as $keyCategory => $modules) {
                if (is_array($modules) && array_key_exists('scope', $modules) && array_key_exists('key', $modules['scope'])) {
                    if ($modules['scope']['key'] == Request::seo($positionKeyPrimary) && $modules['scope']['status'] == 1) {
                        if (!is_null($modules['scope']['class']) && !class_exists($modules['scope']['class'])) {
                            include(config('app.ROOT_MODULES').'/'.$keyCategory.'.php');
                        }

                        if (!is_null($modules['scope']['class'])) {
                            $module = new $modules['scope']['class']($this, $modules);

                            $dataView = $module->route();
                        }
                    }
                }
            }
        }

        return $dataView;
    }

    public function database()
    {
        return $this->database;
    }

    public function callback()
    {
        return $this->callback;
    }

    public function render()
    {
        return $this->render;
    }

    public function modules()
    {
        return $this->modules;
    }

    public function getLangActive()
    {
        return $this->langActive;
    }

    public function getLang()
    {
        return $this->lang;
    }

    public function getLangIso()
    {
        return $this->langIso;
    }

    public function executerErrorUrl()
    {
        $url = base64_encode(Request::urlComplet());

        header('Location: '.Request::permalink($this->getLocale('key', 'error404').'/?route='.$url));
        exit;
    }

    public function getLocale($params1 = null, $params2 = null, $params3 = null)
    {
        if (!is_null($params1) && $this->locale && $params1 && !is_bool($params1)) {
            if (array_key_exists($params1, $this->locale)) {
                if (is_null($params2)) {
                    return $this->locale[$params1];
                }
                else {
                    if (array_key_exists($params2, $this->locale[$params1])) {
                        if (is_null($params3)) {
                            return $this->locale[$params1][$params2];
                        }
                        else {
                            if (array_key_exists($params3, $this->locale[$params1][$params2])) {
                                return $this->locale[$params1][$params2][$params3];
                            }
                        }
                    }
                    else {
                        return false;
                    }
                }
            }
            else {
                return false;
            }
        }
        else {
          return $this->locale;
        }
    }

    public function loadSite($dataView)
    {
        if (is_null($dataView)) {
            $error404File = config('app.ROOT_MODULES').'/error404.php';

            if (file_exists($error404File)) {
                include($error404File);

                $error404 = new Error404($this);

                $dataView = $error404->init();
            }
        }

        if (is_array($dataView)) {
            if (array_key_exists('og', $dataView['module'])) {
                $this->render()->setVars('og', $dataView['module']['og']);
            }
            else {
                $this->render()->setVars('og', $this->modules()->openGraph());
            }

            if (array_key_exists('page', $dataView['module'])) {
                $extra = $this->render()->getVars('extra');

                if ($extra) {
                    if (array_key_exists('pageinternal', $extra)) {
                        $dataView['module']['page']['header']['bg'] = $extra['assets']['pageinternal'];
                    }
                }
            }
        }

        $this->render()->setVars('callback', $this->callback()->getReturn());
        $this->render()->setVars('view', $dataView);

        $this->modules()->setStats('website');

        unset($this->database);
        unset($this->modules);

        $this->render()->init(null);
    }

    public function setLang()
    {
        $lang = $this->database()->getBaseData('pageLanguage');

        if (isset($lang['langtitle'])) {
            $langtitle = $lang['langtitle'];
            $langkey = $lang['langkey'];
            $isokey = $lang['isokey'];
            $flagkey = $lang['flagkey'];
            $statuskey = $lang['statuskey'];

            if (!Request::seo(1, false) && !$this->getLangActive()) {
                // header("Location: ".Request::permalink('index'));
                // exit;
            }

            if ($this->getLangActive()) {
                if (in_array(Request::seo(1, false), $langkey)) {
                    foreach ($langkey as $key => $value) {
                        if ($statuskey[$key] == 1) {
                            $this->language[$value] = [
                                'title' => $langtitle[$key],
                                'flag' =>  $flagkey[$key],
                                'iso' =>  $isokey[$key],
                                'url' => Request::permalink($langkey[$key], true),
                                'active' => false
                            ];
                        }

                        if ($this->getLang() == $value) {
                            $this->language[$value]['active'] = true;
                        }
                    }

                    if (count($this->language) <= 1) {
                        $this->langActive = false;
                    }

                    if (!Request::seo(1, false) && $this->getLangActive()) {
                        header("Location: ".Request::permalink($this->getLang(), true));
                        exit;
                    }

                    if ($this->getLangActive()) {
                        $this->lang = Request::seo(0);
                        $this->langIso = $this->language[$this->lang]['iso'];
                    }

                    if ($this->getLang()) {
                        $this->locale = include(config('app.ROOT_SITE').'/app/lang/'.$this->getLangIso().'.php');

                        $this->primary = array('id' => null, 'name' => $this->language[$this->lang]['title'], 'key' => $this->getLang());
                    }
                }
                else {
                    header("Location: ".Request::permalink($this->getLang(), true));
                    exit;
                }
            }
            else {
                $this->locale = lang('site::default');

                if ($langtitle[0]) {
                    $this->primary = [
                        'id' => null,
                        'name' => $langtitle[0],
                        'key' => $this->getLang()
                    ];
                }
            }
        }
    }

    public function assets($path)
    {
        $core = $this->render()->getVars('core');

        return $core['public'].'/'.$path;
    }

    public function core()
    {
        $site = $this->database()->getBaseData('pageSite');
        $auth = $this->database()->getBaseData('pageAuths');
        $assets = $this->database()->getBaseData('pageAssets');
        $scripts = $this->database()->getBaseData('pageScripts');

        if ($scripts) {
            foreach ($scripts as $key => $value) {
                $scripts[$key] = Treatment::string($value, 'code');
            }
        }

        $favicon = null;

        if (isset($assets['favicon']['file'])) {
            $favicon = Assets::loadThumb($assets['favicon']['file'], 'configuration', 'default');
        }

        $core = [
            'backend' => config('app.BACKEND'),
            'frontend' => config('app.FRONTEND'),
            'register' => config('app.REGISTER'),
            'public' => config('app.PATH_PUBLIC'),
            'assets' => config('app.PATH_PUBLIC').'/assets',
            'author' => config('app.AUTHOR'),
            'url' => config('app.PATH_SITE'),
            'upload' => config('app.PATH_UPLOAD'),
            'favicon' => $favicon,
            'flags' => config('app.PATH_CMS').'/public/img/flags',
            'permalink' => Request::permalink(),
            'linkrestrict' => Request::permalink($this->getLocale('key', 'restrict')),
            'module' => Request::seo(1),
            'auth' => $auth,
            'langs' => $this->language,
            'langActive' => $this->langActive,
            'urlComplet' => Request::urlComplet(),
            'keylang' => $this->getLangIso(),
            'scripts' => $scripts,
            'repository' => config('app.PATH_CORE').'/repository',
            'pathApis' => config('app.PATH_API'),
            'pathVendors' => config('app.PATH_VENDORS'),
            'pathCms' => config('app.PATH_CMS'),
            'pathTinymce' => config('app.PATH_CMS').'/public/js/tinymce',
            'assetsVersion' => $this->assetsVersion,
            'preloader' => [
                'color' => config('app.COLOR_PRIMARY_COMPANY'),
                'bg' => config('app.BG_PRIMARY_COMPANY')
            ]
        ];

        if (isset($site['title'])) {
            $core['title'] = $site['title'];
            $core['metatitle'] = $site['metatitle'];
            $core['metadescription'] = $site['metadescription'];
            $core['metakeywords'] = $site['metakeywords'];
        }

        if (isset($this->primary['name'])) {
            $core['langTitleActive'] = $this->primary['name'];
        }

        return $core;
    }

    public function header()
    {
        $site = $this->database()->getBaseData('pageSite');
        $assets = $this->database()->getBaseData('pageAssets');

        $logo = null;

        if ($assets) {
            $file = Assets::loadThumb($assets['logoheader']['file'], 'configuration', 'default');

            if ($file) {
                $logo = [
                    'img' => $file,
                    'title' => $site['title'],
                    'url' => Request::permalink(),
                    'class' => null
                ];
            }
        }

        $socialBase = $this->database()->getBaseData('pageSocial');
        $social = Tools::prepareSocialNetworks($socialBase);

        $menu = $this->menu();

        $search = [
            'url' => Request::permalink($this->getLocale('search', 'key')),
            'title' => $this->getLocale('search', 'title'),
            'label' => $this->getLocale('search', 'label'),
            'button' => $this->getLocale('search', 'button'),
            'placeholder' => $this->getLocale('search', 'placeholder')
        ];

        $auth = $this->render()->getVars('core');

        if (isset($auth['auth'])) {
            $auth = $auth['auth'];
        }

        $whatsapp = null;

        if (is_array($auth)) {
            if (array_key_exists('whatsappnumber', $auth)) {
                if ($auth['whatsappactive'] == 1) {
                    $whatsapp['number'] = Treatment::string($auth['whatsappnumber'], 'calltonot+');
                    $whatsapp['numbercallto'] = Treatment::string($auth['whatsappnumber'], 'callto');
                    $whatsapp['numberview'] = Treatment::string($auth['whatsappnumber']);
                    $whatsapp['message'] = rawurlencode(Treatment::string($auth['whatsappmessage'], 'unserializestring'));
                    $whatsapp['label'] = Treatment::string($auth['whatsapplabel'], 'unserializestring');
                    $whatsapp['type'] = Treatment::string($auth['whatsapptype'], 'int');
                    $whatsapp['position'] = Treatment::string($auth['whatsappposition'], 'int');
                    $whatsapp['link'] = 'https://api.whatsapp.com/send?phone='.$whatsapp['number'].'&text='.$whatsapp['message'];
                }
            }
        }

        $dataHeader = [
            'social' => $social,
            'logo' => $logo,
            'menu' => $menu,
            'search' => $search,
            'whatsapp' => $whatsapp
        ];

        return $dataHeader;
    }

    public function footer($array = false)
    {
        $site = $this->database()->getBaseData('pageSite');
        $assets = $this->database()->getBaseData('pageAssets');
        $info = $this->database()->getBaseData('pageInfo');

        if (!is_array($assets)) {
            $assets = [];
        }

        $infoAddress = Tools::prepareAddress($info);

        $infoPhones = $infoEmails = null;

        if (isset($info['phones'])) {
            $infoPhones = Tools::preparePhones($info['phones']);
        }

        if (isset($info['emails'])) {
            $infoEmails = Tools::prepareEmails($info['emails']);
        }

        $infoBusinessHour = $infoExtra = $company = $cnpj = null;


        if (isset($info['stringBusinessHour'])) {
            $businessHourArray = $info['stringBusinessHour'];

            if (is_array($businessHourArray)) {
                foreach ($businessHourArray as $key => $value) {
                    $infoBusinessHour[$key] = Treatment::string($value, 'text');
                }
            }
        }

        if (isset($info['labelExtraData']) && isset($info['valueExtraData'])) {
            $extraDataArray = $info['labelExtraData'];
            $extraDataValueArray = $info['valueExtraData'];

            if (is_array($extraDataArray)) {
                $totalArray = count($extraDataArray);

                for ($i = 0; $i < $totalArray; $i++) {
                    $infoExtra[$i]['label'] = Treatment::string($extraDataArray[$i]);

                    if ($extraDataValueArray) {
                        $infoExtra[$i]['value'] = Treatment::string($extraDataValueArray[$i]);
                    }
                    else {
                        $infoExtra[$i]['value'] = null;
                    }
                }
            }
        }

        if (isset($info['company'])) {
            $company = $info['company'];
        }

        if (isset($info['cnpj'])) {
            $cnpj = $info['cnpj'];
        }

        $infoCopyright = null;

        if (isset($site['copyright'])) {
            $infoCopyright = Treatment::string($site['copyright'], 'text');
        }

        $logo = null;

        if (isset($assets['logofooter']['file'])) {
            $file = Assets::systemThumb($assets['logofooter']['file'], 'configuration', 'default');

            if ($file) {
                $logo = [
                    'img' => $file,
                    'title' => $site['title'],
                    'url' => Request::permalink()
                ];
            }
        }

        $dataFooter = [
            'menu' => $this->menu(2),
            'logo' => $logo,
            'copyright' => $infoCopyright,
            'address' => $infoAddress,
            'phones' => $infoPhones,
            'emails' => $infoEmails,
            'company' => $company,
            'cnpj' => $cnpj,
            'businessHour' => $infoBusinessHour,
            'extra' => $infoExtra
        ];

        if (isset($info['cnpj'])) {
            $dataFooter['cnpj'] = $info['cnpj'];
        }

        return $dataFooter;
    }

    public function menu($type = 1, $forcePrimary = null)
    {
        $dataReturn = null;

        $querySql = "SELECT `id_menu`, `internal_menu`, `url_menu`, `image_menu`, `key_menu`, `label_menu`, `target_menu`, `order_menu`, `title_menu-type` FROM `mod_menu`
                     INNER JOIN `mod_menu-type` ON (`id_menu-type` = `type_menu` AND `status_menu-type` = 'active' AND `id_menu-type` = '".intval($type)."')
                     WHERE `status_menu` = 'active' ORDER BY `order_menu`";

        if ($query = $this->database()->dbFetchAll($querySql)) {
            foreach ($query as $key => $value) {
                if ($value['internal_menu'] == 1) {
                    $url = Request::permalink($value['url_menu']);
                }
                else if ($value['internal_menu'] == 2) {
                    $url = $value['url_menu'];
                }
                else if ($value['internal_menu'] == 3) {
                    $keyPage = $this->database()->getLabelMod('mod_page', 'page', $value['url_menu'], 'slug');

                    $url = Request::permalink($keyPage, $forcePrimary);
                }

                $querySubMenuSql = "SELECT `id_menu-submenu`, `internal_menu-submenu`, `url_menu-submenu`, `image_menu-submenu`, `key_menu-submenu`, `label_menu-submenu`, `target_menu-submenu`, `order_menu-submenu` FROM `mod_menu-submenu`
                                    INNER JOIN `mod_menu` ON (`id_menu` = `primary_menu-submenu` AND `status_menu` = 'active' AND `id_menu` = '".intval($value['id_menu'])."')
                                    WHERE `status_menu-submenu` = 'active' ORDER BY `order_menu-submenu`";

                $querySubMenu = $this->database()->dbFetchAll($querySubMenuSql);

                $submenuReturn = [];

                if ($querySubMenu) {
                    foreach ($querySubMenu as $keySubMenu => $valueSubMenu) {
                        if ($valueSubMenu['internal_menu-submenu'] == 1) {
                            $urlSubmenu = Request::permalink($valueSubMenu['url_menu-submenu']);
                        }
                        else if ($valueSubMenu['internal_menu-submenu'] == 2) {
                            $urlSubmenu = $valueSubMenu['url_menu-submenu'];
                        }
                        else if ($valueSubMenu['internal_menu-submenu'] == 3) {
                            $urlSubmenu = Request::permalink($this->database()->getLabelMod('mod_page', 'page', $valueSubMenu['url_menu-submenu'], 'slug'), $forcePrimary);
                        }

                        $image = null;

                        if ($valueSubMenu['image_menu-submenu']) {
                            $file = Assets::loadThumb($valueSubMenu['image_menu-submenu'], 'menu-submenu', 'default');

                            $image = $file['image']['src'];
                        }

                        $submenuReturn[$valueSubMenu['id_menu-submenu']] = [
                            'id' => Treatment::string($valueSubMenu['id_menu-submenu'], 'int'),
                            'key' => Treatment::string($valueSubMenu['key_menu-submenu']),
                            'title' => Treatment::string($valueSubMenu['label_menu-submenu'], 'text'),
                            'urlKey' => $valueSubMenu['key_menu-submenu'],
                            'url' => $urlSubmenu,
                            'target' => Treatment::string($valueSubMenu['target_menu-submenu']),
                            'active' => $this->statusMenu($valueSubMenu['key_menu-submenu']),
                            'image' => $image,
                            'order' => Treatment::string($valueSubMenu['order_menu-submenu'], 'int')
                        ];
                    }
                }

                $image = null;

                if ($value['image_menu']) {
                    $file = Assets::loadThumb($value['image_menu'], 'menu', 'default');

                    $image = $file['image']['src'];
                }

                $dataReturn['scope']['title'] = $value['title_menu-type'];

                $dataReturn['itens'][$value['id_menu']] = [
                    'id' => Treatment::string($value['id_menu'], 'int'),
                    'key' => Treatment::string($value['key_menu']),
                    'title' => Treatment::string($value['label_menu'], 'text'),
                    'urlKey' => $value['key_menu'],
                    'url' => $url,
                    'target' => Treatment::string($value['target_menu']),
                    'active' => $this->statusMenu($value['key_menu']),
                    'order' => Treatment::string($value['order_menu'], 'int'),
                    'image' => $image,
                    'subitem' => $submenuReturn
                ];
            }
        }

        return $dataReturn;
    }

    public function statusMenu($command)
    {
        $dataReturn = 'no-active';

        $keyActive = explode('/', $command);

        if ($keyActive[0] === Request::seo(1)) {
            $dataReturn = 'active';
        }
        else if (Request::seo(1) === $this->getLocale('key', 'page')) {
            if ($keyActive[0] === Request::seo(2)) {
                $dataReturn = 'active';
            }
        }

        return $dataReturn;
    }

    public function openGraph()
    {
        $site = $this->database()->getBaseData('pageSite');
        $assets = $this->database()->getBaseData('pageAssets');

        $og = [
            'site_name' => Treatment::string($site['title'], 'text'),
            'url' => Request::permalink(),
            'title' => Treatment::string($site['metatitle'], 'text'),
            'description' => Treatment::string($site['metadescription'], 'text'),
            'type' => 'website',
            'image' => config('app.PATH_UPLOAD').'/configuration/images/'.$assets['logoopengraph']['file']
        ];

        return $og;
    }

    public function loadExtra()
    {
        $extra = null;

        foreach ($this->modulesSystem as $key => $value) {
            if ($value['type'] == 'static') {
                $automatics = include(config('app.ROOT_CMS').'/'.$value['folder'].'/'.$key.'/automatic-forms-config.php');

                foreach ($automatics as $keyAutomatic => $valueAutomatic) {
                    $keyArray = strtolower(str_replace('extra', '', $keyAutomatic));
                    $keyArray = str_replace($key, '', $keyArray);

                    $extra[$key][$keyArray] = $this->database()->getBaseData($keyAutomatic);

                    if ($extra[$key][$keyArray]) {
                        foreach ($extra[$key][$keyArray] as $keyExtra => $valueFinals) {
                            if (is_array($valueFinals)) {
                                foreach ($valueFinals as $keyFinal => $value) {
                                    if ($keyExtra == 'video' || $keyFinal == 'video') {
                                        $video = Assets::setVideoTemplate($value);

                                        $videoSource['thumb'] = Assets::getVideoThumbnail($video);
                                        $videoSource['src'] = Assets::getVideo($video);

                                        $extra[$key][$keyArray][$keyExtra][$keyFinal] = $videoSource;
                                    }
                                    else if ($keyFinal == 'itens' || $keyFinal == 'itens1' || $keyFinal == 'itens2') {
                                        foreach ($value as $kdl => $vdl) {
                                            foreach ($vdl as $kvdl => $vvdl) {
                                                $value[$kdl][$kvdl] = Treatment::string($vvdl, 'unserializestring');
                                            }
                                        }

                                        $extra[$key][$keyArray][$keyExtra][$keyFinal] = $value;
                                    }
                                    else if ($keyExtra != 'assets') {
                                        $extra[$key][$keyArray][$keyExtra][$keyFinal] = Treatment::string($value, 'unserializestring');

                                        if ($keyFinal == 'text' || $keyFinal == 'embed') {
                                            if (@base64_decode($extra[$key][$keyArray][$keyExtra][$keyFinal])) {
                                                $extra[$key][$keyArray][$keyExtra][$keyFinal] = Treatment::string(base64_decode($extra[$key][$keyArray][$keyExtra][$keyFinal]), 'text');
                                            }
                                        }
                                    }
                                    else {
                                        $extra[$key][$keyArray][$keyExtra][$keyFinal] = $value;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        if ($extra && is_array($extra)) {
            $upload = ['assets'];

            foreach ($upload as $uploadKey) {
                foreach ($extra as $extraKeyCategory => $extraModules) {
                    if (is_array($extraModules)) {
                        foreach ($extraModules as $extraKeyModules => $extraPages) {
                            if (is_array($extraPages) && array_key_exists($uploadKey, $extraPages)) {
                                foreach ($extraPages[$uploadKey] as $key => $value) {
                                    if (!is_array($value)) {
                                        if (file_exists(config('app.ROOT_UPLOAD').'/'.$extraKeyCategory.'/images/'.$value)) {
                                            $thumb = Assets::loadThumb($value, $extraKeyCategory, 'default');

                                            if (isset($thumb)) {
                                                $extra[$extraKeyCategory][$extraKeyModules][$uploadKey][$key] = $thumb['src'];
                                            }
                                        }
                                        else {
                                            unset($extra[$extraKeyCategory][$extraKeyModules][$uploadKey][$key]);
                                        }
                                    }
                                    else if (is_array($value)) {
                                        if ($value['extension'] == 'jpg' || $value['extension'] == 'png' || $value['extension'] == 'gif' || $value['extension'] == 'webp') {
                                            $thumb = Assets::loadThumb($value['name'], $extraKeyCategory, 'default');

                                            $extra[$extraKeyCategory][$extraKeyModules][$uploadKey][$key] = $thumb;
                                        }
                                        else {
                                            $fileParams = $value;

                                            $fileParams['root'] = config('app.ROOT_UPLOAD').'/'.$extraKeyCategory.'/files/'.$fileParams['name'];

                                            $upload['web'] = config('app.PATH_UPLOAD').'/'.$extraKeyCategory.'/files/'.$fileParams['name'];

                                            $upload['download'] = config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($fileParams));

                                            $extra[$extraKeyCategory][$extraKeyModules][$uploadKey][$key] = $upload;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }

            if (array_key_exists('static', $extra)) {
                if (array_key_exists('localization', $extra['static'])) {
                    if (is_array($extra['static']['localization']) && array_key_exists('map', $extra['static']['localization'])) {
                        if (array_key_exists('lng', $extra['static']['localization']['map'])) {
                            $extra['static']['localization']['map']['lng'] = $extra['static']['localization']['map']['lng'] - (-00.00220000);
                        }
                    }
                }
            }

            return $extra;
        }
    }

    public function loadModules()
    {
        $modules = null;

        foreach ($this->modulesSystem as $key => $value) {
            if ($value['active'] == 1 && $value['type'] == 'primary') {
                $moduleCheck = $this->database()->getBaseData('modulesInfo-'.$key);

                if (is_array($moduleCheck)) {
                    foreach ($moduleCheck as $tagKey => $tagArray) {
                        foreach ($tagArray as $tag=> $valueTag) {
                            $modules[$key][$tagKey][$tag] = Treatment::string($valueTag, 'text');
                        }
                    }
                }
            }
        }

        return $modules;
    }

    public function extraPhoto($key, $tuple, $params, $zoom = true)
    {
        $limit = 48;

        if ($params['limit']) {
            $limit = $params['limit'];
        }

        $querySql = "SELECT * FROM `sub_photo`
                     WHERE `table_photo` = 'mod_".$key."' AND `tuple_photo` = '".$tuple."' AND `status_photo` = 'active'
                     ORDER BY  `order_photo`";

        $index = 0;
        $dataReturn = null;

        $paginationConfig = $this->locale['pagination'];
        $paginationConfig[1] = 'paginaGaleria-';
        $paginationConfig[7] = 'paginaGaleria-1';

        $pagination = new \CoreSlim\PaginationGet([
            'locale' => $paginationConfig,
            'item' => $limit,
            'query' => $querySql
        ]);

        if ($query = $this->database()->dbFetchAll($pagination->execute())) {
            if ($params['title']) {
                $dataReturn['info']['title'] = Treatment::string($params['title'], 'text');
            }
            else {
                $extra = $this->getExtra('global');

                $dataReturn['info']['title'] = Treatment::string($extra['additional']['gallery-photo'], 'text');
            }

            if ($params['cols']) {
                $dataReturn['info']['cols'] = $params['cols'];
            }

            foreach ($query as $keyQuery => $result) {
                $dataReturn['gallery'][$index]['title'] = Treatment::string($result['legend_photo'], 'text');

                if ($result['credit_photo'] != '') {
                    if ($result['legend_photo'] != '') {
                        $dataReturn['gallery'][$index]['title'] .= ' - ';
                    }

                    $dataReturn['gallery'][$index]['title'] .= Treatment::string($result['credit_photo'], 'text');
                }

                if (@json_encode($result['file_photo'])) {
                    $photoJson = json_decode($result['file_photo'], true);

                    if ($zoom != false){
                        $dataReturn['gallery'][$index]['original'] = Assets::loadThumb($photoJson, $key, 'larger');
                    }

                    $dataReturn['gallery'][$index]['thumb'] = Assets::loadThumb($photoJson, $key, 'smaller');
                }

                $index++;
            }

            $dataReturn['total'] = $pagination->total;
            $dataReturn['pagination'] = $pagination->navigation();

            return $dataReturn;
        }
    }

    public function extraVideo($key, $tuple, $params, $type = 'thumb')
    {
        $limit = null;

        if ($params['limit']) {
            $limit = ' LIMIT '.$limit;
        }

        $index = 1;
        $dataReturn = null;

        $querySql = "SELECT `tag_video`, `legend_video`, `credit_video` FROM `sub_video`
                     WHERE `table_video` = 'mod_".$key."' AND `tuple_video` = '".$tuple."' AND `status_video` = 'active'
                     ORDER BY `order_video` ".$limit;

        if ($query = $this->database()->dbFetchAll($querySql)) {
            if ($params['title']) {
                $dataReturn['info']['title'] = Treatment::string($params['title'], 'text');
            }
            else {
                $extra = $this->getExtra('global');

                $dataReturn['info']['title'] = Treatment::string($extra['additional']['gallery-video'], 'text');
            }

            if ($params['cols']) {
                $dataReturn['info']['cols'] = $params['cols'];
            }

            foreach ($query as $key => $result) {
                if (@json_decode($result['tag_video'])) {
                    $tag = json_decode($result['tag_video'], true);
                }

                if ($tag['type'] == 'youtube') {
                    if (isset($tag['list'])) {
                        $dataReturn['gallery'][$index]['tag'] = '//www.youtube.com/embed/videoseries?list='.$tag['list'];
                        $dataReturn['gallery'][$index]['link'] = 'https://www.youtube.com/embed/videoseries?list='.$tag['list'];

                        if (isset($tag['index'])) {
                            $dataReturn['gallery'][$index]['tag'] = $dataReturn['gallery'][$index]['tag'].'&index='.$tag['index'];
                            $dataReturn['gallery'][$index]['link'] = $dataReturn['gallery'][$index]['link'].'&index='.$tag['index'];
                        }
                    }
                    else {
                        $dataReturn['gallery'][$index]['tag'] = '//www.youtube.com/embed/'.$tag['code'];
                        $dataReturn['gallery'][$index]['link'] = 'https://www.youtube.com/embed/'.$tag['code'];
                    }

                    $dataReturn['gallery'][$index]['thumb'] = 'https://i1.ytimg.com/vi/'.$tag['code'].'/mqdefault.jpg';
                    $dataReturn['gallery'][$index]['original'] = 'https://i1.ytimg.com/vi/'.$tag['code'].'/maxresdefault.jpg';
                }
                else if ($tag['type'] == 'vimeo') {
                    $dataReturn['gallery'][$index]['tag'] = '//player.vimeo.com/video/'.$tag['code'].'?badge=0&amp;color=ffffff';
                    $dataReturn['gallery'][$index]['thumb'] = '//player.vimeo.com/video/'.$tag['code'].'?badge=0&amp;color=ffffff';
                    $dataReturn['gallery'][$index]['original'] = '//player.vimeo.com/video/'.$tag['code'].'?badge=0&amp;color=ffffff';
                    $dataReturn['gallery'][$index]['link'] = '//player.vimeo.com/video/'.$tag['code'].'?badge=0&amp;color=ffffff';
                }

                if ($result['legend_video']) {
                    $dataReturn['gallery'][$index]['legend'] = Treatment::string($result['legend_video'], 'text');
                }

                if ($result['credit_video']) {
                    $dataReturn['gallery'][$index]['credit'] = Treatment::string($result['credit_video'], 'text');
                }

                $index++;
            }

            return $dataReturn;
        }
    }

    public function extraAnexx($key, $tuple, $params)
    {
        $limit = null;

        if ($params['limit']) {
            $limit = ' LIMIT '.$limit;
        }

        $index = 1;
        $dataReturn = null;

        $querySql = "SELECT * FROM `sub_anexx`
                     WHERE `table_anexx` = '".$params['prefix']."_".$key."' AND `tuple_anexx` = '".$tuple."' AND `status_anexx` = 'active'
                     ORDER BY `order_anexx` ".$limit;

        if ($query = $this->database()->dbFetchAll($querySql)) {
            if ($params['title']) {
                $dataReturn['info']['title'] = Treatment::string($params['title'], 'text');
            }
            else {
                $extra = $this->getExtra('global');

                $dataReturn['info']['title'] = Treatment::string($extra['additional']['gallery-anexx'], 'text');
            }

            if ($params['cols']) {
                $dataReturn['info']['cols'] = $params['cols'];
            }

            foreach ($query as $keyQuery => $result) {
                if (@json_decode($result['file_anexx'])) {
                    $fileParams = json_decode($result['file_anexx'], true);

                    $fileParams['root'] = config('app.ROOT_UPLOAD').'/'.$key.'/files/'.$fileParams['name'];
                    $fileParams['path'] = config('app.PATH_UPLOAD').'/'.$key.'/files/'.$fileParams['name'];

                    $fileParams['inTable'] = 'sub_anexx';
                    $fileParams['inSufix'] = 'anexx';
                    $fileParams['id'] = intval($result['id_anexx']);
                    $fileParams['table'] = $result['table_anexx'];
                    $fileParams['tuple'] = intval($result['tuple_anexx']);
                }

                if (isset($fileParams)) {
                    $dataReturn['gallery'][$index]['file'] = config('app.PATH_API').'/getDownload.php?parameter='.base64_encode(json_encode($fileParams));

                    if ($fileParams['mimetype'] === 'application/pdf') {
                        $dataReturn['gallery'][$index]['icon'] = 'far fa-file-pdf';
                    }
                    else if ($fileParams['extension'] === 'xls' || $fileParams['extension'] === 'xlsx') {
                        $dataReturn['gallery'][$index]['icon'] = 'far fa-file-excel';
                    }
                    else if ($fileParams['extension'] === 'doc' || $fileParams['extension'] === 'docx') {
                        $dataReturn['gallery'][$index]['icon'] = 'far fa-file-word';
                    }
                    else {
                        $dataReturn['gallery'][$index]['icon'] = 'far fa-file-archive';
                    }

                    $dataReturn['gallery'][$index]['legend'] = Treatment::string($result['legend_anexx'], 'text');

                    if (!$dataReturn['gallery'][$index]['legend']) {
                        $dataReturn['gallery'][$index]['legend'] = $fileParams['realname'];
                    }
                }

                $index++;
            }

            return $dataReturn;
        }
    }

    public function extraAudio($key, $tuple, $params)
    {
        $limit = null;

        if ($params['limit']) {
            $limit = ' LIMIT '.$limit;
        }

        $index = 1;
        $dataReturn = null;

        $querySql = "SELECT `file_audio`, `legend_audio` FROM `sub_audio`
                     WHERE `table_audio` = 'mod_".$key."' AND `tuple_audio` = '".$tuple."' AND `status_audio` = 'active'
                     ORDER BY `order_audio` ".$limit;

        if ($query = $this->database()->dbFetchAll($querySql)) {
            if ($params['title']) {
                $dataReturn['info']['title'] = Treatment::string($params['title'], 'text');
            }
            else {
                $extra = $this->getExtra('global');

                $dataReturn['info']['title'] = Treatment::string($extra['additional']['gallery-audio'], 'text');
            }

            if ($params['cols']) {
                $dataReturn['info']['cols'] = $params['cols'];
            }

            foreach ($query as $keyQuery => $result) {
                if (@json_decode($result['file_audio'])) {
                    $fileParams = json_decode($result['file_audio'], true);
                }

                $dataReturn['gallery'][$index]['file'] = config('app.PATH_UPLOAD').'/'.$key.'/audios/'.$fileParams['name'];
                $dataReturn['gallery'][$index]['legend'] = Treatment::string($result['legend_audio'], 'text');

                $index++;
            }

            return $dataReturn;
        }
    }

    public function manipuleUrl($data)
    {
        if (array_key_exists('urlbase', $data)) {
            if ($data['internal'] == 1 && $data['urlbase'] != '#') {
                $data['url'] = Request::permalink($data['urlbase']);
            }
            else if ($data['internal'] == 2) {
                $data['url'] = $data['urlbase'];
            }
            else if ($data['internal'] == 3) {
                $data['url'] = Request::permalink($this->database()->getLabelMod('mod_page', 'page', $data['urlbase'], 'slug'), true);
            }
            else {
                $data['url'] = null;
            }

            unset($data['urlbase']);
        }
        else {
            $data['url'] = null;
        }

        return $data;
    }

    public function defineModulesSystem()
    {
        $this->modulesSystem = Tools::jsonOpen(config('app.ROOT_CMS').'/system-modules.json', true);
        $extraModules = Tools::jsonOpen(config('app.ROOT_CMS').'/extra-modules.json', true);

        if (is_array($extraModules)) {
            foreach ($this->modulesSystem as $keyModules => $valueModules) {
                if (!$valueModules['active']) {
                    unset($this->modulesSystem[$keyModules]);
                }
            }

            $newModules = array_merge($this->modulesSystem, $extraModules);

            unset($this->modulesSystem);

            $this->modulesSystem = $newModules;
        }
    }

    public function protectionRecaptcha($urlCallback)
    {
        $auth = $this->database()->getBaseData('pageAuths');

        if ($auth['recaptchaactive'] == 1) {
            $recaptcha_secret = $auth['recaptchasecret'];
            $response_post = Request::post('g-recaptcha-response');
            $response = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$recaptcha_secret.'&response='.$response_post.'&remoteip='.$_SERVER['REMOTE_ADDR']);
            $response = json_decode($response, true);

            if ($response['success'] === false) {
                $this->callback()->set('recaptcha', $urlCallback);

                return false;
            }
            else {
                return true;
            }
        }
    }

    public function checkFormIntegrity($key, $urlCallback, $recaptcha = true)
    {
        if (Tools::checkCsfrToken($key, $urlCallback, $this->callback())) {
            if ($recaptcha) {
                if ($this->protectionRecaptcha($urlCallback)) {
                    return true;
                }
            }
            else {
                return true;
            }
        }
    }

    public function monitorNewsletter($data = null)
    {
        $database = $this->database();

        if (is_null($data)) {
            $data = $this->getConfig('data');
        }

        if (!is_null($data) && file_exists(config('app.ROOT_MODULES').'/newsletter.php')) {
            if (!class_exists('Newsletter')) {
                include(config('app.ROOT_MODULES').'/newsletter.php');
            }

            $newsletter = new Newsletter($this);

            if (array_key_exists($database->sufix('name'), $data)) {
                $dataNewsletter['name_newsletter'] = $data[$database->sufix('name')];
            }
            else if (array_key_exists('name', $data)) {
                $dataNewsletter['name_newsletter'] = $data['name'];
            }

            if (array_key_exists($database->sufix('email'), $data)) {
                $dataNewsletter['email_newsletter'] = $data[$database->sufix('email')];
            }
            else if (array_key_exists('email', $data)) {
                $dataNewsletter['email_newsletter'] = $data['email'];
            }

            if (array_key_exists($database->sufix('phone'), $data)) {
                $dataNewsletter['phone_newsletter'] = $data[$database->sufix('phone')];
            }
            else if (array_key_exists('phone', $data)) {
                $dataNewsletter['phone_newsletter'] = $data['phone'];
            }

            $dataNewsletter['checked_newsletter'] = intval(Request::post($database->sufix('newsletter')));

            $newsletter->storeNewsletter($dataNewsletter);
        }
    }

    public function prepareValidadeForms($extra, $locale)
    {
        if (isset($locale['validate'])) {
            $validates['system'] = $locale['validate'];

            if ($extra) {
                foreach ($extra as $keyCategory => $modules) {
                    foreach ($modules as $key => $value) {
                        if (is_array($value) && array_key_exists('validate', $value)) {
                            $validates[$keyCategory][$key] = $value['validate'];
                        }
                    }
                }
            }

            $this->render()->setVars('validate', json_encode($validates));
        }
    }

    public function getAdmin($id)
    {
        $query = "SELECT `signature_administrator` as signature FROM `mod_administrator` WHERE `id_administrator` = '".$id."'";

        if ($result = $this->database()->dbFetch($query)) {
            return Treatment::string($result['signature']);
        }
    }
}
