<?php

// doopSites v1.9.7 - Última atualização 17/02/2023 13:14

header("Access-Control-Allow-Origin: *");
header('Content-Type: text/html; charset=utf-8');

require_once(__DIR__.'/../../../vendor/autoload.php');

session_name(config('app.LGPD_KEY'));
session_start([
    'cookie_lifetime' => config('app.LGPD_EXPIRE')
]);

date_default_timezone_set(config('app.TIMEZONE'));

$parameter = $_GET['parameter'];

if (@base64_decode($parameter)) {
    $parameter = base64_decode($parameter);
    $parameter = json_decode($parameter, true);

    $parameter['root'] = str_replace('/', DIRECTORY_SEPARATOR, $parameter['root']);

    if (file_exists($parameter['root'])) {
        if ($parameter['realname']) {

            $parameter['realname'] = htmlspecialchars_decode(stripcslashes($parameter['realname']));

            if (strpos($parameter['realname'], '.'.$parameter['extension']) == false) {
                $filename = mb_strtolower($parameter['realname'].'.'.$parameter['extension']);
            }
            else {
                $filename = mb_strtolower($parameter['realname']);
            }
        }
        else {
            $parameter['name'] = htmlspecialchars_decode(stripcslashes($parameter['name']));

            if (strpos($parameter['name'], '.'.$parameter['extension']) == false) {
                $filename = mb_strtolower($parameter['name'].'.'.$parameter['extension']);
            }
            else {
                $filename = mb_strtolower($parameter['name']);
            }
        }

        header('Cache-control: private');
        header('Content-Type: '.$parameter['mimetype']);
        header('Content-Length: '.filesize($parameter['root']));

        if ($parameter['mimetype'] == 'application/pdf') {
            header("Content-Disposition: inline; filename=".$filename);
            header('Content-Transfer-Encoding: binary');
            header('Accept-Ranges: bytes');
        }
        else {
            header("Content-Disposition: attachment; filename=".$filename);
        }

        readfile($parameter['root']);

        if (class_exists('\CoreSlim\Stats\StatsCentral') && isset($parameter['inTable']) && isset($parameter['id'])) {
            $stats = new \CoreSlim\Stats\StatsCentral($parameter['inTable']);
            $stats->addDownload($parameter);

            unset($stats);

            exit;
        }
    }
    else {
        die('Download n&atilde;o encontrado');
    }
}
