<?php

class YearFilter extends MasterFilter
{
    public $keyUrl = 'year';

    public $moduleInstance = null;

    public function __construct($moduleInstance)
    {
        parent::__construct($moduleInstance);
    }

    public function load()
    {
        if (!parent::load() && !$this->getUrl()) {
            $this->set('all-years');
        }
    }

    public function generateFilter()
    {
        if ($this->target()->has()) {
            $dataFilter = null;

            $stats = $this->statsFilter();

            if ($stats) {
                foreach ($stats as $key => $value) {
                    $dataFilter[$key] = [
                        'key' => $key,
                        'value' => $this->setUrl($key),
                        'title' => 'Ano '.$key,
                        'selected' => $this->check($key),
                        'disabled' => false
                    ];
                }

                $dataFilter['all-years'] = [
                    'key' => 'all-years',
                    'value' => $this->setUrl('all-years'),
                    'title' => 'TODOS OS ANOS',
                    'selected' => $this->check('all-years'),
                    'disabled' => false
                ];

                $dataFirst = [
                    'key' => 'none-select',
                    'value' => $this->setUrl('none-select'),
                    'title' => 'Selecione um ano...',
                    'selected' => $this->check('none-select'),
                    'disabled' => false
                ];

                array_unshift($dataFilter, $dataFirst);

                return $this->htmlSelect($dataFilter);
            }
        }
    }

    public function statsFilter()
    {
        $stats = $this->target()->stats();
        $statsFilter = null;

        if (!isset($stats['global']['unique'])) {
            $statsFilter = $stats['period'];
        }
        else {
            foreach ($stats['period'] as $statsId => $years) {
                foreach ($years as $year => $yearData) {
                    $statsFilter[$year] = $yearData;
                }
            }
        }

        return $statsFilter;
    }

    public function listFilter()
    {
        $listFilter = null;

        $target = $this->target()->get();

        if ($target) {
            $stats = $this->target()->stats();

            if ($stats && $target == 'website') {
                if (isset($stats['period'])) {
                    foreach ($stats['period'] as $key => $value) {
                        $listFilter[$key]['title'] = 'Acessos Website';
                        $listFilter[$key]['label'] = '<b class="text-uppercase">'.$key.'</b>';
                        $listFilter[$key]['total'] = $this->formatTotal($value['total']);
                    }

                    if (is_array($listFilter)) {
                        krsort($listFilter);
                    }
                }

                return $listFilter;
            }
            else {
                if (isset($stats['period'])) {
                    foreach ($stats['period'] as $idStats => $years) {
                       foreach ($years as $year => $value) {
                            $listFilter[$idStats]['title'] = $this->getDatabase($idStats);
                            $listFilter[$idStats]['label'] = '<b class="text-uppercase">'.$year.'</b>';
                            $listFilter[$idStats]['total'] = $this->formatTotal($value['total']);
                        }
                    }

                    if (is_array($listFilter)) {
                        krsort($listFilter);
                    }
                }

                return $listFilter;
            }
        }
    }

    public function stats()
    {
        $stats = $this->target()->stats();
        $target = $this->get();

        foreach ($stats['period'] as $statsId => $years) {
            foreach ($years as $year => $yearData) {
                $statsYear[$year] = $yearData;
            }
        }

        if (isset($statsYear[$target])) {
            return $statsYear[$target];
        }

        return $statsYear;
    }
}
