<?php

include(__DIR__.'/class.masterFilter.php');
include(__DIR__.'/class.targetFilter.php');
include(__DIR__.'/class.yearFilter.php');
include(__DIR__.'/class.monthFilter.php');
include(__DIR__.'/class.dayFilter.php');

class ModuleDoop extends ModuleMaster
{
    public $reportActives = [
        'target' => null,
        'year' => null,
        'month' => null,
        'day' => null
    ];

    public $stats = null;

    public $targetFilter = null;
    public $yearFilter = null;
    public $monthFilter = null;
    public $dayFilter = null;

    public function __construct($controller, $operation = 'central', $key = null)
    {
        parent::__construct($controller, $operation, 'stats');

        $this->modules()->setPage('central', [
            'action' => 'central',
            'title' => 'Estatísticas',
            'label' => 'relatório',
            'path' => 'system/stats&operation=central',
            'privilege' => 'god'
        ]);

        $this->stats = $this->controller()->getBaseData('stats');

        $this->targetFilter = new TargetFilter($this);
        $this->yearFilter = new YearFilter($this);
        $this->monthFilter = new MonthFilter($this);
        $this->dayFilter = new DayFilter($this);
    }

    public function central()
    {
        $stats = $this->getStatsList();

        $page = $this->htmlFilterReport();

        $page .= '<hr class="mt-3 mb-3">';

        if (isset($stats['registers'])) {
            if (isset($stats['graphics'])) {
                $page .= '<canvas class="chartjs mb-4" id="chartStats" width="547" height="100"></canvas>';
            }

            $page .= '
            <div class="table-responsive">
                <table class="table table-striped table-bordered table-hover table-doop m-0">
                    <thead>
                        <tr>
                            <th>tipo de relatório</th>
                            <th width="1%" class="text-center text-nowrap">período</th>
                            <th width="1%" class="text-center text-nowrap">total</th>
                        </tr>
                    </thead>

                    <tbody>';
                        foreach ($stats['registers'] as $key => $value) {
                            $page .= '
                            <tr>
                                <td><p>'.$value['title'].'</p></td>
                                <td class="text-center"><h5>'.$value['label'].'</h5></td>
                                <td class="text-center"><h5><b>'.$value['total'].'</b></h5></td>
                            </tr>';
                        }

                    $page .= '
                    </tbody>

                    <tfoot>
                        <tr>
                            <td class="text-center"><h5>'.$stats['all-registers']['label'].'</h5></td>
                            <td colspan="2" class="text-center text-nowrap"><h5><b>'.$stats['all-registers']['total'].'</b></h5></td>
                        </tr>
                    </tfoot>
                </table>
            </div>';

            if (isset($stats['graphics'])) {
                $page .= '
                <script>
                    var grapichsLabels = ['.$stats['graphics']['labels'].']
                    var grapichsValues = ['.$stats['graphics']['values'].']
                    var grapichsTitle = "'.$stats['graphics']['title'].'"
                </script>';
            }
        }
        else {
            $page .= '<div class="alert alert-warning text-center mb-0">NENHUMA ESTATÍSTICA COMPUTADA</div>';
        }

        $vars['htmlHeader'] = '<h1>Estatísticas</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';

        $this->breadcrumb->setLabel($this->modules()->operation, 'Gerais');

        return ToolsTemplate::page($this->controller(), $page, $vars);
    }

    public function htmlFilterReport()
    {
        $dataReturn = '<div class="row">';

        if ($targetFilter = $this->targetFilter->generateFilter()) {
            $dataReturn .= $targetFilter;

            if ($this->targetFilter->get() && $yearFilter = $this->yearFilter->generateFilter()) {
                $dataReturn .= $yearFilter;

                if ($this->yearFilter->get() && $monthFilter = $this->monthFilter->generateFilter()) {
                    $dataReturn .= $monthFilter;

                    if ($this->monthFilter->get() && $this->monthFilter->get() != 'all-months' && $dayFilter = $this->dayFilter->generateFilter()) {
                        $dataReturn .= $dayFilter;
                    }
                }
            }
        }

        $dataReturn .= '</div>';

        return $dataReturn;
    }

    public function getStatsList($target = null, $year = null, $month = null, $day = null)
    {
        $dataReturn = null;

        if (isset($target)) {
            $this->targetFilter->set($target);
        }

        if (isset($year)) {
            $this->yearFilter->set($year);
        }

        if (isset($month)) {
            $this->monthFilter->set($month);
        }

        if (isset($day)) {
            $this->dayFilter->set($day);
        }

        $targetList = $this->targetFilter->listFilter();
        $yearList = $this->yearFilter->listFilter();
        $monthList = $this->monthFilter->listFilter();
        $dayList = $this->dayFilter->listFilter();

        $year = $this->yearFilter->get();
        $month = $this->monthFilter->get();
        $day = $this->dayFilter->get();

        if (Request::get('target')) {
            if ($year == 'all-years' && $month == 'all-months') {
                header('Location: '.Request::injectVars(null, [['year' => date('Y'), 'month' => date('m')]]));
                exit;
            }

        }
        switch ($year) {
            case 'all-years':
                $dataReturn['registers'] = $yearList;

                if (isset($targetList)) {
                    $dataReturn['all-registers'] = $targetList;
                }
            break;

            default:
                switch ($month) {
                    case 'all-months':
                        $dataReturn['registers'] = $monthList;

                        if (isset($targetList)) {
                            $dataReturn['all-registers'] = $targetList;
                        }
                    break;

                    default:
                        switch ($day) {
                            case 'all-days':
                                $dataReturn['registers'] = $dayList;

                                if (isset($targetList)) {
                                    $dataReturn['all-registers'] = $targetList;
                                }
                            break;

                            default:
                                $dataReturn['registers'][] = $dayList[$day];

                                if (isset($dayList[$day])) {
                                    $dataReturn['all-registers'] = $dayList[$day];
                                }
                            break;
                        }
                    break;
                }
            break;
        }

        $dataReturn = $this->prepareGraphics($dataReturn);

        return $dataReturn;
    }

    public function prepareGraphics($result)
    {
        if (isset($result['all-registers']['total'])) {
            $total = Treatment::string($result['all-registers']['total'], 'int');
        }

        if ($result && isset($total) && $total != 0) {

            foreach ($result['registers'] as $key => $value) {
                $totalParcial = ($value['total'] * 100) / $total;

                $graphics['table'][$key] = [
                    'label' => strip_tags($value['label']),
                    'total' => $value['total'],
                    'average' => number_format($totalParcial, 2, ',', '').'%'
                ];

                $graphics['labels'][$key] = '"'.strip_tags($value['label']).'"';
                $graphics['values'][$key] = str_replace('.', '', $value['total']);
            }

            $average = intval(max($graphics['values']));

            $graphics['labels'] = implode(', ', $graphics['labels']);
            $graphics['values'] = implode(', ', $graphics['values']).', 0, '.str_replace('.', '', $average);

            if (isset($result['all-registers']['title'])) {
                $graphics['title'] = $result['all-registers']['title'];
            }
            else {
                $graphics['title'] = 'Acessos Website';
            }

            $result['graphics'] = $graphics;
        }

        return $result;
    }
}
