<?php

class MasterFilter
{
    public $keyUrl = null;

    public $moduleInstance = null;

    public function __construct($moduleInstance)
    {
        $this->moduleInstance = $moduleInstance;

        $this->load();
    }

    public function controller()
    {
        return $this->moduleInstance->controller();
    }

    public function modules()
    {
        return $this->moduleInstance->modules();
    }

    public function target()
    {
        return $this->moduleInstance->targetFilter;
    }

    public function year()
    {
        return $this->moduleInstance->yearFilter;
    }

    public function month()
    {
        return $this->moduleInstance->monthFilter;
    }

    public function day()
    {
        return $this->moduleInstance->dayFilter;
    }

    public function load()
    {
        if (!$this->get()) {
            $this->set($this->getUrl());
        }
    }

    public function set($value)
    {
        $this->moduleInstance->reportActives[$this->keyUrl] = $value;
    }

    public function get()
    {
        if (isset($this->moduleInstance->reportActives[$this->keyUrl])) {
            return $this->moduleInstance->reportActives[$this->keyUrl];
        }
    }


    public function getTarget()
    {
        if (isset($this->moduleInstance->reportActives['target'])) {
            return $this->moduleInstance->reportActives['target'];
        }
    }
    public function has()
    {
        if (isset($this->moduleInstance->reportActives[$this->keyUrl])) {
            return true;
        }
    }

    public function check($key)
    {
        if ($this->has() && $this->get() == $key) {
            return true;
        }

        return false;
    }

    public function setUrl($key)
    {
        return $this->moduleInstance->controller()->pathPreservLink($this->moduleInstance->modules()->page['central']['path'], [[$this->keyUrl => $key]]);
    }

    public function getUrl()
    {
        return $this->moduleInstance->controller()->get($this->keyUrl);
    }

    public function hasUrl($key)
    {
        if ($keySelected = $this->getUrl()) {
            if ($keySelected == $key) {
                return true;
            }
        }

        return false;
    }

    public function statsDatabase()
    {
        return $this->moduleInstance->stats;
    }

    public function modulesSystem()
    {
        $modulesSystem = $this->moduleInstance->modules()->modulesSystem;

        $modulesSystem['website'] = [
            'title' => 'Acesso website',
            'order' => 1
        ];

        return $modulesSystem;
    }

    public function htmlSelect($dataLoad)
    {
        if ($dataLoad) {
            $dataReturn = '
                <div class="col col-md-3">
                    <select id="filter_'.$this->keyUrl.'" name="filter_'.$this->keyUrl.'" class="form-control filter-link select2">';
                    foreach ($dataLoad as $key => $value) {
                        $dataReturn .= '<option value="'.$value['value'].'"';

                        if ($value['disabled']) {
                            $dataReturn .= ' disabled';
                        }

                        if ($value['selected']) {
                            $dataReturn .= ' selected';
                        }

                        $dataReturn .= '>'.$value['title'].'</option>';
                    }

            $dataReturn .= '
                </select>
            </div>';

            return $dataReturn;
        }
    }

    public function formatTotal($total)
    {
        return number_format($total, 0, '', '.');
    }

    public function getDatabase($id)
    {
        $target = $this->getTarget();

        $result = $this->moduleInstance->controller()->getTupleModule($target, $id, 'title');

        if (!$result) {
            $result = $this->moduleInstance->controller()->getTupleModule($target, $id, 'name');
        }

        return $result;
    }
}
