<?php

class ModuleDoop extends ModuleMaster
{
   public function __construct($controller, $operation = 'manage', $key = null)
    {
		parent::__construct($controller, $operation, 'newsletter');

		$controller->modules->setPage('export', [
            'action' => 'export',
            'title' => 'Exportar',
            'label' => 'Exportar',
            'icon' => 'fa-paperclip',
            'path' => 'system/newsletter&operation=export',
            'privilege' => 'god'
        ]);

		$controller->modules->buttonExtra($controller->pathlang(null, config('app.PATH_SYSTEM').$controller->modules->page['export']['path']), $controller->modules->page['export']['title'], 'fa-paperclip');
	}

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('name')."`";

        $thead = '
        <th>nome</th>
        <th>e-mail</th>
        <th>telefone</th>
        <th width="1%" class="text-center">assinado</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td>'.$controller->processString($result[$controller->sufix('name')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('email')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('phone')]).'</td>';

            if ($result[$controller->sufix('checked')]) {
                $dataTbody .= '<td class="text-center"><i class="fa fa-check text-success"></i></td>';
            }
            else {
                $dataTbody .= '<td class="text-center"><i class="fa fa-times text-danger"></i></td>';
            }

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('name'), 'Nome', $controller->value('name'), ['input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->email($controller->sufix('email'), 'E-mail', $controller->value('email'));
        $page .= $forms->phone($controller->sufix('phone'), 'Telefone', $controller->value('phone'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('email') => $controller->post($controller->sufix('email'), 'email'),
            $controller->sufix('phone') => $controller->post($controller->sufix('phone')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('name'), 'Nome', $controller->value('name'), ['input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->email($controller->sufix('email'), 'E-mail', $controller->value('email'));
        $page .= $forms->phone($controller->sufix('phone'), 'Telefone', $controller->value('phone'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('email') => $controller->post($controller->sufix('email'), 'email'),
            $controller->sufix('phone') => $controller->post($controller->sufix('phone')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $controller->dataSave($data, 'update');

        return true;
    }

    public function export()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $pathUpload = config('app.ROOT_UPLOAD').'/newsletter';

        if (!is_dir($pathUpload)) {
            mkdir($pathUpload, '0777');
        }

        $filePath = config('app.ROOT_UPLOAD').'/newsletter/backup-list-'.date('Y-m-d').'.csv';
        $fileDownload = config('app.PATH_UPLOAD').'/newsletter/backup-list-'.date('Y-m-d').'.csv';
        $data = null;
        $query = "SELECT * FROM `".$controller->getTable()."`
                  WHERE `".$controller->sufix('status')."` = 'active'
                  GROUP BY `".$controller->sufix('id')."`
                  ORDER BY `".$controller->sufix('name')."`";
        $data .= '"Nome Completo", E-mail, Telefone Comercial'."\r\n";
        $contacts = $controller->dbFetchAll($query);

        foreach ($contacts as $key => $result) {
            $data .= '"'.$result[$controller->sufix('name')].'", '.$controller->processString($result[$controller->sufix('email')].', '.$controller->processString($result[$controller->sufix('phone')]));
            $data .= "\r\n";
        }

        if ($contacts) {
            if (fwrite($file = fopen($filePath,'w+'), $data)) {
                fclose($file);

                $page = '
                <div class="alert alert-success">
                    <i class="fa fa-check-circle mr-2"></i>Arquivo .CSV criado com sucesso!
                </div>';

                $page .= '
                <button class="btn btn-primary" data-link="'.$fileDownload.'" title="Download do arquivo .CSV">
                    <i class="fa fa-download mr-2"></i> Download do arquivo .CSV
                </button>';
            }
            else {
                $page = '
                <div class="alert alert-danger m-0">
                    <i class="fas fa-exclamation-circle mr-2"></i>Ocorreu um erro na criação do arquivo .CSV. Tente novamente!
                </div>';
            }
        }
        else {
            $page = '
            <div class="alert alert-info m-0">
                <i class="fas fa-exclamation-circle mr-2"></i>Nenhum nome e e-mail encontrado!
            </div>';
        }

        return ToolsTemplate::page($controller, $page);
    }
}
