<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
		parent::__construct($controller, $operation, 'menu-type');
	}

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('title')."`";

        $thead = '
            <th>tipo</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td>'.$controller->processString($result[$controller->sufix('title')]).'</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }


	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		$controller->dataSave($data, 'update');

		return true;
	}
}
