<?php

class ModuleDoop extends ModuleMaster
{
    public $form_visibles = [
        1 => 'Texto',
        2 => 'Texto e Imagem',
    ];

    public $form_internals = [
        1 => 'URL Interna Livre',
        2 => 'URL Completa',
        3 => 'URL Interna Páginas'
    ];

    public $form_targets = [
        '_blank' => 'Nova Janela',
        '_parent' => 'Mesma Janela'
    ];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        $this->extension = 'png';

        $this->imgx = 150;
        $this->imgy = 150;

        parent::__construct($controller, $operation, 'menu-submenu');
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 INNER JOIN `mod_menu` ON (`id_menu` = `".$controller->sufix('primary')."` AND `status_menu` = 'active')
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `label_menu`, `".$controller->sufix('order')."`";

        $thead = '
            <th width="1%" class="text-center">tipo</th>
            <th width="1%" class="text-center">key</th>
            <th>label</th>
            <th width="1%" class="text-center">url</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-nowrap text-center">'.$controller->processString($result['label_menu']).'</td>';
            $dataTbody .= '<td class="text-nowrap text-center">'.$controller->processString($result[$controller->sufix('key')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('label')]).'</td>';
            $dataTbody .= '<td class="text-nowrap text-center">';

            if ($result[$controller->sufix('internal')] == 1) {
                if ($result[$controller->sufix('url')] && $result[$controller->sufix('url')] != '#') {
                    $link = config('app.BASE_PATH').'/'.$controller->processString($result[$controller->sufix('url')]);

                    $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
                }
                else {
                    $dataTbody .= '<b class="text-danger"># SEM AÇÃO</b>';
                }
            }
            else if ($result[$controller->sufix('internal')] == 2) {
                $link = $controller->processString($result[$controller->sufix('url')]);

                $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
            }
            else if ($result[$controller->sufix('internal')] == 3) {
                $link = config('app.BASE_PATH').'/'.$controller->getTupleModule('page', $result[$controller->sufix('url')], 'slug');
                $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
            }

            $dataTbody .= '</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('primary'), 'Menu Primário', $modules->inputSelectHtml('menu', 'label', $controller->value('primary'), null, null, null, null, false, 'mod', 'order'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('key'), 'Chave de acesso', $controller->value('key'), ['maxlength' => 50]);
        $page .= $forms->input($controller->sufix('label'), 'Título', $controller->value('label'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('visible'), 'Visualização', 1, $this->form_visibles);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('internal'), 'Tipo de URL', 1, $this->form_internals);
        $page .= $forms->input($controller->sufix('url'), 'URL Interna Livre', $controller->value('url'), ['required' => false, 'cont_input' => false, 'input_group_label' => config('app.BASE_PATH').'/']);
        $page .= $forms->input($controller->sufix('urlfull'), 'URL Completa', $controller->value('urlfull'), ['required' => false, 'form_group' => 'd-none', 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->select($controller->sufix('urlpage'), 'Url Interna Páginas', $modules->inputSelectHtml('page', 'title'), ['required' => false, 'form_group' => 'd-none', 'input_col' => 'col col-md-5']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_parent', $this->form_targets);

        $page .= '<div id="visible-image" class="d-none">';
        $page .= $forms->separate();
        $page .= $forms->upload($controller->sufix('image'), 'Imagem', null, ['required' => false, 'extension' => $this->extension, 'imgx' => $this->imgx, 'imgy' => $this->imgy]);
        $page .= '</div>';
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('primary') => $controller->post($controller->sufix('primary')),
            $controller->sufix('key') => $controller->post($controller->sufix('key')),
            $controller->sufix('internal') => $controller->post($controller->sufix('internal'), 'int'),
            $controller->sufix('visible') => $controller->post($controller->sufix('visible'), 'int'),
            $controller->sufix('label') => $controller->post($controller->sufix('label')),
            $controller->sufix('url') => $controller->post($controller->sufix('url')),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->generatorOrder("AND `".$controller->sufix('primary')."` = '".$controller->post($controller->sufix('primary'))."'"),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        switch($data[$controller->sufix('internal')])
        {
            case 1:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('url'));
            break;

            case 2:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlfull'));
            break;

            case 3:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlpage'), 'int');
            break;
        }

        $image = new \CoreSlim\Upload();
        $image->config($controller->sufix('image'), $modules->key, $controller->linkSystem());
        $image->exact([$this->imgx, $this->imgy]);
        $image->load();

        if ($output = $image->output('json')) {
            $data[$controller->sufix('image')] = $output;
        }

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        if ($controller->value('internal') == 1) {
            $url['url'] = $controller->value('url');
            $url['urlfull'] = null;
            $url['urlpage'] = null;

            $form_group['url'] = null;
            $form_group['urlfull'] = 'd-none';
            $form_group['urlpage'] = 'd-none';
        }
        else if ($controller->value('internal') == 2) {
            $url['url'] = null;
            $url['urlfull'] = $controller->value('url');
            $url['urlpage'] = null;

            $form_group['url'] = 'd-none';
            $form_group['urlfull'] = null;
            $form_group['urlpage'] = 'd-none';
        }
        else if ($controller->value('internal') == 3) {
            $url['url'] = null;
            $url['urlfull'] = null;
            $url['urlpage'] = $controller->value('url');

            $form_group['url'] = 'd-none';
            $form_group['urlfull'] = 'd-none';
            $form_group['urlpage'] = null;
        }

        $page = $forms->select($controller->sufix('primary'), 'Menu Primário', $modules->inputSelectHtml('menu', 'label', $controller->value('primary'), null, null, null, null, false, 'mod', 'order'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('key'), 'Chave de acesso', $controller->value('key'), ['maxlength' => 50]);
        $page .= $forms->input($controller->sufix('label'), 'Título', $controller->value('label'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('visible'), 'Visualização', $controller->value('visible'), $this->form_visibles);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('internal'), 'Tipo de URL', $controller->value('internal'), $this->form_internals);
        $page .= $forms->input($controller->sufix('url'), 'URL Interna Livre', $url['url'], ['required' => false, 'form_group' => $form_group['url'], 'cont_input' => false, 'input_group_label' => config('app.BASE_PATH').'/']);
        $page .= $forms->input($controller->sufix('urlfull'), 'URL Completa', $url['urlfull'], ['required' => false, 'form_group' => $form_group['urlfull'], 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->select($controller->sufix('urlpage'), 'Url Interna Páginas', $modules->inputSelectHtml('page', 'title',  $url['urlpage']), ['required' => false, 'form_group' => $form_group['urlpage'], 'input_col' => 'col col-md-5']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_parent', $this->form_targets);

        $visibleImage = '';

        if ($controller->value('visible') == 1) {
            $visibleImage = 'd-none';
        }

        $page .= '<div id="visible-image" class="'.$visibleImage.'">';
        $page .= $forms->separate();
        $page .= $forms->upload($controller->sufix('image'), 'Imagem', $modules->getPhotoPage($controller->value('image'), 'image'), ['required' => false, 'extension' => $this->extension, 'imgx' => $this->imgx, 'imgy' => $this->imgy]);
        $page .= '</div>';

        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('primary') => $controller->post($controller->sufix('primary')),
            $controller->sufix('key') => $controller->post($controller->sufix('key')),
            $controller->sufix('internal') => $controller->post($controller->sufix('internal'), 'int'),
            $controller->sufix('visible') => $controller->post($controller->sufix('visible'), 'int'),
            $controller->sufix('label') => $controller->post($controller->sufix('label')),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->post($controller->sufix('order'), 'int'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        switch($data[$controller->sufix('internal')])
        {
            case 1:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('url'));
            break;

            case 2:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlfull'));
            break;

            case 3:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlpage'), 'int');
            break;
        }

        if ($data[$controller->sufix('key')] != $controller->value('key')) {
            if ($controller->dataDuplicated(['key', 'type'], [$data[$controller->sufix('key')], $data[$controller->sufix('type')]]) == true) {
                header('Location: '.$controller->linkSystem().'&callback=701');
                exit;
            }
        }

        $image = new \CoreSlim\Upload();
        $image->config($controller->sufix('image'), $modules->key, $controller->linkSystem());
        $image->exact([$this->imgx, $this->imgy]);
        $image->load();

        if ($output = $image->output('json')) {
            $data[$controller->sufix('image')] = $output;
        }

		$controller->dataSave($data, 'update');

		return true;
	}
}
