<?php

class ModuleDoop extends ModuleMaster
{
	public $maintenance = null;

    public $form_boolean = [
        1 => 'Sim',
        2 => 'Não'
    ];

	public function __construct($controller, $operation = 'manage', $key = null)
	{
		parent::__construct($controller, $operation, 'init');

        $this->modules()->setPage('init', [
            'action' => 'init',
            'title' => 'Manutenção',
            'label' => 'Salvar',
            'path' => config('app.PATH_SYSTEM').'system/maintenance&operation=init',
            'icon' => 'fas fa-hourglass-half',
            'privilege' => 'god'
        ]);

		$this->maintenance = $controller->getBaseData('maintenance');

		if ($this->post('init_action_form')) {
			$this->module_maintenance();
		}
	}

    public function init()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $modules->tabsActive['registry'] = false;
        $modules->tabsActive['developer'] = false;

        $page = $forms->radio('status_maintenance', 'Site Online', $this->maintenance['status'], $this->form_boolean);
        $page .= $forms->separate();
        $page .= $forms->textarea('message_maintenance', 'Mensagem', $this->maintenance['message'], ['required' => false, 'class' => 'summernote-mini']);

        $vars['htmlHeader'] = '<h1>Manutenção</h1>';

        return ToolsTemplate::insert($controller, $page, $vars);
    }

	public function module_maintenance()
	{
        $controller = $this->controller();

		$data = [
            'status' => $controller->post('status_maintenance', 'boolean'),
			'message' => $controller->post('message_maintenance', 'text')
        ];

        $controller->setBaseData('maintenance', $data);

		header('Location: '.config('app.PATH_SYSTEM').'system/maintenance&operation=init&callback=301');
		exit;
	}
}
