<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'ibge-state');
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $filter_country = null;

        if ($controller->get('filter_country')) {
            $filter_country = "AND `id_ibge-country` = '".$controller->get('filter_country')."'";
        }

        $query = "SELECT * FROM `".$controller->getTable()."`
                  INNER JOIN `sis_ibge-country` ON (`id_ibge-country` = `".$controller->sufix('country')."` AND `status_ibge-country` = 'active' ".$filter_country.")
                  ".$modules->queryFilter."
                  WHERE ".$modules->queryStatus." ".$modules->querySearch."
                  GROUP BY `".$controller->sufix('id')."`
                  ORDER BY `name_ibge-country`, `".$controller->sufix('name')."`";

        $thead = '
            <th width="10%">país</th>
            <th width="20%">estado</th>
            <th>sigla</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-nowrap">'.\Treatment::string($result['name_ibge-country']).'</td>';
            $dataTbody .= '<td class="text-nowrap">'.\Treatment::string($result[$controller->sufix('name')]).'</td>';
            $dataTbody .= '<td>'.\Treatment::string($result[$controller->sufix('iso')]).'</td>';

            return $dataTbody;
        };

        $page['htmlControlInjection'] = $this->htmlFilterExtra();

        return ToolsTemplate::manage($controller, $query, $thead, $tbody, $page);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('country'), 'País', $controller->modules->inputSelectHtml('ibge-country', 'name', 76));
        $page .= $forms->input($controller->sufix('name'), 'Estado', $controller->value('name'));
        $page .= $forms->input($controller->sufix('iso'), 'Sigla', $controller->value('iso'), ['maxlength' => 2]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('country') => $controller->post($controller->sufix('country'), 'int'),
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('name'))),
            $controller->sufix('iso') => $controller->post($controller->sufix('iso')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		if ($controller->dataDuplicated(['name', 'country'], [$data[$controller->sufix('name')], $data[$controller->sufix('country')]]) === true) {
			header('Location: '.$controller->linkSystem().'&callback=401');
			exit;
		}

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('country'), 'País', $controller->modules->inputSelectHtml('ibge-country', 'name', $controller->value('country')));
        $page .= $forms->input($controller->sufix('name'), 'Estado', $controller->value('name'));
        $page .= $forms->input($controller->sufix('iso'), 'Sigla', $controller->value('iso'), ['maxlength' => 2]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('country') => $controller->post($controller->sufix('country'), 'int'),
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('name'))),
            $controller->sufix('iso') => $controller->post($controller->sufix('iso')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		if ($data[$controller->sufix('name')] != $controller->value('name')) {
			if ($controller->dataDuplicated(['name', 'country'], [$data[$controller->sufix('name')], $data[$controller->sufix('country')]]) === true) {
				header('Location: '.$controller->linkSystem().'&callback=401');
				exit;
			}
		}

		$controller->dataSave($data, 'update');

		return true;
	}

	public function htmlFilterExtra()
    {
        $controller = $this->controller();
        $modules = $this->modules();

		$dataReturn = null;

        $querySql = "SELECT `id_ibge-country`, `name_ibge-country` FROM `sis_ibge-country`
                     INNER JOIN `sis_ibge-state` ON (`country_ibge-state` = `id_ibge-country` AND `status_ibge-state` = 'active')
                     WHERE `status_ibge-country` = 'active' GROUP BY `id_ibge-country` ORDER BY `name_ibge-country`";

        if ($query = $controller->dbFetchAll($querySql)) {
            $dataReturn .= '
            <div class="btn-group-select2">
                <select id="filter_country" name="filter_country" class="form-control select2 filter-link">
                    <option value="'.\Request::injectVars(null, [['filter_country' => 'empty']], ['pagina']).'">Filtro: Países</option>';
                foreach ($query as $key => $result) {
                    $dataReturn .= '<option value="'.\Request::injectVars(null, [['filter_country' => intval($result['id_ibge-country'])]], ['pagina']).'"';

                    if (\Request::get('filter_country') == $result['id_ibge-country']) {
                        $dataReturn .= ' selected';
                    }

                    $dataReturn .= '>'.\Treatment::string($result['name_ibge-country']).'</option>';
                }

            $dataReturn .= '
                </select>
            </div>';
        }

		return $dataReturn;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\IbgeStateSeeder::seed();
    }
}
