<?php

class ModuleDoop extends ModuleMaster
{
	public function __construct($controller, $operation = 'manage', $key = null)
	{
		parent::__construct($controller, $operation, 'ibge-district');
	}

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $filter_country = null;

        if (\Request::get('filter_country')) {
            $filter_country = "AND `id_ibge-country` = '".Request::get('filter_country')."'";
        }

        $filter_state = null;

        if (\Request::get('filter_state')) {
            $filter_state = "AND `id_ibge-state` = '".Request::get('filter_state')."'";
        }

        $filter_city = null;

        if (\Request::get('filter_city')) {
            $filter_city = "AND `id_ibge-city` = '".Request::get('filter_city')."'";
        }

        $query = "SELECT * FROM `".$controller->getTable()."`
                  INNER JOIN `sis_ibge-country` ON (`id_ibge-country` = `".$controller->sufix('country')."` AND `status_ibge-country` = 'active' ".$filter_country.")
                  INNER JOIN `sis_ibge-state` ON (`id_ibge-state` = `".$controller->sufix('state')."` AND `status_ibge-state` = 'active' ".$filter_state.")
                  INNER JOIN `sis_ibge-city` ON (`id_ibge-city` = `".$controller->sufix('city')."` AND `status_ibge-city` = 'active' ".$filter_city.")
                  WHERE ".$modules->queryStatus." ".$modules->querySearch."
                  GROUP BY `".$controller->sufix('id')."`
                  ORDER BY `name_ibge-country`, `name_ibge-state`, `name_ibge-city`, `".$controller->sufix('name')."`";

        $thead = '
            <th width="10%">país</th>
            <th width="10%">estado</th>
            <th width="10%">cidade</th>
            <th>bairro</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-nowrap">'.\Treatment::string($result['name_ibge-country']).'</td>';
            $dataTbody .= '<td class="text-nowrap">'.\Treatment::string($result['name_ibge-state']).'</td>';
            $dataTbody .= '<td class="text-nowrap">'.\Treatment::string($result['name_ibge-city']).'</td>';
            $dataTbody .= '<td>'.\Treatment::string($result[$controller->sufix('name')]).'</td>';

            return $dataTbody;
        };

        $page['htmlControlInjection'] = $this->htmlFilterExtra();

        return ToolsTemplate::manage($controller, $query, $thead, $tbody, $page);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('country'), 'País', $controller->modules->inputSelectHtml('ibge-country', 'name', 76), ['primary_item' => 'Selecione um país...']);
        $page .= $forms->select($controller->sufix('state'), 'Estado', $controller->modules->inputSelectHtml('ibge-state', 'name', 11, null, null, " AND `country_ibge-state` = '76'"), ['primary_item' => 'Selecione um estado...']);
        $page .= $forms->select($controller->sufix('city'), 'Cidade', $controller->modules->inputSelectHtml('ibge-city', 'name', null, null, null, " AND `state_ibge-city` = '11'"), ['primary_item' => 'Selecione uma cidade...']);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('name'), 'Bairro', $controller->value('name'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('country') => $controller->post($controller->sufix('country'), 'int'),
            $controller->sufix('state') => $controller->post($controller->sufix('state'), 'int'),
            $controller->sufix('city') => $controller->post($controller->sufix('city'), 'int'),
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('name'))),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		if ($controller->dataDuplicated(['name', 'city', 'state'], [$data[$controller->sufix('name')], $data[$controller->sufix('city')], $data[$controller->sufix('state')]]) === true) {
			header('Location: '.$controller->linkSystem().'&callback=401');
			exit;
		}

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->select($controller->sufix('country'), 'País', $controller->modules->inputSelectHtml('ibge-country', 'name', $controller->value('country')));
        $page .= $forms->select($controller->sufix('state'), 'Estado', $controller->modules->inputSelectHtml('ibge-state', 'name', $controller->value('state'), null, null, " AND `country_ibge-state` = '".$controller->value('country')."'"));
        $page .= $forms->select($controller->sufix('city'), 'Cidade', $controller->modules->inputSelectHtml('ibge-city', 'name', $controller->value('city'), null, null, " AND `state_ibge-city` = '".$controller->value('state')."'"));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('name'), 'Bairro', $controller->value('name'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('country') => $controller->post($controller->sufix('country'), 'int'),
            $controller->sufix('state') => $controller->post($controller->sufix('state'), 'int'),
            $controller->sufix('city') => $controller->post($controller->sufix('city'), 'int'),
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('name'))),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		if ($data[$controller->sufix('name')] != $controller->value('name')) {
			if ($controller->dataDuplicated(['name', 'state', 'city'], [$data[$controller->sufix('name')], $data[$controller->sufix('state')], $data[$controller->sufix('city')]]) === true) {
				header('Location: '.$controller->linkSystem().'&callback=401');
				exit;
			}
		}

		$controller->dataSave($data, 'update');

		return true;
	}

	public function htmlFilterExtra()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$dataReturn = null;

        $querySql = "SELECT `id_ibge-country`, `name_ibge-country` FROM `sis_ibge-country`
                     INNER JOIN `sis_ibge-state` ON (`country_ibge-state` = `id_ibge-country` AND `status_ibge-state` = 'active')
                     WHERE `status_ibge-country` = 'active' GROUP BY `id_ibge-country` ORDER BY `name_ibge-country`";

        if ($query = $controller->dbFetchAll($querySql)) {
            $dataReturn .= '
            <div class="btn-group-select2">
                <select id="filter_country" name="filter_country" class="form-control select2 filter-link">
                    <option value="'.\Request::injectVars(null, [['filter_country' => 'empty']], ['pagina', 'filter_state']).'">Filtro: Países</option>';
                foreach ($query as $key => $result) {
                    $dataReturn .= '<option value="'.\Request::injectVars(null, [['filter_country' => intval($result['id_ibge-country'])]], ['pagina', 'filter_state', 'filter_city']).'"';

                    if (\Request::get('filter_country') == $result['id_ibge-country']) {
                        $dataReturn .= ' selected';
                    }

                    $dataReturn .= '>'.\Treatment::string($result['name_ibge-country']).'</option>';
                }

            $dataReturn .= '
                </select>
            </div>';
        }

        $querySql = "SELECT `name_ibge-state`, `id_ibge-state`  FROM `sis_ibge-state`
                     INNER JOIN `sis_ibge-city` ON (`state_ibge-city` = `id_ibge-state` AND `status_ibge-city` = 'active')
                     WHERE `status_ibge-state` = 'active' GROUP BY `id_ibge-state` ORDER BY `name_ibge-state`";

        if ($query = $controller->dbFetchAll($querySql)) {
            $dataReturn .= '
            <div class="btn-group-select2">
                <select id="filter_state" name="filter_state" class="form-control select2 filter-link">
                    <option value="'.\Request::injectVars(null, [['filter_state' => 'empty']], ['pagina', 'filter_city']).'">Filtro: Estados</option>';
                foreach ($query as $key => $result) {
                    $dataReturn .= '<option value="'.\Request::injectVars(null, [['filter_state' => intval($result['id_ibge-state'])]], ['pagina', 'filter_city']).'"';
                    if (\Request::get('filter_state') == $result['id_ibge-state']) {
                        $dataReturn .= ' selected';
                    }
                    $dataReturn .= '>'.\Treatment::string($result['name_ibge-state']).'</option>';
                }

            $dataReturn .= '
                </select>
            </div>';
        }

        $querySql = "SELECT `name_ibge-city`, `id_ibge-city`  FROM `sis_ibge-city`
                     INNER JOIN `sis_ibge-district` ON (`city_ibge-district` = `id_ibge-city` AND `status_ibge-district` = 'active')
                     WHERE `status_ibge-city` = 'active' GROUP BY `id_ibge-city` ORDER BY `name_ibge-city`";

        if ($query = $controller->dbFetchAll($querySql)) {
            $dataReturn .= '
            <div class="btn-group-select2">
                <select id="filter_city" name="filter_city" class="form-control select2 filter-link">
                    <option value="'.\Request::injectVars(null, [['filter_city' => 'empty']], ['pagina']).'">Filtro: Cidades</option>';
                foreach ($query as $key => $result) {
                    $dataReturn .= '<option value="'.\Request::injectVars(null, [['filter_city' => intval($result['id_ibge-city'])]], ['pagina']).'"';
                    if (\Request::get('filter_city') == $result['id_ibge-city']) {
                        $dataReturn .= ' selected';
                    }
                    $dataReturn .= '>'.\Treatment::string($result['name_ibge-city']).'</option>';
                }

            $dataReturn .= '
                </select>
            </div>';
        }

		return $dataReturn;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\IbgeCitySeeder::seed();
    }
}
