<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'ibge-country');
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('name')."`";

        $thead = '
            <th>país</th>
            <th>sigla</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td>'.$controller->processString($result[$controller->sufix('name')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('iso')]).'</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('name'), 'País', $controller->value('name'));
        $page .= $forms->input($controller->sufix('iso'), 'Sigla', $controller->value('iso'), ['maxlength' => 3]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('name'))),
            $controller->sufix('iso') => $controller->post($controller->sufix('iso')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		if ($controller->dataDuplicated(['name'], [$data[$controller->sufix('name')]]) === true) {
			header('Location: '.$controller->linkSystem().'&callback=401');
			exit;
		}

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('name'), 'País', $controller->value('name'));
        $page .= $forms->input($controller->sufix('iso'), 'Sigla', $controller->value('iso'), ['maxlength' => 3]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('name') => $controller->post($controller->sufix('name')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('name'))),
            $controller->sufix('iso') => $controller->post($controller->sufix('iso')),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

		if ($data[$controller->sufix('name')] != $controller->value('name')) {
			if ($controller->dataDuplicated(['name'], [$data[$controller->sufix('name')]]) === true) {
				header('Location: '.$controller->linkSystem().'&callback=401');
				exit;
			}
		}

		$controller->dataSave($data, 'update');

		return true;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\IbgeCountrySeeder::seed();
    }
}
