<?php
require_once(config('app.ROOT_CMS_CORE').'/class.submodule.php');

$params['table'] = $module->getTable();
$params['tuple'] = $module->value('id');
$params['folder'] =  $module->modules->key;

$photo = new SubmoduleDoop('photo', $module->linkSystem(), $params);

if ($photo->post('insert_action_form_photo')) { $photo->sub_insert(); }
if ($photo->post('update_action_form_photo')) { $photo->sub_update(); }

$dataTabPhoto = $photo->modules->htmlHeader();

if(!$photo->get($photo->active)) {
    $dataTabPhoto .= '
    <form name="insert_photo_form" class="form-horizontal form-validate-photo" method="post" action="'.$photo->newPath.'" enctype="multipart/form-data">
        <div class="row form-group">
            <label class="col-md-3 col-form-label" for="'.$photo->modules->sufix('file').'">Imagens: <sup class="text-danger" title="Obrigatório">(*)</sup></label>
            <div class="col-md-9">
                <div class="custom-file">
                    <input type="file" id="'.$photo->modules->sufix('file').'" name="'.$photo->modules->sufix('file').'[]" class="custom-file-input" multiple="multiple" required>
                    <label class="custom-file-label" for="'.$photo->modules->sufix('file').'" data-browse="SELECIONAR">Nenhum arquivo selecionado</label>
                </div>
                <small>[ jpg - png - gif ][ Máximo: 80MB ]</small>
            </div>
        </div>
        <hr>
        <div class="text-center">
            <button id="insert_action_form_photo" name="insert_action_form_photo" class="btn btn-primary" type="submit" value="inserir imagens">
                <i class="fa fa-fw fa-plus"></i>&nbsp;inserir imagens
            </button>
        </div>
    </form>';
}

$limit = 20;
$query = "SELECT * FROM `".$photo->getTable()."`
          WHERE `".$photo->modules->sufix('table')."` = '".$module->getTable()."' AND `".$photo->modules->sufix('tuple')."` = '".$module->value('id')."' AND `".$photo->modules->sufix('status')."` = 'active'
          GROUP BY `".$photo->modules->sufix('id')."`
          ORDER BY `".$photo->modules->sufix('order')."` DESC";

$paginationConfig = lang('site::default.pagination');
$paginationConfig[1] = 'paginaExtraPhoto';
$paginationConfig[7] = 'paginaExtraPhoto-1';

$pagination = new \CoreSlim\PaginationGet([
    'locale' => $paginationConfig,
    'item' => $limit,
    'query' => $query
]);

$queryData = $pagination->execute();

$paginationData = $photo->dbFetchAll($queryData);

if (is_array($paginationData) && count($paginationData) > 0) {
    $dataTabPhoto .= '
    <hr>
    <form name="update_photo_form" class="form-horizontal form-validate-photo-update" method="post" action="'.$photo->newPath.'" enctype="multipart/form-data">
        <div class="form-submodule-top mb-3">
            '.ToolsTemplate::navigation($pagination->total, $pagination->navigation(null, null, '#photo')).'

            <div class="btn-group">
                <a href="'.$photo->newPath.'&action=deleteAllItens&photo=module#photo" id="deleteAll_photo" name="deleteAll_photo" class="btn btn-danger alert-action-default" value="Excluir tudo">
                    <i class="fa fa-times mr-2"></i> excluir tudo
                </a>

                <button id="updateAll_photo" name="updateAll_photo" class="btn btn-success" type="submit" value="Salvar Dados">
                    <i class="fa fa-save mr-2"></i> salvar dados
                </button>
            </div>
        </div>

        <div class="table-responsive">
            <table class="table table-striped table-bordered table-hover table-doop">
                <thead>
                    <tr>
                        <th width="1%" class="text-center">imagem</th>
                        <th>legenda</th>
                        <th>crédito</th>
                        <th width="10%" class="text-center">ordem</th>
                        <th width="1%" class="text-center">download</th>
                        <th width="1%" class="text-center"><i class="fa fa-cubes cursor-default" title="Controles"></i></th>
                    </tr>
                </thead>
                <tbody>';
                    foreach ($paginationData as $key => $result) {
                        $id = $result[$photo->modules->sufix('id')];

                        $file = $result[$photo->modules->sufix('file')];

                        if (@json_decode($file)) {
                            $dataPhoto = json_decode($file, true);
                        }

                        $dataTabPhoto .= '
                        <tr>
                            <td class="text-center">'.$photo->getPhotoSub($result[$photo->modules->sufix('file')], $result[$photo->modules->sufix('legend')], $result[$photo->modules->sufix('credit')]).'</td>
                            <td><input type="text" id="legend_photo_'.$id.'" name="legend_photo_'.$id.'" class="form-control" maxlength="100" value="'.$photo->processString($result[$photo->modules->sufix('legend')]).'" placeholder="Digite a legenda da foto..." /></td>
                            <td><input type="text" id="credit_photo_'.$id.'" name="credit_photo_'.$id.'" class="form-control" maxlength="100" value="'.$photo->processString($result[$photo->modules->sufix('credit')]).'" placeholder="Digite o crédito da foto..." /></td>
                            <td class="text-center"><input type="number" id="order_photo_'.$id.'" name="order_photo_'.$id.'" class="form-control text-center" maxlength="100" value="'.$photo->processString($result[$photo->modules->sufix('order')]).'" /></td>
                            <td class="text-center">'.$photo->getDownloadNumber($result[$photo->modules->sufix('download')]).'</td>
                            <td class="text-center">
                                <div class="btn-group">
                                    '.$photo->modules->htmlActionUnique($result, $photo->active, true).'
                                    '.$photo->getPhotoSubDownload($result).'
                                </div>
                            </td>
                        </tr>';
                    }
                $dataTabPhoto .= '
                </tbody>
            </table>
        </div>
    </form>';
}

return $dataTabPhoto;
