CREATE TABLE `mod_administrator` (
  `id_administrator` int NOT NULL,
  `uuid_administrator` binary(36) NOT NULL,
  `name_administrator` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_administrator` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `password_administrator` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `signature_administrator` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `token_administrator` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `params_administrator` json DEFAULT NULL,
  `user_administrator` int DEFAULT '1',
  `time_administrator` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_administrator` timestamp NULL DEFAULT NULL ON UPDATE CURRENT_TIMESTAMP,
  `status_administrator` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT 'disabled'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `mod_administrator-nivel` (
  `id_nivel` int NOT NULL,
  `administrator_nivel` int NOT NULL,
  `module_nivel` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `privilege_nivel` tinyint(1) NOT NULL DEFAULT '2',
  `only_nivel` tinyint(1) NOT NULL DEFAULT '2'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `mod_administrator-privilege` (
  `administrator_privilege` int NOT NULL,
  `group_privilege` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `master_privilege` tinyint(1) NOT NULL DEFAULT '2',
  `god_privilege` tinyint(1) NOT NULL DEFAULT '2',
  `root_privilege` tinyint(1) NOT NULL DEFAULT '2',
  `developer_privilege` tinyint(1) NOT NULL DEFAULT '2'
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

ALTER TABLE `mod_administrator`
  ADD PRIMARY KEY (`id_administrator`),
  ADD UNIQUE KEY `uuid_administrator` (`uuid_administrator`),
  ADD UNIQUE KEY `email_administrator` (`email_administrator`),
  ADD KEY `user_administrator` (`user_administrator`);

ALTER TABLE `mod_administrator-nivel`
  ADD PRIMARY KEY (`id_nivel`);

ALTER TABLE `mod_administrator-privilege`
  ADD PRIMARY KEY (`administrator_privilege`),
  ADD KEY `administrator_privilege` (`administrator_privilege`);

ALTER TABLE `mod_administrator`
  MODIFY `id_administrator` int NOT NULL AUTO_INCREMENT;

ALTER TABLE `mod_administrator-nivel`
  MODIFY `id_nivel` int NOT NULL AUTO_INCREMENT;
COMMIT;
