<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'developer');

        $modules = $this->modules();

        $modules->setPage('toolbox', [
            'action' => 'toolbox',
            'title' => 'DEVELOPER',
            'label' => 'DEVELOPER',
            'icon' => 'far fa-id-card',
            'path' => 'system/developer&operation=toolbox',
            'privilege' => 'developer'
        ]);

        if ($controller->get('action') == 'deleteGhostAllFilesDatabase') {
            $this->deleteGhostAllFilesDatabase();
        }

        if ($controller->get('action') == 'resetStatsTable') {
            $this->resetStatsTable();
        }

        if ($controller->get('action') == 'convertImagesToWebp') {
            $this->convertImagesToWebp();
        }

        if ($controller->get('action') == 'restoreWebpToImages') {
            $this->restoreWebpToImages();
        }

        if ($controller->get('action') == 'deleteImagesWebp') {
            $this->deleteImagesWebp();
        }

        if ($controller->get('action') == 'deleteFolderTemp') {
            $this->deleteFolderTemp();
        }

        if ($controller->get('action') == 'resetTableSystem') {
            $this->resetTableSystem();
        }

        if ($controller->get('action') == 'importData') {
            $this->importData();
        }
    }

    public function toolbox()
    {
        $controller = $this->controller();

        $page = '
            <div class="alert alert-light">
                Funções aplicadas em todo o banco de dados
            </div>

            <div class="row">
                <div class="col col-md-4">
                    <a href="'.$controller->link('developer', 'toolbox').'&action=resetStatsTable" class="alert-action-default btn btn-block btn-danger">
                        <i class="fa fa-fw fa-times"></i>&nbsp;Resetar visualizações
                    </a>
                </div>
            </div>

            <br>

            <div class="alert alert-light">
                Funções aplicadas em todos os módulos do sistema - IMAGENS E ARQUIVOS
            </div>

            <div class="row">
                <div class="col col-md-4">
                    <a href="'.$controller->link('developer', 'toolbox').'&action=deleteGhostAllFilesDatabase" class="alert-action-default btn btn-block btn-danger">
                        <i class="fa fa-fw fa-times"></i>&nbsp;Excluir arquivos fantasmas
                    </a>
                </div>

                <div class="col col-md-4">
                    <a href="'.$controller->link('developer', 'toolbox').'&action=deleteFolderTemp" class="alert-action-default btn btn-block btn-danger">
                        <i class="fa fa-fw fa-times"></i>&nbsp;Excluir pasta TEMP - SISTEMA
                    </a>
                </div>
            </div>

            <br>

            <div class="alert alert-light">
                Funções aplicadas em todos os módulos do sistema - IMAGENS WEBP
            </div>

            <div class="row">
                <div class="col col-md-4">
                    <a href="'.$controller->link('developer', 'toolbox').'&action=convertImagesToWebp" class="alert-action-default btn btn-block btn-success">
                        <i class="fa fa-fw fa-magic"></i>&nbsp;Converter imagens para WEBP - SISTEMA
                    </a>
                </div>

                <div class="col col-md-4">
                    <a href="'.$controller->link('developer', 'toolbox').'&action=restoreWebpToImages" class="alert-action-default btn btn-block btn-warning">
                        <i class="fa fa-fw fa-magic"></i>&nbsp;Restaurar WEBP para imagens - SISTEMA
                    </a>
                </div>

                <div class="col col-md-4">
                    <a href="'.$controller->link('developer', 'toolbox').'&action=deleteImagesWebp" class="alert-action-default btn btn-block btn-danger">
                        <i class="fa fa-fw fa-magic"></i>&nbsp;Excluir WEBP - SISTEMA
                    </a>
                </div>
            </div>';

        $vars['htmlHeader'] = '<h1>DEVELOPER / ToolBox</h1>';
        $vars['htmlNoneItens'] = 'Nenhum dado extra para esta configuração.';

        $this->breadcrumb->setLabel('toolbox', 'DEVELOPER / ToolBox');

        return ToolsTemplate::page($this->controller, $page, $vars);
    }

    public function deleteGhostAllFilesDatabase()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $modulesSystem = $this->modules()->modulesSystem;

        foreach ($modulesSystem as $keyModules => $valueModules) {
            $toolsMaintenance->controller()->setTable($valueModules['table']);
            $toolsMaintenance->controller()->setSufix($valueModules['sufix']);

            $toolsImages = new ToolsImagesDoop($toolsMaintenance);

            if ($valueModules['type'] == 'primary' || $valueModules['type'] == 'relative') {
                $toolsImages->deleteImagesNotDatabase($keyModules, $valueModules['table']);
            }
            else if ($valueModules['type'] == 'static') {
                $automatics = include(config('app.ROOT_CMS').'/'.$valueModules['folder'].'/'.$keyModules.'/automatic-forms-config.php');

                foreach ($automatics as $keyAutomatics => $valueAutomatics) {
                    $queryExternal[] = "SELECT `value_base` as parameter FROM `sis_base` WHERE `key_base` = '".$keyAutomatics."' AND `value_base` LIKE '%---fileNameSearch---%'";
                }

                $types = ['jpg', 'png', 'gif', 'webp'];

                $path = config('app.ROOT_UPLOAD').'/'.$keyModules.'/images';

                $folders_module = null;

                $filesRoot = $toolsImages->selectAllFilesOnDatabase($path, $folders_module, $types, $queryExternal);

                $toolsImages->deleteFilesProcess($filesRoot, true);
            }
            else if ($valueModules['type'] == 'configuration') {
                $queryExternal[] = "SELECT `value_base` as parameter FROM `sis_base` WHERE `key_base` = 'assets' AND `value_base` LIKE '%---fileNameSearch---%'";

                $types = ['jpg', 'png', 'gif', 'webp'];

                $path = config('app.ROOT_UPLOAD').'/'.$keyModules.'/images';

                $folders_module = null;

                $filesRoot = $toolsImages->selectAllFilesOnDatabase($path, $folders_module, $types, $queryExternal);

                $toolsImages->deleteFilesProcess($filesRoot, true);
            }
        }

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=delete_ghosts_files');
        exit;
    }

    public function convertImagesToWebp()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $modulesSystem = $this->modules()->modulesSystem;

        foreach ($modulesSystem as $keyModules => $valueModules) {
            $toolsMaintenance->controller()->setTable($valueModules['table']);
            $toolsMaintenance->controller()->setSufix($valueModules['sufix']);

            $toolsImages = new ToolsImagesDoop($toolsMaintenance);

            if ($valueModules['type'] == 'primary' || $valueModules['type'] == 'relative' || $valueModules['type'] == 'static' || $valueModules['type'] == 'configuration') {
                $toolsImages->convertWebpFeature($keyModules);
            }
        }

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=convert_webp_success');
        exit;
    }

    public function restoreWebpToImages()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $modulesSystem = $this->modules()->modulesSystem;

        foreach ($modulesSystem as $keyModules => $valueModules) {
            $toolsMaintenance->controller()->setTable($valueModules['table']);
            $toolsMaintenance->controller()->setSufix($valueModules['sufix']);

            $toolsImages = new ToolsImagesDoop($toolsMaintenance);

            if ($valueModules['type'] == 'primary' || $valueModules['type'] == 'relative') {
                $toolsImages->restoreWebpFeature($keyModules, $valueModules['table']);
            }
            else if ($valueModules['type'] == 'static') {
                $automatics = include(config('app.ROOT_CMS').'/'.$valueModules['folder'].'/'.$keyModules.'/automatic-forms-config.php');

                foreach ($automatics as $keyAutomatics => $valueAutomatics) {
                    $queryExternal[] = "SELECT `value_base` as parameter FROM `sis_base` WHERE `key_base` = '".$keyAutomatics."' AND `value_base` LIKE '%---fileNameSearch---%'";
                }

                $types = ['webp'];
                $typesFix = ['jpg', 'png', 'gif'];

                $path = config('app.ROOT_UPLOAD').'/'.$keyModules.'/images';

                $folders_module = null;

                $filesRoot = $toolsImages->selectAllFilesOnDatabase($path, $folders_module, $types, $queryExternal);

                $toolsImages->restoreWebpFilesProcess($path, $filesRoot, false, $typesFix);
            }
            else if ($valueModules['type'] == 'configuration') {
                $queryExternal[] = "SELECT `value_base` FROM `sis_base` WHERE `key_base` = 'assets' AND `value_base` LIKE '%---fileNameSearch---%'";

                $types = ['webp'];
                $typesFix = ['jpg', 'png', 'gif'];

                $path = config('app.ROOT_UPLOAD').'/'.$keyModules.'/images';

                $folders_module = null;

                $filesRoot = $toolsImages->selectAllFilesOnDatabase($path, $folders_module, $types, $queryExternal);

                $toolsImages->restoreWebpFilesProcess($path, $filesRoot, false, $typesFix);
            }
        }

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=restore_webp_success');
        exit;
    }

    public function deleteImagesWebp()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $modulesSystem = $this->modules()->modulesSystem;

        $types = ['webp'];

        foreach ($modulesSystem as $keyModules => $valueModules) {
            $toolsMaintenance->controller()->setTable($valueModules['table']);
            $toolsMaintenance->controller()->setSufix($valueModules['sufix']);

            $toolsImages = new ToolsImagesDoop($toolsMaintenance);

            if ($valueModules['type'] == 'primary' || $valueModules['type'] == 'relative' || $valueModules['type'] == 'static' || $valueModules['type'] == 'configuration') {
                $toolsImages->deleteWebpFeature($keyModules, $valueModules['table']);
            }
        }

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=delete_webp_success');
        exit;
    }

    public function deleteFolderTemp()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $modulesSystem = $this->modules()->modulesSystem;

        foreach ($modulesSystem as $keyModules => $valueModules) {
            $toolsMaintenance->controller()->setTable($valueModules['table']);
            $toolsMaintenance->controller()->setSufix($valueModules['sufix']);

            $toolsImages = new ToolsImagesDoop($toolsMaintenance);

            if ($valueModules['type'] == 'primary' || $valueModules['type'] == 'relative' || $valueModules['type'] == 'static' || $valueModules['type'] == 'configuration') {
                $toolsImages->deleteFolderTemp($keyModules);
            }
        }

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=delete_foldertemp_success');
        exit;
    }

    public function resetTableSystem()
    {
        $this->resetExtras();

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=sample_data');
        exit;
    }

    public function resetAdministrator()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $toolsMaintenance->resetTableController(false, 'mod_administrator');
        $toolsMaintenance->resetTableController(false, 'mod_administrator-nivel');
        $toolsMaintenance->resetTableController(false, 'mod_administrator-privilege');

        $toolsMaintenance->loadSqlModule('sql-administrator');
    }

    public function resetExtras()
    {
        $toolsMaintenance = new ToolsMaintenanceDoop($this);

        $toolsMaintenance->resetTableController(false, 'sub_anexx');
        $toolsMaintenance->resetTableController(false, 'sub_audio');
        $toolsMaintenance->resetTableController(false, 'sub_photo');
        $toolsMaintenance->resetTableController(false, 'sub_video');
        $toolsMaintenance->resetTableController(false, 'sub_config');

        $toolsMaintenance->loadSqlModule('sql-extra');
    }

    public function importData()
    {

    }

    public function importDataExtras()
    {
        $model = new ModelDoop('pt_br');
        $model->connectionOpen(null, null, null, 'ds196_developer', 3307);

        $this->modules->operation = 'insert';

        $query = "SELECT * FROM `sub_anexx`";
        $result = $model->dbFetchAllAssoc($query, null);

        if ($result) {
            foreach ($result as $key => $value) {
                parent::setTable('sub_anexx');
                parent::setSufix('anexx');

                parent::dataSave($value, 'insert', false, null, false);
            }
        }

        $query = "SELECT * FROM `sub_audio`";
        $result = $model->dbFetchAllAssoc($query, null);

        if ($result) {
            foreach ($result as $key => $value) {
                parent::setTable('sub_audio');
                parent::setSufix('audio');
                parent::dataSave($value, 'insert', false, null, false);
            }
        }

        $query = "SELECT * FROM `sub_photo`";
        $result = $model->dbFetchAllAssoc($query, null);

        if ($result) {
            foreach ($result as $key => $value) {
                parent::setTable('sub_photo');
                parent::setSufix('photo');
                parent::dataSave($value, 'insert', false, null, false);
            }
        }

        $query = "SELECT * FROM `sub_seo`";
        $result = $model->dbFetchAllAssoc($query, null);

        if ($result) {
            foreach ($result as $key => $value) {
                parent::setTable('sub_seo');
                parent::setSufix('seo');
                parent::dataSave($value, 'insert', false, null, false);
            }
        }

        $query = "SELECT * FROM `sub_audio`";
        $result = $model->dbFetchAllAssoc($query, null);

        if ($result) {
            foreach ($result as $key => $value) {
                parent::setTable('sub_audio');
                parent::setSufix('audio');
                parent::dataSave($value, 'insert', false, null, false);
            }
        }

        return true;
    }

    public function importDataAdministrator()
    {
        $model = new ModelDoop('pt_br');
        $model->connectionOpen(null, null, null, 'ds196_developer', 3307);

        $query = "SELECT * FROM `mod_administrator` WHERE `status_administrator` = 'active'";
        $result = $model->dbFetchAllAssoc($query, null);

        $this->modules->operation = 'insert';

        if ($result) {
            foreach ($result as $key => $value) {
                $dataSave['id_administrator'] = intval($value['id_administrator']);
                $dataSave['name_administrator'] = parent::processData(parent::processString($value['name_administrator']));
                $dataSave['email_administrator'] = $value['email_administrator'];
                $dataSave['password_administrator'] = $value['password_administrator'];
                $dataSave['token_administrator'] = $value['token_administrator'];
                $dataSave['params_administrator'] = $value['params_administrator'];
                $dataSave['user_administrator'] = intval($value['user_administrator']);
                $dataSave['time_administrator'] = $value['time_administrator'];
                $dataSave['status_administrator'] = $value['status_administrator'];

                parent::setTable('mod_administrator');
                parent::setSufix('administrator');
                parent::dataSave($dataSave, 'insert', false, null, false);

                $this->importDataNivel($dataSave['id_administrator']);
                $this->importDataPrivilege($dataSave['id_administrator']);
            }
        }

        return true;
    }

    public function importDataNivel($idAdministrator)
    {
        $modelNivel = new ModelDoop('pt_br');
        $modelNivel->connectionOpen(null, null, null, 'ds196_developer', 3307);

        $queryNivel = "SELECT * FROM `mod_administrator-nivel` WHERE `administrator_nivel` = '".$idAdministrator."'";

        if ($resultNivel = $modelNivel->dbFetchAllAssoc($queryNivel, null)) {
            foreach ($resultNivel as $key => $value) {
                $dataSaveNivel['administrator_nivel'] = intval($value['administrator_nivel']);
                $dataSaveNivel['module_nivel'] = $value['module_nivel'];

                if ($value['privilege_nivel'] == 1) {
                    $dataSaveNivel['privilege_nivel'] = 1;
                }
                else {
                    $dataSaveNivel['privilege_nivel'] = 2;
                }

                parent::setTable('mod_administrator-nivel');
                parent::setSufix('nivel');
                parent::dataSave($dataSaveNivel, 'insert', false, null, false);
            }
        }
    }

    public function importDataPrivilege($idAdministrator)
    {
        $modelPrivilege = new ModelDoop('pt_br');
        $modelPrivilege->connectionOpen(null, null, null, 'ds196_developer', 3307);

        $queryPrivilege = "SELECT * FROM `mod_administrator-privilege` WHERE `administrator_privilege` = '".$idAdministrator."'";

        if ($resultPrivilege = $modelPrivilege->dbFetchAssoc($queryPrivilege, null)) {
            $dataSavePrivilege['administrator_privilege'] = intval($resultPrivilege['administrator_privilege']);

            if ($resultPrivilege['master_privilege'] == 1) { $dataSavePrivilege['master_privilege'] = 1; } else { $dataSavePrivilege['master_privilege'] = 2; }
            if ($resultPrivilege['god_privilege'] == 1) { $dataSavePrivilege['god_privilege'] = 1; } else { $dataSavePrivilege['god_privilege'] = 2; }
            if ($resultPrivilege['root_privilege'] == 1) { $dataSavePrivilege['root_privilege'] = 1; } else { $dataSavePrivilege['root_privilege'] = 2; }
            if ($resultPrivilege['developer_privilege'] == 1) { $dataSavePrivilege['developer_privilege'] = 1; } else { $dataSavePrivilege['developer_privilege'] = 2; }

            parent::setTable('mod_administrator-privilege');
            parent::setSufix('privilege');
            parent::dataSave($dataSavePrivilege, 'insert', false, null, false);
        }
    }

    public function resetStatsTable()
    {
        $modulesSystem = $this->modules()->modulesSystem;

        $types = ['webp'];

        foreach ($modulesSystem as $keyModules => $valueModules) {
            if ($valueModules['type'] == 'primary') {
                $repository = new Repository($valueModules['sufix']);

                if ($repository->checkField('view')) {
                    $query = "UPDATE `".$valueModules['table']."` SET `view_".$valueModules['sufix']."` = '0'";
                    $repository->database()->dbQuery($query);
                }
            }
        }

        $repository = new Repository('base', ['old' => true, 'prefixKey' => 'sis']);

        $query = "UPDATE `sis_base` SET `value_base` = NULL WHERE `key_base` = 'stats'";
        $repository->database()->dbQuery($query);

        header('Location: '.$this->controller()->link('developer', 'toolbox').'&callback=reset_views_table');
        exit;
    }
}
