<?php
require_once(config('app.ROOT_CMS_CORE').'/class.login.php');
$login = new LoginDoop();
?>
<!DOCTYPE html>
<html lang="pt-br">
    <head>
        <meta charset="utf-8" />
        <title><?php echo config('app.LABEL_SYSTEM_TITLE'); ?></title>
        <meta name="description" content="<?php echo config('app.LABEL_SYSTEM_DESCRIPTION'); ?>" />
        <meta name="keywords" content="<?php echo config('app.LABEL_SYSTEM_KEYWORDS'); ?>" />
        <meta name="author" content="<?php echo config('app.LABEL_SYSTEM_AUTHOR'); ?>" />
        <meta name="viewport" content="width=device-width, initial-scale=1.0" />
        <link rel="shortcut icon" href="<?php echo assets_img('favicon.png', 'painel'); ?>" />
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Source+Sans+Pro:wght@300;400;700&display=swap" rel="stylesheet">
        <script defer src="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/js/all.min.js"></script>
        <link rel="stylesheet" href="<?php echo assets_css('core', 'painel'); ?>" />
    </head>

    <body class="hold-transition login-page">
        <div class="preloader flex-column justify-content-center align-items-center">
            <img class="animation__shake" src="<?php echo assets_img('favicon.png', 'painel'); ?>" alt="<?php echo config('app.LABEL_SYSTEM_NAME'); ?>">
        </div>

        <div class="login-box">
            <div class="login-logo">
                <a href="<?php echo config('app.PATH_CMS'); ?>" title="<?php echo config('app.LABEL_SYSTEM_TITLE'); ?>">
                    <img src="<?php echo assets_img('img-logo.png', 'painel'); ?>" alt="<?php echo config('app.LABEL_SYSTEM_NAME'); ?>" style="width: <?php echo config('app.INDEX_LOGO_WIDTH'); ?>; margin-bottom: 0;" />
                </a>
            </div>

            <div class="card mt-4">
                <div class="card-header text-center">
                    Recuperar sua senha!
                </div>

                <div class="card-body login-card-body">
                    <p class="login-box-msg">Digite seu e-mail e siga as instruções</p>

                    <form id="redefine_form" name="redefine_form" class="form-validate" method="POST" action="<?php echo config('app.PATH_CMS'); ?>/recuperar-senha">
                        <div class="form-group">
                            <div class="input-group">
                                <input type="email" id="email_redefine" name="email_redefine" class="form-control" placeholder="E-mail" required />

                                <div class="input-group-append">
                                    <div class="input-group-text">
                                        <span class="fas fa-fw fa-envelope"></span>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="submit" id="submit_redefine" name="submit_redefine" class="btn btn-primary btn-block" value="on" title="Clique para alterar a senha">Redefinir</button>
                    </form>

                    <p class="mt-2 mb-0 text-center"><a href="<?php echo config('app.PATH_CMS'); ?>" title="Clique para fazer o login">Fazer login!</a></p>
                </div>

                <div class="card-footer text-center">
                    <a href="<?php echo config('app.SITE_AUTHOR'); ?>" target="_blank" title="<?php echo config('app.LABEL_SYSTEM_AUTHOR'); ?>">
                        <img src="<?php echo assets_img('signature.png', 'painel'); ?>" alt="<?php echo config('app.LABEL_SYSTEM_AUTHOR'); ?>" style="width: <?php echo config('app.INDEX_COMPANY_WIDTH'); ?>;" />
                    </a>
                </div>
            </div>
        </div>

        <script src="<?php echo assets_js('core', 'painel'); ?>"></script>

        <script>
        $(document).ready(function(){
            validationObserver('.form-validate');
        });
        </script>

        <?php if (isset($login->callback->typeIn)) { ?>
        <script>
            executeCallback('<?php echo $login->callback->message; ?>', '<?php echo $login->callback->typeIn; ?>');
        </script>
        <?php } ?>
    </body>
</html>
