<?php
require_once(config('app.ROOT_CMS').'/system/stats/class.module.php');

$dashboard = new ModulesStructureDoop('dashboard', 'manage', 'static');
$access = $dashboard->menu('modules');
$accessSystem = $dashboard->menu('system');

$dataApi['pageClean'] = true;

$dataApi['htmlHeader'] = '<h1>Dashboard</h1>';

$moduleStats = new ModuleDoop($controller, 'manage');

$stats = $moduleStats->getStatsList('website', date('Y'), date('m'), 'all-days');

if (isset($stats['graphics']['title'])) {
    $stats['graphics']['title'] = null;
}

$total = 'Nenhum acesso';

if (isset($stats['all-registers']['total']) && $stats['all-registers']['total'] == 1) {
    $total = $stats['all-registers']['total'].' acesso';
}
else if (isset($stats['all-registers']['total']) && $stats['all-registers']['total'] > 1) {
    $total = $stats['all-registers']['total'].' acessos';
}
else {
    $total = 'Nenhum acesso';
}

$dataApi['htmlPage'] = '
<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-8">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title"><span class="text-uppercase">'.\Treatment::date(date('m'), 'month_name').'/'.date('Y').'</span> - Total: <b>'.$total.'</b></h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="card-body card-body-dashboard">
                        <canvas class="chartjs" id="chartStats" width="547" height="100"></canvas>
                    </div>

                    <div class="card-footer text-center">
                        <a href="'. Request::linkDoop('stats', 'central', null, 'system').'" class="btn btn-sm btn-primary m-0" title"Visualize o resumo de acesso de seu site"><i class="fas fa-chart-bar mr-2"></i><span>Visualize o resumo de acesso de seu site</span></a>
                    </div>
                </div>

                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Acesso rápido</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="card-body card-body-dashboard">
                        <div class="row">';
                            if ($access) {
                                if (isset($access['primary'])) {
                                    foreach ($access['primary']['sub'] as $key => $value) {
                                        if (isset($value['url_insert'])) {
                                            $dataApi['htmlPage'] .= '
                                            <div class="col-md-3 mt-2 mb-2">
                                                <a class="btn btn-primary btn-block btn-shortcuts" href="'.$value['url_insert'].'">
                                                    '.$value['title'].'
                                                </a>
                                            </div>';
                                        }
                                    }
                                }

                                if (isset($access['group'])) {
                                    foreach ($access['group'] as $keyGroup => $valueGroup) {
                                        foreach ($valueGroup['sub'] as $key => $value) {
                                            if (isset($value['url']) && $value['type'] != 'manual' && $value['type'] != 'static') {
                                                $dataApi['htmlPage'] .= '
                                                <div class="col-md-3 mt-2 mb-2">
                                                    <button class="btn btn-primary btn-block btn-shortcuts" data-link="'.$value['url'].'">

                                                        '.$value['title'].'
                                                    </button>
                                                </div>';
                                            }
                                        }
                                    }
                                }
                            }
                            $dataApi['htmlPage'] .= '
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-sm-4">';
                if ($dashboard->checkPrivilege('god')) {
                    $last = $dashboard->dbFetch("SELECT * FROM `sis_backups` ORDER BY `time_backups` DESC LIMIT 1");

                    if (isset($last['time_backups'])) {
                        $lastDate = new DateTime(substr($last['time_backups'], 0, 10));
                        $activeDate = new DateTime(date('Y-m-d H:i:s'));

                        $days = $activeDate->diff($lastDate)->days;
                    }

                    if (is_array($last) && isset($days) && $days >= 30) {
                        $dataApi['htmlPage'] .= '
                            <div class="alert alert-block alert-danger">
                                <i class="fa fa-check "></i>
                                Último backup <strong class="">'.$dashboard->timeDiff($last['time_backups'], null, ['foi realizado', 'será realizado']).'</strong> - <a href="'.config('app.PATH_SYSTEM').'system/backups&operation=dump'.'" title="Realizar Backup">Realizar Backup</a>
                            </div>';
                    }
                }

                $dataApi['htmlPage'] .= '
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">'.config('app.LABEL_SYSTEM_AUTHORMIN').'</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                <i class="fas fa-minus"></i>
                            </button>
                        </div>
                    </div>

                    <div class="card-body card-info-dashboard">
                        <h4>Seja bem vindo(a) ao <b>'.config('app.LABEL_SYSTEM_TITLE').'</b>.</h4>
                        '.config('app.CARD_INFO_DASHBOARD').'
                        <hr>
                        <p class="mb-0"><b>'.config('app.LABEL_SYSTEM_AUTHOR').'</b></p>
                        <p><a href="'.config('app.SITE_AUTHOR').'" target="_blank" title="'.config('app.LABEL_SYSTEM_AUTHOR').'">'.config('app.SITE_AUTHOR').'</a></p>
                        <a href="'.config('app.SITE_AUTHOR').'" target="_blank" title="'.config('app.LABEL_SYSTEM_AUTHOR').'"><img src="'.assets_img('signature.png', 'painel').'" alt="'.config('app.LABEL_SYSTEM_AUTHOR').'" style="max-width: '.config('app.DASHBOARD_COMPANY_WIDTH').'; width: 100%;" /></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>';


if (isset($stats['graphics'])) {
    $dataApi['htmlPage'] .= '
    <script>
        var grapichsLabels = ['.$stats['graphics']['labels'].']
        var grapichsValues = ['.$stats['graphics']['values'].']
        var grapichsTitle = "Acessos"
    </script>';
}

$dataApi['htmlPage'] .= '
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Chart.js/3.3.2/chart.min.js"></script>
    <script>
    if (typeof grapichsLabels !== "undefined") {
        viewChart(grapichsLabels, grapichsValues, grapichsTitle);
    }

    function viewChart(grapichsLabels, grapichsValues, grapichsTitle) {
        var chartStatsData = {
            labels: grapichsLabels,
            datasets: [
                {
                    label: grapichsTitle,
                    data: grapichsValues,
                    backgroundColor: [
                        "'.config('app.BG_CHART').'"
                    ],
                    borderWidth: 0
                }
            ]
        };

        var chartStatsInit = {
            type: "bar",
            data: chartStatsData,
            options: {
                scales: {
                    y: {
                        beginAtZero: true
                    }
                }
            }
        };

        var ctxStats = document.getElementById("chartStats").getContext("2d");
        var chartCall = new Chart(ctxStats, chartStatsInit);
    };
    </script>
';

return $dataApi;
