<?php

require_once(config('app.ROOT_CMS_HELPERS').'/class.phonesInput.php');

class ModuleDoop extends ModuleMaster
{
    public $phones = null;

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        $this->phones = new PhonesInput();
        $this->phones->operatorActive = false;

        parent::__construct($controller, $operation, 'usefulphones');

        $this->setControl('controls_modules', true);
	}

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th>título</th>
        <th width="1%" class="text-center">telefone</th>';

        $tbody = function ($result) use ($controller, $modules) {
             $dataTbody = '<td><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5></td>';

             $phones = json_decode($result[$controller->sufix('phone')], true);

             $dataTbody .= '<td class="text-center text-nowrap">
                <ul class="list-inline list-phones">';
                    foreach ($phones['number'] as $keyNumber => $valueNUmber) {
                        $dataTbody .= '
                        <li><a href="tel:'.$controller->processString($valueNUmber, 'callto').'">'.$valueNUmber.'</a>';
                        if ($phones['details'][$keyNumber]) {
                            $dataTbody .= ' ['.$controller->processString($phones['details'][$keyNumber]).']';
                        }
                        $dataTbody .= '</li>';
                    }
                $dataTbody .= '
                </ul>
            </td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .=  $this->phones->showHtml();

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
			$controller->sufix('phone') => json_encode($this->phones->preparePhones())
        ];

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $this->phones->showHtml(json_decode($controller->value('phone'), true));

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('phone') => json_encode($this->phones->preparePhones())
        ];

        $controller->dataSave($data, 'update');

        return true;
    }

    public function importData()
    {
        \DeveloperSlim\Seeders\UsefulPhonesSeeder::seed();
    }
}
