<?php

class ModuleDoop extends ModuleMaster
{
    public $form_targets = [
        '_blank' => 'Nova Janela',
        '_parent' => 'Mesma Janela'
    ];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'usefullinks');

        $this->setControl('controls_modules', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th>título</th>
        <th width="1%" class="text-center">url</th>';

        $tbody = function ($result) use ($controller, $modules) {
             $dataTbody = '<td><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5></td>';

            $link = $controller->processString($result[$controller->sufix('url')]);

            $dataTbody .= '<td class="text-center text-nowrap"><a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a></td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('url'), 'URL', $controller->value('url'), ['cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_blank', $this->form_targets);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('url') => $controller->post($controller->sufix('url')),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->generatorOrder(),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('url'), 'URL', $controller->value('url'), ['cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_blank', $this->form_targets);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('url') => $controller->post($controller->sufix('url')),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->post($controller->sufix('order'), 'int'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $controller->dataSave($data, 'update');

        return true;
    }

    public function importData()
    {
        \DeveloperSlim\Seeders\UsefulLinksSeeder::seed();
    }
}
