<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        $this->imgx = 400;
        $this->imgy = 400;
        $this->extension = 'jpg, png, gif';

        parent::__construct($controller, $operation, 'testimonials');

        $this->setControl('controls_modules', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('time')."` DESC";

        $thead = '
        <th width="1%" class="text-center">foto</th>
        <th>depoimento</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-center">'.$modules->getPhotoPage($result[$controller->sufix('cover')], 'cover', null, null, false, true).'</td>';
            $dataTbody .= '<td><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5>';
            $dataTbody .= '<p class="mb-2">'.$controller->processString($result[$controller->sufix('company')]).'</p>';
            $dataTbody .= $controller->processString($result[$controller->sufix('text')]).'</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Nome', $controller->value('title'));
        $page .= $forms->input($controller->sufix('company'), 'Empresa/Profissão', $controller->value('company'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Depoimento', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('cover'), 'Foto', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('company') => $controller->post($controller->sufix('company')),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text')
        ];

        $cover = new \CoreSlim\Upload();
        $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
        $cover->dimensions([$this->imgx, $this->imgy]);
        $cover->loadBlob($controller->post($controller->sufix('cover')));

        if ($output = $cover->output('json')) {
            $data[$controller->sufix('cover')] = $output;
        }

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Nome', $controller->value('title'));
        $page .= $forms->input($controller->sufix('company'), 'Empresa/Profissão', $controller->value('company'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Depoimento', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('cover'), 'Foto', $modules->getPhotoPageOnlyLinks($controller->value('cover'), 'cover'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('company') => $controller->post($controller->sufix('company')),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text')
        ];

        $cover = new \CoreSlim\Upload();
        $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
        $cover->dimensions([$this->imgx, $this->imgy]);
        $cover->loadBlob($controller->post($controller->sufix('cover')));

        if ($output = $cover->output('json')) {
            $data[$controller->sufix('cover')] = $output;
        }

        $controller->dataSave($data, 'update');

		return true;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\TestimonialsSeeder::seed();
    }
}
