<?php

class ModuleDoop extends ModuleMaster
{
    public $form_types = [
        1 => 'Texto e plano de fundo',
        2 => 'Somente imagem'
    ];

    public $form_positions = [
        1 => 'Alinhado à Esquerda',
        2 => 'Alinhado à Direita',
        3 => 'Centralizado'
    ];

    public $form_internals = [
        1 => 'URL Interna Livre',
        2 => 'URL Completa',
        3 => 'URL Interna Páginas'
    ];

    public $form_targets = [
        '_blank' => 'Nova Janela',
        '_parent' => 'Mesma Janela'
    ];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        $this->imgx = 1920;
        $this->imgy = 1080;

        $this->imgxxs = 425;
        $this->imgyxs = 850;

        $this->extension = 'jpg';

        parent::__construct($controller, $operation, 'slideshow');
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th width="1%" class="text-center">imagem</th>
        <th>slideshow</th>
        <th width="1%" class="text-center">url</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-center">'.$modules->getPhotoMobileDesktop($result[$controller->sufix('file')], 'desktop').'</td>';

            $dataTbody .= '<td>';

            if ($result[$controller->sufix('title')]) {
                $dataTbody .= '<b>Título:</b> '.$controller->processString($result[$controller->sufix('title')]).'<br>';
            }

            if ($result[$controller->sufix('text')]) {
                $dataTbody .= '<b>Texto:</b> '.$controller->processString($result[$controller->sufix('text')]);
            }

            $dataTbody .= '</td>';

            $dataTbody .= '<td class="text-nowrap text-center">';

            if ($result[$controller->sufix('internal')] == 1) {
                if ($result[$controller->sufix('url')] && $result[$controller->sufix('url')] != '#') {
                    $link = config('app.BASE_PATH').'/'.$controller->processString($result[$controller->sufix('url')]);

                    $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
                }
                else {
                    $dataTbody .= '<b class="text-danger"># SEM AÇÃO</b>';
                }
            }
            else if ($result[$controller->sufix('internal')] == 2) {
                $link = $controller->processString($result[$controller->sufix('url')]);

                $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
            }
            else if ($result[$controller->sufix('internal')] == 3) {
                $link = config('app.BASE_PATH').'/'.$controller->getTupleModule('page', $result[$controller->sufix('url')], 'slug');

                $dataTbody .= '<a href="'.$link.'" target="_blank" title="'.$link.'" class="btn btn-sm btn-info"><i class="fas fa-paperclip mr-2"></i>Acessar</a>';
            }

            $dataTbody .= '</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->radio($controller->sufix('type'), 'Tipo', 1, $this->form_types);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 200]);
        $page .= $forms->input($controller->sufix('text'), 'Texto', $controller->value('text'), ['required' => false, 'maxlength' => 200]);
        $page .= $forms->input($controller->sufix('button'), 'Botão', $controller->value('button'), ['required' => false, 'maxlength' => 70]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('position'), 'Alinhamento', 1, $this->form_positions);
        $page .= $forms->separate('separate-onlytexts');
        $page .= $forms->radio($controller->sufix('internal'), 'Tipo de URL', 1, $this->form_internals);
        $page .= $forms->input($controller->sufix('url'), 'URL Interna Livre', $controller->value('url'), ['required' => false, 'cont_input' => false, 'input_group_label' => config('app.BASE_PATH').'/']);
        $page .= $forms->input($controller->sufix('urlfull'), 'URL Completa', $controller->value('urlfull'), ['required' => false, 'form_group' => 'd-none', 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->select($controller->sufix('urlpage'), 'Url Interna Páginas', $modules->inputSelectHtml('page', 'title'), ['required' => false, 'form_group' => 'd-none', 'input_col' => 'col col-md-5']);
        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_parent', $this->form_targets);
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('file'), 'Imagem - Desktop', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->uploadCrop($controller->sufix('filexs'), 'Imagem - Mobile', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgxxs, 'height' => $this->imgyxs]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('type') => $controller->post($controller->sufix('type'), 'int'),
            $controller->sufix('title') => $controller->post($controller->sufix('title'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('button') => $controller->post($controller->sufix('button'), 'text'),
            $controller->sufix('position') => $controller->post($controller->sufix('position'), 'int'),
            $controller->sufix('internal') => $controller->post($controller->sufix('internal'), 'int'),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->generatorOrder(),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        switch ($data[$controller->sufix('internal')])
        {
            case 1:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('url'));
            break;

            case 2:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlfull'));
            break;

            case 3:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlpage'), 'int');
            break;
        }

        $dataImages = [];

        $file = new \CoreSlim\Upload();
        $file->config($controller->sufix('file'), $controller->modules->key, $controller->linkSystem());
        $file->dimensions([$this->imgx, $this->imgy]);
        $file->loadBlob($controller->post($controller->sufix('file')));

        if ($output = $file->output('array')) {
            $dataImages['desktop'] = $output;
        }

        sleep(1);

        $filexs = new \CoreSlim\Upload();
        $filexs->config($controller->sufix('filexs'), $modules->key, $controller->linkSystem());
        $filexs->dimensions([$this->imgxxs, $this->imgyxs]);
        $filexs->loadBlob($controller->post($controller->sufix('filexs')));

        if ($outputxs = $filexs->output('array')) {
            $dataImages['mobile'] = $outputxs;
        }

        $data[$controller->sufix('file')] = json_encode($dataImages);

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        if ($controller->value('type') == 1) {
            $form_group['text'] = null;
            $form_group['button'] = null;
            $form_group['internal'] = null;
            $form_group['separate-onlytexts'] = null;
        }
        else if ($controller->value('type') == 2) {
            $form_group['text'] = 'd-none';
            $form_group['button'] = 'd-none';
            $form_group['internal'] = 'd-none';
            $form_group['separate-onlytexts'] = 'd-none';
        }

        $page = $forms->radio($controller->sufix('type'), 'Tipo', $controller->value('type'), $this->form_types);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'), ['maxlength' => 200]);
        $page .= $forms->input($controller->sufix('text'), 'Texto', $controller->value('text'), ['required' => false, 'maxlength' => 200, 'form_group' => $form_group['text']]);
        $page .= $forms->input($controller->sufix('button'), 'Botão', $controller->value('button'), ['required' => false, 'maxlength' => 70, 'form_group' => $form_group['button']]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('position'), 'Alinhamento', $controller->value('position'), $this->form_positions, ['form_group' => $form_group['internal']]);
        $page .= $forms->separate('separate-onlytexts '.$form_group['separate-onlytexts']);
        $page .= $forms->radio($controller->sufix('internal'), 'Tipo de URL', $controller->value('internal'), $this->form_internals);

        if ($controller->value('internal') == 1) {
            $url['url'] = $controller->value('url');
            $url['urlfull'] = null;
            $url['urlpage'] = null;
            $form_group['url'] = null;
            $form_group['urlfull'] = 'd-none';
            $form_group['urlpage'] = 'd-none';
        }
        else if ($controller->value('internal') == 2) {
            $url['url'] = null;
            $url['urlfull'] = $controller->value('url');
            $url['urlpage'] = null;
            $form_group['url'] = 'd-none';
            $form_group['urlfull'] = null;
            $form_group['urlpage'] = 'd-none';
        }
        else if ($controller->value('internal') == 3) {
            $url['url'] = null;
            $url['urlfull'] = null;
            $url['urlpage'] = $controller->value('url');
            $form_group['url'] = 'd-none';
            $form_group['urlfull'] = 'd-none';
            $form_group['urlpage'] = null;
        }

        $page .= $forms->input($controller->sufix('url'), 'URL Interna Livre', $url['url'], ['required' => false, 'form_group' => $form_group['url'], 'cont_input' => false, 'input_group_label' => config('app.BASE_PATH').'/']);
        $page .= $forms->input($controller->sufix('urlfull'), 'URL Completa', $url['urlfull'], ['required' => false, 'form_group' => $form_group['urlfull'], 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-paperclip"></i>']);
        $page .= $forms->select($controller->sufix('urlpage'), 'Url Interna Páginas', $modules->inputSelectHtml('page', 'title',  $url['urlpage']), ['required' => false, 'form_group' => $form_group['urlpage'], 'input_col' => 'col col-md-5']);

        $page .= $forms->radio($controller->sufix('target'), 'Abrir URL', '_parent', $this->form_targets);
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('file'), 'Imagem - Desktop', $modules->getMultiplePhotoPageOnlyLinks($controller->value('file'), 'file', 'desktop'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->uploadCrop($controller->sufix('filexs'), 'Imagem - Mobile', $modules->getMultiplePhotoPageOnlyLinks($controller->value('file'), 'file', 'mobile'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgxxs, 'height' => $this->imgyxs]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('type') => $controller->post($controller->sufix('type'), 'int'),
            $controller->sufix('title') => $controller->post($controller->sufix('title'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('button') => $controller->post($controller->sufix('button'), 'text'),
            $controller->sufix('position') => $controller->post($controller->sufix('position'), 'int'),
            $controller->sufix('internal') => $controller->post($controller->sufix('internal'), 'int'),
            $controller->sufix('target') => $controller->post($controller->sufix('target')),
            $controller->sufix('order') => $controller->post($controller->sufix('order'))
        ];

        switch ($data[$controller->sufix('internal')])
        {
            case 1:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('url'));
            break;

            case 2:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlfull'));
            break;

            case 3:
                $data[$controller->sufix('url')] = $controller->post($controller->sufix('urlpage'));
            break;
        }

        $dataImages = json_decode($controller->value('file'), true);

        $file = new \CoreSlim\Upload();
        $file->config($controller->sufix('file'), $controller->modules->key, $controller->linkSystem());
        $file->dimensions([$this->imgx, $this->imgy]);
        $file->loadBlob($controller->post($controller->sufix('file')));

        if ($output = $file->output('array')) {
            $dataImages['desktop'] = $output;
        }

        sleep(1);

        $filexs = new \CoreSlim\Upload();
        $filexs->config($controller->sufix('filexs'), $modules->key, $controller->linkSystem());
        $filexs->dimensions([$this->imgxxs, $this->imgyxs]);
        $filexs->loadBlob($controller->post($controller->sufix('filexs')));

        if ($outputxs = $filexs->output('array')) {
            $dataImages['mobile'] = $outputxs;
        }

        $data[$controller->sufix('file')] = json_encode($dataImages);

        $controller->dataSave($data, 'update');

        return true;
    }
}
