<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'representatives');

        $this->setControl('controls_modules', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                  INNER JOIN `sis_ibge-state` ON (`id_ibge-state` = `".$controller->sufix('state')."`)
                  INNER JOIN `sis_ibge-city` ON (`id_ibge-city` = `".$controller->sufix('city')."`)
                  ".$modules->queryFilter."
                  WHERE ".$modules->queryStatus." ".$modules->querySearch."
                  GROUP BY `".$controller->sufix('id')."`
                  ORDER BY `name_ibge-state`, `name_ibge-city`, `".$controller->sufix('order')."`";

        $thead = '
        <th>nome</th>
        <th>endereço</th>
        <th>telefone</th>
        <th>celular</th>
        <th>email</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td>'.$controller->processString($result[$controller->sufix('title')]).'</td>';
            $dataTbody .= '<td><p>'.$controller->processString($result['name_ibge-city']).'/'.$controller->processString($result['iso_ibge-state']).'</p>';
            $dataTbody .= '<p>'.$controller->processString($result[$controller->sufix('address')]).'</p></td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('phone')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('celular')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('email')]).'</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Nome', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('state'), 'Estado', $controller->modules->inputSelectHtml('ibge-state', 'name', $controller->value('state')), ['input_class' => 'select2', 'primary_item' => 'Selecione um estado...']);
        $page .= $forms->select($controller->sufix('city'), 'Cidade', null, ['input_class' => 'select2', 'primary_item' => 'Aguardando selecionar um estado..']);
        $page .= $forms->input($controller->sufix('address'), 'Endereço', $controller->value('address'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->email($controller->sufix('email'), 'E-mail', $controller->value('email'), ['required' => false]);
        $page .= $forms->phone($controller->sufix('phone'), 'Telefone', $controller->value('phone'), ['required' => false]);
        $page .= $forms->phone($controller->sufix('celular'), 'Celular', $controller->value('celular'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('state') => $controller->post($controller->sufix('state'), 'int'),
            $controller->sufix('city') => $controller->post($controller->sufix('city'), 'int'),
            $controller->sufix('address') => $controller->post($controller->sufix('address')),
            $controller->sufix('phone') => $controller->post($controller->sufix('phone')),
            $controller->sufix('celular') => $controller->post($controller->sufix('celular')),
            $controller->sufix('email') => $controller->post($controller->sufix('email')),
            $controller->sufix('order') => $controller->generatorOrder("AND `".$controller->sufix('state')."` = '".$controller->post($controller->sufix('state'))."' AND `".$controller->sufix('city')."` = '".$controller->post($controller->sufix('city'))."'")
        ];

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Nome', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('state'), 'Estado', $controller->modules->inputSelectHtml('ibge-state', 'name', $controller->value('state')), ['input_class' => 'select2', 'primary_item' => 'Selecione um estado...']);
        $page .= $forms->select($controller->sufix('city'), 'Cidade', null, ['input_class' => 'select2', 'primary_item' => 'Aguardando selecionar um estado..']);
        $page .= $forms->input($controller->sufix('address'), 'Endereço', $controller->value('address'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->email($controller->sufix('email'), 'E-mail', $controller->value('email'), ['required' => false]);
        $page .= $forms->phone($controller->sufix('phone'), 'Telefone', $controller->value('phone'), ['required' => false]);
        $page .= $forms->phone($controller->sufix('celular'), 'Celular', $controller->value('celular'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('state') => $controller->post($controller->sufix('state'), 'int'),
            $controller->sufix('city') => $controller->post($controller->sufix('city'), 'int'),
            $controller->sufix('address') => $controller->post($controller->sufix('address')),
            $controller->sufix('phone') => $controller->post($controller->sufix('phone')),
            $controller->sufix('celular') => $controller->post($controller->sufix('celular')),
            $controller->sufix('email') => $controller->post($controller->sufix('email')),
            $controller->sufix('order') => $controller->post($controller->sufix('order'), 'int')
        ];

        $controller->dataSave($data, 'update');

        return true;
    }

    public function importData()
    {
        \DeveloperSlim\Seeders\RepresentativesSeeder::seed();
    }
}
