<?php

class ModuleDoop extends ModuleMaster
{
    public $configForm = null;

    private $configFormKey = 'configFormProtocol';

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'protocol');

        $this->modules()->control['bt_insert'] = false;
        $this->modules()->control['bt_update'] = false;
        $this->modules()->control['bt_view'] = true;
        $this->modules()->control['controls_filter'] = false;

        $this->modules()->filterStatusContent = [
            'active' => [
                'title' => 'Atendido',
                'label' => 'Atendido',
                'key' => 'atendido',
                'class' => 'success',
            ],
            'pendent' => [
                'title' => 'Pendente',
                'label' => 'Pendente',
                'key' => 'pendente',
                'class' => 'info',
            ],
            'disabled' => [
                'title' => 'Indeferido',
                'label' => 'Indeferido',
                'key' => 'indeferido',
                'class' => 'danger'
            ]
        ];

        if ($this->modules()->operation == 'manage' || $this->modules()->operation == 'configForm') {
            $this->setPage('configForm', ['action' => 'configForm', 'title' => 'Configuração do formulário', 'label' => 'Salvar', 'path' => 'module/protocol&operation=configForm', 'icon' => 'far fa-edit', 'privilege' => 'god']);

            $this->buttonExtra($controller->pathlang(null, config('app.PATH_SYSTEM').$this->modules()->page['configForm']['path']), $this->modules()->page['configForm']['title'], 'far fa-edit');

            $this->options['addCC'] = [
                'parameters' => [
                    'add' => 'adicionar c/c',
                    'delete' => 'excluir c/c'
                ],
                'itens' => [
                    'nameCC' => [
                        'label' => 'Nome',
                        'width' => '50%',
                        'type' => 'text',
                        'maxlength' => 200
                    ],
                    'emailCC' => [
                        'label' => 'E-mail',
                        'width' => '50%',
                        'type' => 'email',
                        'maxlength' => 200
                    ]
                ]
            ];
        }

        $this->configForm = $this->controller()->getBaseData($this->configFormKey);

        if ($this->modules()->operation == 'view') {
            $this->modules()->dataUpdate = $this->modules()->dataLoad($this->controller()->get('uuid'));

            $this->controller()->dbQuery("UPDATE `ex_protocol` SET `read_protocol` = '1' WHERE `uuid_protocol` = '".$this->controller()->get('uuid')."'");
        }

        if ($this->post('configForm_action_form')) {
            $this->editConfigForm();
        }

        if ($this->post('send_reply')) {
            $this->reply();
        }
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $modules->queryStatus = "(`status_protocol` <> 'deleted')";

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('time')."` DESC";

        $thead = '
        <th width="1%" class="text-center">protocolo</th>
        <th width="1%" class="text-center">data da ocorrência</th>
        <th>nome</th>
        <th>endereço</th>
        <th width="1%" class="text-center">telefone</th>
        <th width="1%" class="text-center">e-mail</th>
        <th width="1%" class="text-center">situação</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-center"><b>'.$controller->processString($result[$controller->sufix('protocol')]).'</b></td>';
            $dataTbody .= '<td class="text-center">'.$controller->processDate($result[$controller->sufix('date')], 'brazil').'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('name')]).'</td>';
            $dataTbody .= '<td>'.$controller->processString($result[$controller->sufix('address')]).'</td>';
            $dataTbody .= '<td class="text-center"><a href="mailto:'.$controller->processString($result[$controller->sufix('email')]).'">'.$controller->processString($result[$controller->sufix('email')]).'</a></td>';
            $dataTbody .= '<td class="text-center"><a href="tel:'.$controller->processString($result[$controller->sufix('phone')], 'callto').'">'.$controller->processString($result[$controller->sufix('phone')]).'</a></td>';

            if ($result[$controller->sufix('read')] == 0) {
                $dataTbody .= '<td class="text-center"><span class="badge badge-danger text-uppercase p-1 m-auto"><i class="fas fa-times mr-1"></i>Não lida</span></td>';
            }
            else {
                $dataTbody .= '<td class="text-center"><span class="badge badge-success text-uppercase p-1"><i class="fas fa-check mr-1"></i>Lida</span></td>';
            }

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function view()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $labelForm = $controller->getBaseData('extraProtocol')['label'];

        $page = '
        <h4>Protocolo recebido em <b>'.$controller->processDate($controller->value('time'), 'timestamp_brazil').'</b></h4>
        <hr>'.$this->htmlActionUniqueModule($controller->value('uuid')).'
        <div class="table-responsive">
            <table class="table table-striped table-bordered m-0">
                <tbody>
                    <tr>
                        <td width="25%" class="text-right"><b>Protocolo</b></td>
                        <td>'.$controller->value('protocol').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['name'].'</b></td>
                        <td>'.$controller->value('name').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['email'].'</b></td>
                        <td><a href="mailto:'.$controller->value('email').'">'.$controller->value('email').'</a></td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['phone'].'</b></td>
                        <td><a href="tel:'.$controller->processString($controller->value('phone'), 'callto').'">'.$controller->value('phone').'</a></td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['address'].'</b></td>
                        <td>'.$controller->value('address').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['date'].'</b></td>
                        <td>'.$controller->processDate($controller->value('date'), 'brazil').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>'.$labelForm['notification'].'</b></td>
                        <td>'.$controller->value('notification').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>IP</b></td>
                        <td>'.$controller->value('ip').'</td>
                    </tr>
                    <tr>
                        <td width="25%" class="text-right"><b>DISPOSITIVO</b></td>
                        <td>'.$controller->value('agent').'</td>
                    </tr>
                </tbody>
            </table>
        </div>

        <hr class="mt-3 mb-3">

        <h4 class="d-flex">Respostas do protocolo: <b class="ml-1">'.$controller->value('protocol').'</b><button class="btn btn-sm btn-primary ml-3" title="Responder protocolo" data-toggle="modal" data-target="#modalProtocol">Responder protocolo</button></h4>
        ';

        $id = 1;

        if ($replyQuery = $controller->dbFetchAll("SELECT * FROM `ex_protocol-reply` WHERE `protocol_protocol-reply` = '".$controller->value('id')."'")) {
            foreach ($replyQuery as $key => $reply) {
                $page .= '<div class="card card-primary card-outline mt-4">';
                $page .= '<div class="card-header"><b>Resposta #'.$id.' - '.$controller->processDate($reply['time_protocol-reply'], 'timestamp_brazil').'</b></div>';
                $page .= '<div class="card-body summernote">'.$controller->processString($reply['text_protocol-reply'], 'text').'</div>';
                $page .= '</div>';

                $id++;
            }
        }
        else {
            $page .= '<div class="alert alert-info text-center">NENHUM RESPOSTA ENCONTRADA</div>';
        }

        $page .= '
        <div class="modal fade" id="modalProtocol" tabindex="-1" aria-labelledby="modalProtocolLabel" aria-hidden="true">
            <div class="modal-dialog">
                <div class="modal-content">
                    <form name="reply_form" class="form-horizontal form-reply" method="post" action="'.$controller->linkSystem().'" enctype="multipart/form-data">
                        <div class="modal-header">
                            <h5 class="modal-title" id="modalProtocolLabel">Responder protocolo</h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                              <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <div class="row form-group m-0">
                                <label class="col-md-12 col-form-label text-left" for="text_reply">Nova Resposta:</label>
                                <div class="col-md-12">
                                    <div class="clearfix">
                                        <textarea id="text_reply" name="text_reply" class="summernote-mini" required></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="modal-footer">
                            <button id="send_reply" name="send_reply" value="value_reply" class="btn btn-primary" type="submit" title="Enviar">Enviar</button>
                        </div>
                    </form
                </div>
            </div>
        </div>';

        return ToolsTemplate::page($controller, $page, []);
    }

    public function configForm()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = '<form name="insert_form" class="form-horizontal form-validate" method="post" action="'.$controller->linkSystem(config('app.PATH_SYSTEM')).'">';
        $page .= $forms->input('header_configForm', 'Cabeçalho do E-mail', $this->configForm['header'], ['maxlength' => 100]);
        $page .= $forms->separate();
        $page .= $forms->input('nameFrom_configForm', 'Remetente/Nome', $this->configForm['nameFrom'], ['maxlength' => 100, 'input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input('emailFrom_configForm', 'Remetente/E-mail', $this->configForm['emailFrom'], ['type' => 'email', 'maxlength' => 100, 'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>']);
        $page .= $forms->separate();
        $page .= $forms->input('nameTo_configForm', 'Destinatário/Nome', $this->configForm['nameTo'], ['maxlength' => 100, 'input_group_label' => '<i class="fa fa-fw fa-user"></i>']);
        $page .= $forms->input('emailTo_configForm', 'Destinatário/E-mail', $this->configForm['emailTo'], ['type' => 'email', 'maxlength' => 100,'cont_input' => false, 'input_group_label' => '<i class="fa fa-fw fa-envelope"></i>']);
        $page .= $forms->separate();
        $page .= $forms->table_multiple('addCC', 'Cópias', $this->configForm, $this->options['addCC'], []);
        $page .= $forms->separate();
        $page .= '<div class="text-center">'.$modules->htmlButton().'</div>';
        $page .= '</form>';

        return ToolsTemplate::page($controller, $page);
    }

    public function editConfigForm()
    {
        $controller = $this->controller();

        $data = [
            'header' => $controller->post('header_configForm', 'text'),
            'nameFrom' => $controller->post('nameFrom_configForm', 'text'),
            'emailFrom' => $controller->post('emailFrom_configForm', 'email'),
            'nameTo' => $controller->post('nameTo_configForm', 'text'),
            'emailTo' => $controller->post('emailTo_configForm', 'email'),
            'nameCC' => $controller->post('nameCC', 'array_explode_shift'),
            'emailCC' => $controller->post('emailCC', 'array_explode_shift')
        ];

        $controller->setBaseData($this->configFormKey, $data, 'json');

        $this->routeCallback('301');
    }

    public function reply()
    {
        $controller = $this->controller();

        $idProtocol = $controller->value('id');
        $uuidProtocol = $controller->value('uuid');
        $protocol = $controller->value('protocol');

        $controller->setTable('ex_protocol-reply');
        $controller->setSufix('protocol-reply');

        $data = [
            'protocol_protocol-reply' => $idProtocol,
            'text_protocol-reply' => $controller->post('text_reply', 'text')
        ];

        $controller->dataSave($data, 'insert');

        $controller->setTable('ex_protocol');
        $controller->setSufix('protocol');

        $controller->dbQuery("UPDATE `ex_protocol` SET `status_protocol` = 'active' WHERE `uuid_protocol` = '".$uuidProtocol."'");

        $bodyReply = '
            <p>Houve uma interação em seu protocolo '.$protocol.'</p>
            <p>Acesse a área do protocolo com sua senha e verifique a resposta</p>
            <hr>
            <small>E-mail automático, favor não responder essa mensagem.</small>
        ';

        $link = $controller->linkSystem();

        $email = new \CoreSlim\Email();

        $emailsVars['body_title'] = 'Olá '.$controller->processString($controller->value('name'), 'first-name').',';
        $emailsVars['button_link'] = config('app.BASE_PATH').'/protocolo';
        $emailsVars['button_label'] = 'Acessar protocolo';
        $emailsVars['body_text'] = $bodyReply;
        $emailsVars['signature_label'] = $email->signature('signature_label');
        $emailsVars['signature_link'] = $email->signature('signature_link');

        $email->setConfig('template', 'basic.html');
        $email->setConfig('callback', $link);
        $email->setConfig('to', [$controller->value('email'), $controller->value('name')]);
        $email->setConfig('emailVars', $emailsVars);
        $email->setConfig('title', 'Protocolo: '. $protocol. ' - Interação');
        $email->setConfig('form', $this->configFormKey);

        if ($email->send()) {
            header('Location: '.$this->routeCallbackIn(702));
            exit;
        }
    }

    public function htmlActionUniqueModule($parameter, $extra = 'id', $slug = null)
    {
        $dataReturn = '<div class="action-buttons mb-2">';

        $action = 'set_disabled'; $title = 'Indeferir';

        $dataReturn .= '
        <a class="btn btn-danger" href="'.$this->modules()->page['manage']['path'].'&action='.$action.'&uuid='.$parameter.'" title="'.$title.'">
            <i class="fas fa-gavel mr-2"></i>'.$title.'
        </a>';

        $dataReturn .= '</div>';

        return $dataReturn;
    }

    public function resetTable()
    {
        $this->controller()->dbQuery("DROP TABLE `mod_procotol`");
        $this->controller()->dbQuery("DROP TABLE `mod_procotol-reply`");
    }
}
