<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'products-category');

        $this->setNavBars('seo', false);
	}

    public function manage()
    {
        $controller = $this->controller();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$controller->modules->queryFilter."
                 WHERE ".$controller->modules->queryStatus." ".$controller->modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th>categoria</th>';

        $tbody = function ($result) use ($controller) {
            $dataTbody = '
            <td>
                <p>'.$controller->processString($result[$controller->sufix('title')]).'</p>
            </td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('order') => $controller->generatorOrder()
        ];

		if ($controller->dataDuplicated(['title'], [$data[$controller->sufix('title')]]) == true) {
			header('Location: '.$controller->linkSystem().'&callback=401');
			exit;
		}

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('order') => intval($controller->post($controller->sufix('order'))),
        ];

		if ($data[$controller->sufix('title')] != $controller->value('title')) {
			if ($controller->dataDuplicated(['title'], [$data[$controller->sufix('title')]]) == true) {
				header('Location: '.$controller->linkSystem().'&callback=401');
				exit;
			}
		}

		$controller->dataSave($data, 'update');

		return true;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\ProductsCategorySeeder::seed();
    }
}
