<?php

class ModuleDoop extends ModuleMaster
{
    public $form_covertype = [
        1 => 'Nenhuma',
        2 => 'Imagem',
        3 => 'Vídeo'
    ];

    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'news');

        $this->imgx = 800;
        $this->imgy = 600;
        $this->extension = 'jpg, png, gif';

        $this->setNavBars('config', true);
        $this->setNavBars('photo', true);
        $this->setNavBars('video', true);
        $this->setNavBars('anexx', true);
        $this->setNavBars('audio', true);

        $this->setControl('controls_modules', true);
        $this->setControl('bt_frontend', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('date')."` DESC";

        $thead = '
        <th width="1%" class="text-center">imagem</th>
        <th>notícia</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $cover = null;

            if ($result[$controller->sufix('covertype')] == 2) {
                $cover = $modules->getPhotoPage($result[$controller->sufix('cover')], 'cover', null, null, false, true);
            }
            else if ($result[$controller->sufix('covertype')] == 3) {
                $cover = $modules->getVideoTemplateThumbnail($result[$controller->sufix('cover')]);
            }

            $dataTbody = '<td class="text-center">'.$cover.'</td>';
            $dataTbody .= '<td>';
            $dataTbody .= '<p><b>Categoria:</b> '.$controller->processString($result['title_news-category']).' - <b>Data:</b> '.$controller->processDate($result[$controller->sufix('date')], 'brazil').'</p>';
            $dataTbody .= '<h4>'.$controller->processString($result[$controller->sufix('title')]).'</h4>';

            if ($result[$controller->sufix('subtitle')]) {
                $dataTbody .= '<p><b>Chamada:</b> '.$controller->processString($result[$controller->sufix('subtitle')]).'</p>';
            }

            $dataTbody .= '</td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->date($controller->sufix('date'), 'Data', date('d/m/Y'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('category'), 'Categoria', $modules->inputSelectHtml('news-category', 'title', $controller->value('category')));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('covertype'), 'Tipo de Capa', 2, $this->form_covertype);

        $page .= '<div id="cover-image">';
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('cover'), 'Imagem/Capa', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->input($controller->sufix('legend'), 'Legenda', $controller->value('legend'), ['maxlength' => 250, 'required' => false]);
        $page .= '</div>';

        $page .= '<div id="cover-video" class="d-none">';
        $page .= $forms->separate();
        $page .= $forms->video($controller->sufix('video'), 'URL Vídeo', null, ['required' => false]);
        $page .= '</div>';

        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('date') => $controller->post($controller->sufix('date'), 'date'),
            $controller->sufix('category') => $controller->post($controller->sufix('category')),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle')),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('covertype') => $controller->post($controller->sufix('covertype'), 'int'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $data[$controller->sufix('slug')] = $controller->getSlug($data[$controller->sufix('title')], false, 'slug', $data[$controller->sufix('date')]);

        if ($data[$controller->sufix('covertype')] == 1) {
            $data[$controller->sufix('cover')] = null;
            $data[$controller->sufix('legend')] = null;
        }
        else if ($data[$controller->sufix('covertype')] == 2) {
            $cover = new \CoreSlim\Upload();
            $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
            $cover->dimensions([$this->imgx, $this->imgy]);
            $cover->loadBlob($controller->post($controller->sufix('cover')));

            if ($output = $cover->output('json')) {
                $data[$controller->sufix('cover')] = $output;
            }

            $data[$controller->sufix('legend')] = $controller->post($controller->sufix('legend'));
        }
        else if ($data[$controller->sufix('covertype')] == 3) {
            $data[$controller->sufix('cover')] = $controller->setVideoTemplate($controller->post($controller->sufix('video')));
            $data[$controller->sufix('legend')] = null;
        }

        $controller->dataSave($data, 'insert');

        return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->date($controller->sufix('date'), 'Data', $controller->processDate($controller->value('date'), 'brazil'));
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('category'), 'Categoria', $modules->inputSelectHtml('news-category', 'title', $controller->value('category')));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->radio($controller->sufix('covertype'), 'Tipo de Capa', intval($controller->value('covertype')), $this->form_covertype);

        switch ($controller->value('covertype')) {
            case 1:
                $stateImage = 'd-none';
                $stateVideo = 'd-none';
            break;

            case 2:
                $stateImage = null;
                $stateVideo = 'd-none';
            break;

            case 3:
                $stateImage = 'd-none';
                $stateVideo = null;
            break;
        }

        $page .= '<div id="cover-image" class="'.$stateImage.'">';
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('cover'), 'Imagem/Capa', $modules->getPhotoPageOnlyLinks($controller->value('cover'), 'cover'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->input($controller->sufix('legend'), 'Legenda', $controller->value('legend'), ['maxlength' => 250, 'required' => false]);
        $page .= '</div>';

        $page .= '<div id="cover-video" class="'.$stateVideo.'">';
        $page .= $forms->separate();
        $page .= $forms->video($controller->sufix('video'), 'URL Vídeo', $modules->getVideoTemplate($controller->value('cover'), 'cover'), ['required' => false]);
        $page .= '</div>';

        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('date') => $controller->post($controller->sufix('date'), 'date'),
            $controller->sufix('category') => $controller->post($controller->sufix('category')),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle')),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('covertype') => $controller->post($controller->sufix('covertype'), 'int'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $data[$controller->sufix('slug')] = $controller->getSlug($data[$controller->sufix('title')], false, 'slug', $data[$controller->sufix('date')]);

        if ($data[$controller->sufix('covertype')] == 1) {
            $data[$controller->sufix('cover')] = null;
            $data[$controller->sufix('legend')] = null;
        }
        else if ($data[$controller->sufix('covertype')] == 2) {
            $cover = new \CoreSlim\Upload();
            $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
            $cover->dimensions([$this->imgx, $this->imgy]);
            $cover->loadBlob($controller->post($controller->sufix('cover')));

            if ($output = $cover->output('json')) {
                $data[$controller->sufix('cover')] = $output;
            }

            $data[$controller->sufix('legend')] = $controller->post($controller->sufix('legend'));
        }
        else if ($data[$controller->sufix('covertype')] == 3) {
            $data[$controller->sufix('cover')] = $controller->setVideoTemplate($controller->post($controller->sufix('video')));
            $data[$controller->sufix('legend')] = null;
        }

    	$controller->dataSave($data, 'update');

    	return true;
	}

    public function importData()
    {
        \DeveloperSlim\Seeders\NewsSeeder::seed();
    }
}
