<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'events');

        $this->imgx = 1600;
        $this->imgy = 1200;
        $this->extension = 'jpg, png, gif';

        $this->setControl('seo', true);
        $this->setControl('photo', true);

        $this->setControl('controls_modules', true);
        $this->setControl('bt_frontend', true);
    }

    public function manage()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$modules->queryFilter."
                 WHERE ".$modules->queryStatus." ".$modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('date')."` DESC, `".$controller->sufix('hour')."` DESC";

        $thead = '
        <th width="1%" class="text-center">imagem</th>
        <th>evento</th>';

        $tbody = function ($result) use ($controller, $modules) {
            $dataTbody = '<td class="text-center">'.$modules->getPhotoPage($result[$controller->sufix('cover')], 'cover', null, null, false, true).'</td>';
            $dataTbody .= '<td><p>'.$controller->processDate($result[$controller->sufix('date')], 'brazil').' às '.$controller->processString($result[$controller->sufix('hour')], 'hour2digits').'</p><h5>'.$controller->processString($result[$controller->sufix('title')]).'</h5></td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->date($controller->sufix('date'), 'Data', date('d/m/Y'));
        $page .= $forms->hour($controller->sufix('hour'), 'Horário', $controller->value('hour', 'hour2digits'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('cover'), 'Foto principal', null, ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::insert($controller, $page);
    }

    public function module_insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('date') => $controller->post($controller->sufix('date'), 'date'),
            $controller->sufix('hour') => $controller->post($controller->sufix('hour')),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $cover = new \CoreSlim\Upload();
        $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
        $cover->dimensions([$this->imgx, $this->imgy]);
        $cover->loadBlob($controller->post($controller->sufix('cover')));

        if ($output = $cover->output('json')) {
            $data[$controller->sufix('cover')] = $output;
        }

        $controller->dataSave($data, 'insert');

        return true;
    }

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->date($controller->sufix('date'), 'Data', $controller->processDate($controller->value('date'), 'brazil'));
        $page .= $forms->hour($controller->sufix('hour'), 'Horário', $controller->value('hour', 'hour2digits'));
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('subtitle'), 'Chamada', $controller->value('subtitle'), ['required' => false, 'maxlength' => 300]);
        $page .= $forms->separate();
        $page .= $forms->textarea($controller->sufix('text'), 'Texto', $controller->value('text', 'text'), ['required' => false]);
        $page .= $forms->separate();
        $page .= $forms->uploadCrop($controller->sufix('cover'), 'Foto principal', $modules->getPhotoPageOnlyLinks($controller->value('cover'), 'cover'), ['required' => false, 'extension' => $this->extension, 'width' => $this->imgx, 'height' => $this->imgy]);
        $page .= $forms->separate();
        $page .= $forms->select($controller->sufix('status'), 'Status', $modules->getInputSelectStatus($controller->value('status')), ['input_col' => 'col-md-4']);

        return ToolsTemplate::update($controller, $page);
    }

    public function module_update()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('date') => $controller->post($controller->sufix('date'), 'date'),
            $controller->sufix('hour') => $controller->post($controller->sufix('hour')),
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('slug') => $controller->getSlug($controller->post($controller->sufix('title'))),
            $controller->sufix('subtitle') => $controller->post($controller->sufix('subtitle'), 'text'),
            $controller->sufix('text') => $controller->post($controller->sufix('text'), 'text'),
            $controller->sufix('status') => $controller->post($controller->sufix('status'))
        ];

        $cover = new \CoreSlim\Upload();
        $cover->config($controller->sufix('cover'), $modules->key, $controller->linkSystem());
        $cover->dimensions([$this->imgx, $this->imgy]);
        $cover->loadBlob($controller->post($controller->sufix('cover')));

        if ($output = $cover->output('json')) {
            $data[$controller->sufix('cover')] = $output;
        }

        $controller->dataSave($data, 'update');

        return true;
    }

    public function importData()
    {
        \DeveloperSlim\Seeders\EventsSeeder::seed();
    }
}
