<?php

class ModuleDoop extends ModuleMaster
{
    public function __construct($controller, $operation = 'manage', $key = null)
    {
        parent::__construct($controller, $operation, 'banners-type');
	}

    public function manage()
    {
        $controller = $this->controller();

        $query = "SELECT * FROM `".$controller->getTable()."`
                 ".$controller->modules->queryFilter."
                 WHERE ".$controller->modules->queryStatus." ".$controller->modules->querySearch."
                 GROUP BY `".$controller->sufix('id')."`
                 ORDER BY `".$controller->sufix('order')."`";

        $thead = '
        <th>tipo</th>
        <th>dimensão</th>';

        $tbody = function ($result) use ($controller) {
            $dataTbody = '
            <td>
                <p>'.$controller->processString($result[$controller->sufix('title')]).'</p>
            </td>';

            $dataTbody .= '
            <td>
                <p>'.$controller->processString($result[$controller->sufix('width')]).'x'.$controller->processString($result[$controller->sufix('height')]).'px</p>
            </td>';

            return $dataTbody;
        };

        return ToolsTemplate::manage($controller, $query, $thead, $tbody);
    }

    public function insert()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('width'), 'Largura', $controller->value('width'), ['type' => 'number', 'input_group_label' => 'px', 'input_group_rtl' => true]);
        $page .= $forms->input($controller->sufix('height'), 'Altura', $controller->value('height'), ['type' => 'number', 'input_group_label' => 'px', 'input_group_rtl' => true]);

        return ToolsTemplate::insert($controller, $page);
    }

	public function module_insert()
	{
        $controller = $this->controller();
        $modules = $this->modules();

		$data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('width') => intval($controller->post($controller->sufix('width'))),
            $controller->sufix('height') => intval($controller->post($controller->sufix('height'))),
            $controller->sufix('order') => $controller->generatorOrder()
        ];

		$controller->dataSave($data, 'insert');

		return true;
	}

    public function update()
    {
        $controller = $this->controller();
        $modules = $this->modules();
        $forms = $this->forms();

        $page = $forms->input($controller->sufix('title'), 'Título', $controller->value('title'));
        $page .= $forms->input($controller->sufix('width'), 'Largura', $controller->value('width'), ['type' => 'number', 'input_group_label' => 'px', 'input_group_rtl' => true]);
        $page .= $forms->input($controller->sufix('height'), 'Altura', $controller->value('height'), ['type' => 'number', 'input_group_label' => 'px', 'input_group_rtl' => true]);
        $page .= $forms->separate();
        $page .= $forms->input($controller->sufix('order'), 'Ordem', $controller->value('order'), ['type' => 'number']);

        return ToolsTemplate::update($controller, $page);
    }

	public function module_update()
	{
        $controller = $this->controller();
        $modules = $this->modules();

        $data = [
            $controller->sufix('title') => $controller->post($controller->sufix('title')),
            $controller->sufix('width') => intval($controller->post($controller->sufix('width'))),
            $controller->sufix('height') => intval($controller->post($controller->sufix('height'))),
            $controller->sufix('order') => intval($controller->post($controller->sufix('order'))),
        ];

		$controller->dataSave($data, 'update');

		return true;
	}
}
