<?php
// doopSites v1.9.7 - Última atualização 24/05/2023 17:10

class ToolsTemplate
{
    public static function getBase($controller)
    {
        $html = ToolsTemplate::mainHeader($controller);
        $html .= ToolsTemplate::aside($controller);

        $breadcrumb = self::getBreadcrumb($controller);

        $base = $controller->get('base');
        $operation = $controller->get('operation');

        if (!$base) {
            $page = include(config('app.ROOT_CMS_SYSTEM').'/cms_dashboard.php');
        }
        else if ($base && $operation) {
            if (file_exists(config('app.ROOT_CMS').'/'.$base.'/class.module.php')) {
                require_once(config('app.ROOT_CMS').'/'.$base.'/class.module.php');

                $module = new ModuleDoop($controller, $operation);
                $module->breadcrumb = $breadcrumb;

                if ($typeAction = $controller->post($operation.'_action_form')) {
                    if (method_exists($module, 'module_'.$operation)) {
                        $post = $module->{'module_'.$operation}();

                        self::redirect($controller, $post, $typeAction, $operation);
                    }
                }
                else {
                    $page = $module->{$operation}();
                }

                $breadcrumb = self::executeBreadcrumb($module->breadcrumb, $controller);
            }

            if ($base == 'helpers' && $operation = 'modulesInfo') {
                if (file_exists(config('app.ROOT_CMS').'/'.$base.'/'.$operation.'.php')) {
                    $page = include(config('app.ROOT_CMS').'/'.$base.'/'.$operation.'.php');
                }
            }
        }

        $html .= '
        <div class="content-wrapper">
            <div class="content-header">
                <div class="container-fluid">
                    <div class="row">';
                        if (isset($page['htmlHeader'])) {
                            $html .= '
                            <div class="col-sm-6">
                                '.$page['htmlHeader'].'
                            </div>';
                        }

                        $html .= '
                        <div class="col-sm-6">
                            '.$breadcrumb->html.'
                        </div>
                    </div>
                </div>
            </div>';

            if (isset($page['htmlPage'])) {
                $html .= $page['htmlPage'];
            }
        $html .= '
        </div>
        <footer class="main-footer">
        <b>Copyright © '.config('app.DATEFOUNDATION').'-'.date('Y').' <a href="'.config('app.SITE_AUTHOR').'" target="_blank">'.config('app.LABEL_SYSTEM_AUTHORMIN').'</a>.</b>
        Todos direitos reservados.
        <div class="float-right d-none d-sm-inline-block">
        <b>Versão:</b> '.config('app.LABEL_SYSTEM_VERSION').'
        </div>
        </footer>';

        print_r($html);
    }

    public static function redirect($controller, $post, $typeAction, $operation)
    {
        if ($post && $operation == 'insert') {
            if ($typeAction === 'cadastrar') {
                if (is_array($post)) {
                    if (!array_key_exists(2, $post)) {
                        $idLast = $controller->dataLast;
                    }
                    else {
                        $idLast = $post[2];
                    }

                    header('Location: '.$controller->pathLang(null, $controller->modules->page[$post[0]]['path'].'&uuid='.$idLast.'&callback=300'.'#'.$post[1]));
                    exit;
                }

                header('Location: '.$controller->pathLang(null, $controller->modules->page['insert']['path'].'&callback=300'));
                exit;
            }
            else {
                $old = $_SESSION['old-url'];

                unset($_SESSION['old-url']);

                header('Location: '.$controller->pathPreservLink($old, [['callback' => '300']]));
                exit;
            }
        }
        else if ($post && $operation === 'update') {
            if ($typeAction === 'salvar') {
                $pathCallback = $controller->pathLang(null, $controller->modules->page['update']['path'].'&uuid='.$controller->value('uuid').'&callback=301');

                header('Location: '.$pathCallback);
                exit;
            }
            else {
                $old = $_SESSION['old-url'];

                unset($_SESSION['old-url']);

                header('Location: '.$controller->pathPreservLink($old, [['callback' => '301']], ['uuid' => false]));
                exit;
            }
        }
    }

    public static function getBreadcrumb($controller)
    {
        $breadcrumb = new BreadcrumbDoop($controller->modules->modulesSystem);

        return $breadcrumb;
    }

    public static function executeBreadcrumb($breadcrumb, $controller)
    {
        $langBreadcrumb = null;

        if (count($controller->language) >= 2) {
            $langBreadcrumb = $controller->modules->langBreadcrumb;
        }

        $breadcrumb->html = $breadcrumb->viewBreadcrumb($langBreadcrumb);

        return $breadcrumb;
    }

    public static function mainHeader($controller)
    {
        $alertMenuBox = self::alertMenuBox($controller);

        $template = '
        <nav class="main-header navbar navbar-expand navbar-white navbar-light">
            <ul class="navbar-nav">
                <li class="nav-item">
                    <a class="nav-link" data-widget="pushmenu" href="#" role="button" title="Menu"><i class="fas fa-bars"></i></a>
                </li>
            </ul>

            <ul class="navbar-nav ml-auto">';
                if ($alertMenuBox['total'] > 0) {
                    $template .= '
                    <li class="nav-item dropdown mr-2">
                        <a class="nav-link" data-toggle="dropdown" href="#">
                            <i class="far fa-bell"></i>
                            <span class="badge badge-warning navbar-badge">'.$alertMenuBox['total'].'</span>
                        </a>

                        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right">
                            <span class="dropdown-item dropdown-header">'.$alertMenuBox['total_label'].'</span>';

                            foreach ($alertMenuBox['stats'] as $keyStats => $valueStats) {
                                $template .= '
                                <div class="dropdown-divider"></div>

                                <a href="'.$valueStats['link'].'" class="dropdown-item">
                                    <i class="fas fa-envelope mr-2"></i>'.$valueStats['title'].' ('.$valueStats['total'].')
                                </a>';
                            }
                        $template .= '
                        </div>
                    </li>';
                }

                $lang = $controller->language;

                if (count($lang) >= 2) {
                    foreach ($lang as $key => $value) {
                        $active = null;

                        if ($controller->lang() == $key) {
                            $active = ' class="active"';
                        }

                        $template .= '
                        <li class="nav-item'.$active.'">
                            <a class="nav-link nav-link-lang pl-0" href="'.$controller->pathlang($key, null).'" title="Idioma: '.$value['title'].'">
                                <img src="'.assets_img('flags/'.$value['flag'].'.png', 'src').'" class="img-fluid" alt="Idioma: '.$value['title'].'">
                            </a>
                        </li>';
                    }
                }

                $template .= '
                <li class="nav-item">
                    <a href="'.config('app.BASE_PATH').'" class="nav-link pl-0" target="_blank" title="Acessar o site"><i class="fas fa-globe"></i></a>
                </li>

                <li class="nav-item">
                    <a href="'.config('app.PATH_SYSTEM').'system/administrator&operation=account" class="nav-link pl-0" title="Minha conta">
                        <i class="far fa-user-circle"></i>
                    </a>
                </li>

                <li class="nav-item nav-item-fullscreen">
                    <a class="nav-link pl-0" data-widget="fullscreen" href="#" role="button">
                        <i class="fas fa-expand-arrows-alt"></i>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="'.config('app.PATH_CMS').'/login/?action=logout" class="nav-link pl-0" title="Sair">
                        <i class="fas fa-sign-out-alt"></i>
                    </a>
                </li>
            </ul>
        </nav>';

        return $template;
    }

    public static function alertMenuBox($controller)
    {
        $modulesMonitor = [
            'contact' => [
                'module' => 'module/contact',
                'table' => 'ex_contact',
                'sufix' => 'contact'
            ],
            'work' => [
                'module' => 'module/work',
                'table' => 'ex_work',
                'sufix' => 'work'
            ],
            'budget' => [
                'module' => 'module/budget',
                'table' => 'ex_budget',
                'sufix' => 'budget'
            ],
            'protocol' => [
                'module' => 'module/protocol',
                'table' => 'ex_protocol',
                'sufix' => 'protocol'
            ]
        ];

        $total = 0;
        $result = null;

        foreach ($controller->modules->modulesSystem as $key => $value) {
            if ($controller->modules->nivel($key) && $value['type'] == 'primary-system') {
               if ($controller->checkTable($value['table'])) {
                    $query = "SELECT `id_".$value['sufix']."` as id, `name_".$value['sufix']."` as name, `time_".$value['sufix']."` as time
                              FROM `".$value['table']."`
                              WHERE `read_".$value['sufix']."` = '0'
                              ORDER BY `time_".$value['sufix']."` DESC";

                    $fetch = $controller->dbFetchAll($query);

                    if ($fetch) {
                        $result[$key] = $fetch;

                        if ($result[$key]) {
                            $total = $total + count($result[$key]);
                        }
                    }
                }
            }
        }

        $returnVars['total'] = $total;
        $returnVars['data'] = $result;
        $returnVars['stats'] = [];

        if (is_array($returnVars['data'])) {
            foreach ($returnVars['data'] as $key => $value) {
                if (isset($controller->modules->modulesSystem[$key])) {
                    $returnVars['stats'][$key]['title'] = $controller->modules->modulesSystem[$key]['title'];
                    $returnVars['stats'][$key]['total'] = count($returnVars['data'][$key]);
                    $returnVars['stats'][$key]['link'] = $controller->link($key);
                }
            }
        }

        if ($total == 0) {
            $returnVars['total_label'] = 'Nenhuma notificação';
        }
        else if ($total == 1) {
            $returnVars['total_label'] = '1 nova notificação';
        }
        else {
            $returnVars['total_label'] = $returnVars['total'].' novas notificações';
        }

        return $returnVars;
    }

    public static function aside($controller)
    {
        $template = '
        <aside class="main-sidebar sidebar-dark-primary elevation-4">
            <a href="'.config('app.PATH_CMS_DASHBOARD').'" class="brand-link">
                <img src="'.assets_img('favicon.png', 'painel').'" alt="'.config('app.LABEL_SYSTEM_NAME').'" class="brand-image">
                <span class="brand-text font-weight-light">'.config('app.LABEL_SYSTEM_LOGO').'</span>
            </a>

            <div class="sidebar">
                <div class="form-inline mt-3">
                    <div class="input-group" data-widget="sidebar-search">
                        <input class="form-control form-control-sidebar" type="search" placeholder="Pesquisar no menu..." aria-label="Pesquisar no menu...">

                        <div class="input-group-append">
                            <button class="btn btn-sidebar">
                                <i class="fas fa-search fa-fw"></i>
                            </button>
                        </div>
                    </div>
                </div>

                <nav class="mt-2">
                    <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="true">
                        <li class="nav-item">
                            <a href="'.config('app.PATH_CMS_DASHBOARD').'" title="Dashboard" class="nav-link">
                                <i class="nav-icon fas fa-tachometer-alt"></i>
                                <p>Dashboard</p>
                            </a>
                        </li>';

                        $menu = $controller->modules->menu('modules');

                        if ($menu) {
                            if (isset($menu['primary'])) {
                                $classFirstGroup = '';

                                if (!$controller->get('base')) {
                                    $classFirstGroup = 'menu-is-opening menu-open';
                                }

                                $classPrimary = 'nav-link';

                                if ($menu['primary']['selected'] == true || !$controller->get('base')) {
                                    $classPrimary = 'nav-link';
                                    $classFirstGroup = 'menu-is-opening menu-open';
                                }

                                $template .= '
                                <li class="nav-item '.$classFirstGroup.'">
                                    <a href="#" class="'.$classPrimary.'">
                                        <i class="nav-icon '.$menu['primary']['icon'].'"></i>
                                        <p>'.$menu['primary']['title'].' <i class="right fas fa-angle-left"></i></p>
                                    </a>

                                    <ul class="nav nav-treeview">';
                                        foreach ($menu['primary']['sub'] as $keyPrimary => $valuePrimary) {
                                            $classMenuLink = 'nav-link';

                                            if ($valuePrimary['selected'] == true) {
                                                $classMenuLink = 'nav-link active';
                                            }

                                            $template .= '
                                            <li class="nav-item">
                                                <a href="'.$valuePrimary['url'].'" title="'.$controller->processString($valuePrimary['title']).'" class="'.$classMenuLink.'">';
                                                    if (isset($valuePrimary['icon'])) {
                                                        $template .= '<i class="nav-icon '.$valuePrimary['icon'].'"></i>';
                                                    }
                                                    else {
                                                        $template .= '<span class="icon-fallback mr-2 ml-2">-</span>';
                                                    }

                                                    $template .= '<p>'.$controller->processString($valuePrimary['label']).'</p>
                                                </a>
                                            </li>';
                                        }
                                    $template .= '
                                    </ul>
                                </li>';
                            }

                            if (array_key_exists('group', $menu)) {
                                foreach ($menu['group'] as $keyPrimary => $valueGroups) {
                                    $classMenuGroup = 'nav-item';
                                    $classMenuLink = 'nav-link';

                                    if ($valueGroups['selected'] == true) {
                                        $classMenuGroup = 'nav-item menu-open';
                                        $classMenuLink = 'nav-link';
                                    }

                                    $template .= '
                                    <li class="'.$classMenuGroup.'">
                                        <a href="#" class="'.$classMenuLink.'">';
                                            if (isset($valueGroups['icon'])) {
                                                $template .= '<i class="nav-icon '.$valueGroups['icon'].'"></i>';
                                            }

                                            $template .= '
                                            <p>'.$valueGroups['title'].'<i class="right fas fa-angle-left"></i></p>
                                        </a>

                                        <ul class="nav-treeview">';
                                            foreach ($valueGroups['sub'] as $keyGroup => $valueGroup) {
                                                $classMenuLink = 'nav-link';

                                                if ($valueGroup['selected'] == true) {
                                                    $classMenuLink = 'nav-link active';
                                                }

                                                $template .= '
                                                <li class="nav-item">
                                                    <a href="'.$valueGroup['url'].'" title="'.$controller->processString($valueGroup['title']).'" class="'.$classMenuLink.'">';
                                                        if (isset($valueGroup['icon'])) {
                                                            $template .= '<i class="nav-icon '.$valueGroup['icon'].'"></i>';
                                                        }
                                                        else {
                                                            $template .= '<span class="icon-fallback mr-2 ml-2">-</span>';
                                                        }

                                                        $template .= '
                                                        <p>'.$controller->processString($valueGroup['title']).'</p>
                                                    </a>
                                                </li>';
                                            }
                                        $template .= '
                                        </ul>
                                    </li>';
                                }
                            }
                        }
                    $template .= '
                    </ul>
                </nav>
            </div>
        </aside>';

        return $template;
    }

    public static function manage($module, $query, $thead, $tbody, $page = [])
    {
        if (!$module->checkTable($module->dataTable)) {
            $module->toolsMaintenance->loadSqlModule();
        }

        if (!isset($page['htmlHeader'])) {
            $page['htmlHeader'] = $module->modules->htmlHeader();
        }

        if (isset($page['htmlButton'])) {
            $page['htmlButton'] = $module->modules->htmlButton(['onlyInsert' => true]);
        }
        else {
            $page['htmlButton'] = $module->modules->htmlButton();
        }

        if (!isset($page['pageItems'])) {
            $limit = 50;
        }
        else {
            $limit = intval($page['pageItems']);
        }

        $pagination = new \CoreSlim\PaginationGet([
            'locale' => null,
            'item' => $limit,
            'query' => $query
        ]);

        $queryData = $pagination->execute();

        if (!isset($page['htmlControl'])) {
            $htmlControlInjection = null;

            if (isset($page['htmlControlInjection'])) {
                $htmlControlInjection = $page['htmlControlInjection'];
            }

            $page['htmlControl'] = $module->modules->htmlControl($pagination->total, $htmlControlInjection);
        }

        if (!isset($page['htmlSearch'])) {
            $page['htmlSearch'] = $module->modules->htmlSearch();
        }

        $htmlPage = '<div class="actions-buttonsTop-table mb-4">';
        $htmlPage .= '<div class="content-commands">'.$page['htmlControl']['commandsCallback'].$page['htmlControl']['commands'].'</div>';
        $htmlPage .= '<div class="content-commands-system">';
        //$htmlPage .= $page['htmlSearch'];
        //$htmlPage .= self::navigation($pagination->total, $pagination->navigation());
        $htmlPage .= '</div>';
        $htmlPage .= '</div>';

        if ($pagination->total > 0) {
            $htmlBody = '';

            $all = $module->dbFetchAll($pagination->execute());

            if (is_array($all)) {
                foreach ($all as $key => $result) {
                    if (!isset($result[$module->sufix('uuid')])) {
                        $module->createUUID($result[$module->sufix('id')]);
                    }

                    $htmlBody .= '<tr>';

                    if (!isset($page['tableCheckLine']) && isset($result[$module->sufix('id')])) {
                        $htmlBody .= '
                        <td width="1%" class="text-center">
                            <div class="form-group">
                                <div class="icheck-primary">
                                    <input id="select_one_'.$result[$module->sufix('uuid')].'" type="checkbox" name="select_one[]" value="'.$result[$module->sufix('uuid')].'">
                                    <label for="select_one_'.$result[$module->sufix('uuid')].'"></label>
                                </div>
                            </div>
                        </td>';
                    }
                    else {
                        $tableCheckLineNo = true;
                    }

                    $htmlBody .= $tbody($result);

                    if (!isset($page['tableOrder']) && isset($result[$module->sufix('order')])) { $htmlBody .= '<td class="text-center">'.intval($result[$module->sufix('order')]).'</td>'; } else { $tableOrderNo = true; }
                    if (!isset($page['tableView']) && isset($result[$module->sufix('view')])) { $htmlBody .= '<td class="text-center">'.$module->modules->getViews($result[$module->sufix('view')]).'</td>';  } else { $tableViewNo = true; }
                    if (!isset($page['tableStatus']) && isset($result[$module->sufix('status')])) { $htmlBody .= '<td class="text-center">'.$module->modules->getTagStatus($result[$module->sufix('status')]).'</td>';  } else { $tableStatusNo = true; }
                    if (!isset($page['tableControls'])) { $htmlBody .= '<td class="text-center">'.$module->modules->htmlActionUnique($result).'</td>'; } else { $tableControlsNo = true; }

                    $htmlBody .= '</tr>';
                }
            }

            $htmlPage .= '
            <form name="manage_form" method="post" action="'.$module->linkSystem().'">
                <div class="table-responsive">
                    <table class="table table-hover table-doop">
                        <thead>
                            <tr>';
                                if (!isset($page['checkLine']) && !isset($tableCheckLineNo)) {
                                    $htmlPage .= '
                                    <th width="1%" class="text-center">
                                        <div class="icheck-primary">
                                            <input id="checkForAll" type="checkbox" title="Selecionar todos">
                                            <label for="checkForAll"></label>
                                        </div>
                                    </th>';
                                }

                                $htmlPage .= $thead;

                                if (!isset($page['tableOrder']) && !isset($tableOrderNo)) { $htmlPage .= '<th width="1%" class="text-center"><i class="fa fa-list-ol" title="Ordem"></i></th>'; }
                                if (!isset($page['tableView']) && !isset($tableViewNo)) { $htmlPage .= '<th width="1%" class="text-center"><i class="fa fa-eye" title="Visualizações"></i></th>'; }
                                if (!isset($page['tableStatus']) && !isset($tableStatusNo)) { $htmlPage .= '<th width="1%" class="text-center"><i class="fa fa-flag" title="Status"></i></th>'; }
                                if (!isset($page['tableControls']) && !isset($tableControlsNo)) { $htmlPage .= '<th width="8%" class="text-center"><i class="fa fa-cubes" title="Controles"></i></th>'; }

                            $htmlPage .= '
                            </tr>
                        </thead>

                        <tbody>'.$htmlBody.'</tbody>
                    </table>
                </div>
            </form>';

            $htmlPagination = self::navigation($pagination->total, $pagination->navigation(), 'm-0');
        }
        else {
            $htmlPage .= '<div class="alert alert-warning mb-0">Nenhum registro encontrado!</div>';
            $htmlPagination = null;
        }

        $page['htmlPage'] = '
        <section class="content">
            <div class="container-fluid">';
                $page['htmlPage'] .= '
                <div class="card card-default card-doop">';
                    if (isset($page['htmlButton']) || isset($page['htmlSearch']) || isset($page['htmlControl']['total'])) {
                        $page['htmlPage'] .= '
                        <div class="card-header">
                            <div class="card-buttons">
                                '.$page['htmlButton'].$page['htmlSearch'].'
                            </div>

                            <div class="card-title"><span class="badge badge-dark">'.$page['htmlControl']['total'].'</span></div>

                            <div class="card-tools">
                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                    <i class="fas fa-minus"></i>
                                </button>
                            </div>
                        </div>';
                    }

                    $page['htmlPage'] .= '
                    <div class="card-body" style="display: block;">
                        '.$htmlPage.'
                    </div>';

                    if ($htmlPagination) {
                        $page['htmlPage'] .= '
                        <div class="card-footer">
                            '.$htmlPagination.'
                        </div>';
                    }

                $page['htmlPage'] .= '
                </div>
            </div>
        </section>';

        return $page;
    }

    public static function insert($module, $forms, $page = [])
    {
        if (!isset($page['htmlHeader'])) {
            $page['htmlHeader'] = $module->modules->htmlHeader();
        }

        $htmlPage = '
        <section class="content">
            <div class="container-fluid">';
                $htmlPage .= '
                <div class="card card-primary card-outline">
                    <div class="card-body">
                        <form name="insert_form" class="form-horizontal form-validate" method="post" action="'.$module->linkSystem().'" enctype="multipart/form-data">';
                            $htmlPage .= $forms;

                            $htmlPage .= $module->forms->separate();
                            $htmlPage .= '<div class="text-center">'.$module->modules->htmlButton().'</div>';

                        $htmlPage .= '
                        </form>
                    </div>
                </div>
            </div>
        </section>';

        $page['htmlPage'] = $htmlPage;

        return $page;
    }

    public static function update($module, $forms, $page = [])
    {
        if (!isset($page['htmlHeader'])) {
            $page['htmlHeader'] = $module->modules->htmlHeader();
        }

        $htmlPage = '
        <section class="content">
            <div class="container-fluid">';
                $htmlPage .= '
                <div class="card card-primary card-outline card-outline-tabs">
                    <div class="card-header p-0 border-bottom-0">
                        <ul class="nav nav-tabs" id="tab_update" role="tablist">
                            '.$module->modules->navBarsUpdateTop().'
                        </ul>
                    </div>

                    <div class="card-body">
                        <div class="tab-content" id="tab_updateContent">
                            <div id="data-content" class="tab-pane">
                                <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$module->linkSystem().'" enctype="multipart/form-data">';
                                    $htmlPage .= $forms;

                                    $htmlPage .= $module->forms->separate();
                                    $htmlPage .= '<div class="text-center">'.$module->modules->htmlButton().'</div>';

                                $htmlPage .= '
                                </form>
                            </div>';

                            $bottons = $module->modules->navBarsUpdateBottom();

                            foreach ($bottons as $keyBottons => $valueBottons) {
                                $pageIn = include($valueBottons);

                                $htmlPage .= '<div id="'.$keyBottons.'-content" class="tab-pane">'.$pageIn.'</div>';
                            }
                            $htmlPage .= '
                        </div>
                    </div>
                </div>
            </div>
        </section>';

        $page['htmlPage'] = $htmlPage;

        return $page;
    }

    public static function page($module, $forms, $page = [])
    {
        if (!isset($page['htmlHeader'])) {
            $page['htmlHeader'] = $module->modules->htmlHeader();
        }

        $htmlPage = '
        <section class="content">
            <div class="container-fluid">';
                $htmlPage .= '
                <div class="card card-primary card-outline">
                    <div class="card-body">
                        '.$forms.'
                    </div>
                </div>
            </div>
        </section>';

        $page['htmlPage'] = $htmlPage;

        return $page;
    }

    public static function clean($module, $html, $page = [])
    {
        if (!isset($page['htmlHeader'])) {
            $page['htmlHeader'] = $module->modules->htmlHeader();
        }

        $htmlPage = '
        <section class="content">
            <div class="container-fluid">
                '.$html.'
            </div>
        </section>';

        $page['htmlPage'] = $htmlPage;

        return $page;
    }

    public static function navigation($total, $data, $class = 'mb-0')
    {
        if ($total > 0) {
            $html = '<ul class="pagination '.$class.'">';

            if ($data['prev']['class'] != 'disabled') {
                $html .= '<li class="page-item"><a class="page-link" href="'.$data['prev']['link'].'" title="Anterior"><i class="fa fa-angle-double-left"></i></a></li>';
            }
            else {
                $html .= '<li class="page-item disabled" title="Você está na primeira página"><a class="page-link" href="#"><i class="fa fa-angle-double-left"></i></a></li>';
            }

            foreach ($data['pages'] as $key => $value) {
                if ($value['class'] == 'active') {
                    $html .= '<li class="page-item active"><a class="page-link" href="#" title="Você está na página '.$value['title'].'">'.$value['title'].'</a></li>';
                }
                else {
                    $html .= '<li class="page-item"><a class="page-link" href="'.$value['link'].'" title="Página '.$value['title'].'">'.$value['title'].'</a></li>';
                }
            }

            if ($data['next']['class'] != 'disabled') {
                $html .= '<li class="page-item"><a class="page-link" href="'.$data['next']['link'].'" title="Próxima"><i class="fa fa-angle-double-right"></i></a></li>';
            }
            else {
                $html .= '<li class="page-item disabled" title="Você está na última página"><a class="page-link" href="#"><i class="fa fa-angle-double-right"></i></a></li>';
            }

            $html .= '</ul>';

            return $html;
        }
    }
}
