<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

require_once(config('app.ROOT_CMS_HELPERS').'/tools-images.php');

class ToolsMaintenanceDoop
{
    public $controller = null;
    public $module = null;

    public function __construct($module, $controller = false)
    {
        if ($controller) {
            $this->controller = $module;
        }
        else {
            $this->module = $module;
        }
    }

    public function controller()
    {
        if (property_exists($this, 'module') && !is_null($this->module)) {
            return $this->module->controller();
        }
        else if (property_exists($this, 'controller') && !is_null($this->controller)) {
            return $this->controller;
        }
    }

    public function modules()
    {
        return $this->controller()->modules;
    }

    public function monitor()
    {
        if (config('app.ENV') == 'development') {
            $controller = $this->controller();
            $modules = $this->modules();

            if ($controller->get('action') === 'truncateTable') {
                if (method_exists('ModuleDoop', 'truncateTable')) {
                    $controller->truncateTable();

                    header('Location: '.$this->pathLang(null, $modules->page['manage']['path'].'&callback=truncate_table'));
                    exit;
                }
                else {
                    $this->truncateTableController();
                }
            }

            if ($controller->get('action') === 'resetTable') {
                if (method_exists('ModuleDoop', 'resetTable')) {
                    $module = new ModuleDoop($controller, $controller->get('action'));
                    $module->resetTable();

                    $this->loadSqlModule();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=reset_table'));
                    exit;
                }
                else {
                    $this->resetTableController();
                }
            }

            if ($controller->get('action') === 'importData') {
                $file = $controller->pathModule().str_replace('-', '/', $modules->key).'/sampleData.sql';

                if (method_exists('ModuleDoop', $controller->get('action')) && !file_exists($file)) {
                    $module = new ModuleDoop($controller, $controller->get('action'));
                    $module->importData();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=import_data'));
                    exit;
                }
                else if (file_exists($file)) {
                    $this->truncateTableController(false);

                    $modules->importSql($file);

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=sample_data'));
                    exit;
                }
            }

            if ($controller->get('action') === 'exportData') {
                if (method_exists('ModuleDoop', 'exportData')) {
                    $controller->exportData();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=export_data'));
                    exit;
                }
                else {
                    $this->exportDataController();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=export_data'));
                    exit;
                }
            }

            if ($controller->get('action') === 'resetViewsTable') {
                if (method_exists('ModuleDoop', 'resetViewsTable')) {
                    $controller->resetViewsTable();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=reset_views_table'));
                    exit;
                }
                else {
                    $this->resetViewsTableController();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=reset_views_table'));
                    exit;
                }
            }

            if ($controller->get('action') === 'deleteGhostFiles') {
                if (method_exists('ModuleDoop', 'deleteGhostFiles')) {
                    $controller->deleteGhostFiles();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=delete_ghosts_files'));
                    exit;
                }
                else {
                    $this->deleteGhostFilesController();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=delete_ghosts_files'));
                    exit;
                }
            }

            if ($controller->get('action') === 'convertWebp') {
                if (method_exists('ModuleDoop', 'convertWebp')) {
                    $controller->convertWebp();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=convert_webp_success'));
                    exit;
                }
                else {
                    $toolsImages = new ToolsImagesDoop($this);

                    $toolsImages->convertWebpFeature();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=convert_webp_success'));
                    exit;
                }
            }

            if ($controller->get('action') === 'restoreWebp') {
                if (method_exists('ModuleDoop', 'restoreWebp')) {
                    $controller->restoreWebp();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=restore_webp_success'));
                    exit;
                }
                else {
                    $toolsImages = new ToolsImagesDoop($this);

                    $toolsImages->restoreWebpFeature();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=restore_webp_success'));
                    exit;
                }
            }

            if ($controller->get('action') === 'deleteWebp') {
                if (method_exists('ModuleDoop', 'deleteWebp')) {
                    $controller->deleteWebpFeature();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=delete_webp_success'));
                    exit;
                }
                else {
                    $toolsImages = new ToolsImagesDoop($this);

                    $toolsImages->deleteWebpFeature();

                    header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=delete_webp_success'));
                    exit;
                }
            }
        }
    }

    public function truncateTableController($action = true, $table = null)
    {
        $controller = $this->controller();
        $modules = $this->modules();

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        $controller->dbQuery("TRUNCATE TABLE `".$table."`");

        if ($action) {
            header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=truncate_table'));
            exit;
        }

        return true;
    }

    public function resetTableController($action = true, $table = null)
    {
        $controller = $this->controller();
        $modules = $this->modules();

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        $controller->dbQuery("DROP TABLE `".$table."`");

        $this->loadSqlModule();

        if ($action) {
            header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=reset_table'));
            exit;
        }

        return true;
    }

    public function loadSqlModule($file = 'defaultData')
    {
        $controller = $this->controller();
        $modules = $this->modules();

        if (isset($modules->key)) {
            $key = str_replace('-', '/', $modules->key);

            $defaultData = $controller->pathModule().$key.'/'.$file.'.sql';
        }

        if (file_exists($defaultData)) {
            $modules->importSql($defaultData);
        }
    }

    public function resetViewsTableController($table = null)
    {
        $controller = $this->controller();
        $modules = $this->modules();

        if (is_null($table)) {
            $table = $controller->getTable();
        }

        $controller->dbQuery("UPDATE `".$table."` SET `".$controller->sufix('view')."` = '0'");

        return true;
    }

    public function prepareQueryExternal($key, $table, $tupleCheck)
    {
        $queryExternal = null;

        $fields = $this->controller()->dbFields("SELECT * FROM `".$table."`");

        foreach ($fields as $fieldsValue) {
            if (in_array($this->controller()->unsufix($fieldsValue['name']), $tupleCheck)) {
                $queryExternal[] = "SELECT `id_".$key."` as id, `".$this->controller()->unsufix($fieldsValue['name'])."_".$key."` as parameter FROM `".$table."` WHERE `".$this->controller()->unsufix($fieldsValue['name'])."_".$key."` LIKE '%---fileNameSearch---%'";
            }
        }

        return $queryExternal;
    }

    public function deleteGhostFilesController()
    {
        $toolsImages = new ToolsImagesDoop($this);

        $toolsImages->deleteImagesNotDatabase();
        $toolsImages->deleteFilesNotDatabase();
    }

    public function exportDataController()
    {
        $controller = $this->controller();
        $modules = $this->modules();

        $dumpSettings = [
            'include-tables' => [
                $controller->getTable()
            ],
            'compress' => Ifsnop\Mysqldump\Mysqldump::NONE,

            'add-drop-table' => false,
            'add-locks' => false,
            'complete-insert' => true,

            'disable-keys' => true,
            'extended-insert' => false,
            'no-autocommit' => true,
            'no-create-info' => true,

            'lock-tables' => false,
            'single-transaction' => false,
            'skip-triggers' => true,
            'skip-tz-utc' => true,
            'skip-comments' => true,
            'skip-dump-date' => true,
            'skip-definer' => true
        ];

        $dump = new Ifsnop\Mysqldump\Mysqldump("mysql:host=".DB_HOST.";port=".DB_PORT.";dbname=".DB_DATABASE, DB_USER, DB_PASSWORD, $dumpSettings);

        $path = $controller->pathModule().str_replace('-', '/', $modules->key).'/sampleData.sql';

        $dump->start($path);

        header('Location: '.$controller->pathLang(null, $modules->page['manage']['path'].'&callback=backup_dump'));
        exit;
    }
}
