<?php

// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class ToolsImport
{
    private $controller = null;

    public $old = [
        'database' => null,
        'table' => null,
        'tuple' => null,
        'port' => 3306,
        'folder' => null
    ];

    public $new = [
        'database' => null,
        'table' => null,
        'tuple' => null,
        'port' => 3307,
        'folder' => null
    ];

    public $processUnique = true;

    public function __construct($controller)
    {
        $this->controller = $controller;
    }

    public function importGalleryAnexx()
    {
        $controller = $this->controller;
        $model = new ModelDoop($controller);
        $model->connectionOpen(null, null, null, $this->old['database'], $this->old['port']);

        if ($this->processUnique && $this->old['tuple']) {
            $query = "SELECT *
                      FROM `sub_anexx`
                      WHERE `table_anexx` = '".$this->old['table']."' AND
                            `tuple_anexx` = '".$this->old['tuple']."' AND
                            `status_anexx` <> 'deleted'
                      ORDER BY `time_anexx`";
        }
        else if (!$this->processUnique) {
            $query = "SELECT *
                      FROM `sub_anexx`
                      WHERE `table_anexx` = '".$this->old['table']."' AND
                            `status_anexx` <> 'deleted'
                      ORDER BY `time_anexx`";
        }

        $result = $model->dbFetchAll($query, null);

        $controller->modules->operation = 'insert';

        if (!is_dir($this->new['folder'])) {
            mkdir($this->new['folder'], 0777);
        }

        if (!is_dir($this->new['folder'].'/files')) {
            mkdir($this->new['folder'].'/files', 0777);
        }

        if ($result) {
            foreach ($result as $key => $value) {
                $file = json_decode($value['file_anexx'], true);
                $file['extension'] = mb_strtolower($file['extension']);

                $dataSave['id_anexx'] = $value['id_anexx'];
                $dataSave['table_anexx'] = $this->new['table'];

                if ($this->new['tuple']) {
                    $dataSave['tuple_anexx'] = intval($this->new['tuple']);
                }
                else {
                    $dataSave['tuple_anexx'] = intval($value['tuple_anexx']);
                }

                $dataSave['file_anexx'] = json_encode($file);
                $dataSave['legend_anexx'] = $value['legend_anexx'];
                $dataSave['order_anexx'] = $value['order_anexx'];
                $dataSave['user_anexx'] = $value['user_anexx'];
                $dataSave['time_anexx'] = $value['time_anexx'];
                $dataSave['status_anexx'] = $value['status_anexx'];

                $controller->setTable('sub_anexx');
                $controller->setSufix('anexx');
                $controller->dataSave($dataSave, 'insert', false, null, false);

                if (file_exists($this->old['folder'].'/'.$file['name']) && !file_exists($this->new['folder'].'/files/'.$file['name'])) {
                    copy($this->old['folder'].'/'.$file['name'], $this->new['folder'].'/files/'.$file['name']);
                }
            }
        }
    }

    public function importGalleryPhoto()
    {
        $controller = $this->controller;
        $model = new ModelDoop($controller);
        $model->connectionOpen(null, null, null, $this->old['database'], $this->old['port']);

        if ($this->processUnique && $this->old['tuple']) {
            $query = "SELECT *
                      FROM `sub_photo`
                      WHERE `table_photo` = '".$this->old['table']."' AND
                            `tuple_photo` = '".$this->old['tuple']."' AND
                            `status_photo` <> 'deleted'
                      ORDER BY `time_photo`";
        }
        else if (!$this->processUnique) {
            $query = "SELECT *
                      FROM `sub_photo`
                      WHERE `table_photo` = '".$this->old['table']."' AND
                            `status_photo` <> 'deleted'
                      ORDER BY `time_photo`";
        }

        $result = $model->dbFetchAll($query, null);

        $controller->modules->operation = 'insert';

        if (!is_dir($this->new['folder'])) {
            mkdir($this->new['folder'], 0777);
        }

        $folder = $this->new['folder'].'/images';

        if (!is_dir($folder)) {
            mkdir($folder, 0777);
        }

        if (!is_dir($folder.'/smaller')) {
            mkdir($folder.'/smaller', 0777);
        }

        if (!is_dir($folder.'/larger')) {
            mkdir($folder.'/larger', 0777);
        }

        if ($result) {
            foreach ($result as $key => $value) {
                $dataSave['id_photo'] = intval($value['id_photo']);
                $dataSave['table_photo'] = $value['table_photo'];

                if ($this->new['tuple']) {
                    $dataSave['tuple_photo'] = intval($this->new['tuple']);
                }
                else {
                    $dataSave['tuple_photo'] = intval($value['tuple_photo']);
                }

                $dataSave['legend_photo'] = $value['legend_photo'];
                $dataSave['credit_photo'] = $value['credit_photo'];
                $dataSave['order_photo'] = intval($value['order_photo']);
                $dataSave['user_photo'] = intval($value['user_photo']);
                $dataSave['time_photo'] = $value['time_photo'];
                $dataSave['status_photo'] = $value['status_photo'];

                if ($value['file_photo']) {
                    if (!@json_decode($value['file_photo'])) {
                        $file['name'] = $value['file_photo'];
                        $file['extension'] = 'jpg';
                        $realname = explode('.jpg', $file['name']);
                        $file['realname'] = $realname[0];
                        $file['mimetype'] = $value['mimetype_photo'];
                    }
                    else {
                        $file = json_decode($value['file_photo'], true);
                        $file['extension'] = mb_strtolower($file['extension']);
                    }

                    $dataSave['file_photo'] = json_encode($file);

                    if (file_exists($this->old['folder'].'/smaller/'.$file['name']) && !file_exists($folder.'/smaller/'.$file['name'])) {
                        copy($this->old['folder'].'/smaller/'.$file['name'], $folder.'/smaller/'.$file['name']);
                    }

                    if (file_exists($this->old['folder'].'/larger/'.$file['name']) && !file_exists($folder.'/larger/'.$file['name'])) {
                        copy($this->old['folder'].'/larger/'.$file['name'], $folder.'/larger/'.$file['name']);
                    }
                }

                $controller->setTable('sub_photo');
                $controller->setSufix('photo');
                $controller->dataSave($dataSave, 'insert', false, null, false);
            }
        }
    }

    public function importGalleryVideo()
    {
        $controller = $this->controller;
        $model = new ModelDoop($controller);
        $model->connectionOpen(null, null, null, $this->old['database'], $this->old['port']);

        if ($this->processUnique && $this->old['tuple']) {
            $query = "SELECT *
                      FROM `sub_video`
                      WHERE `table_video` = '".$this->old['table']."' AND
                            `tuple_video` = '".$this->old['tuple']."' AND
                            `status_video` <> 'deleted'
                      ORDER BY `time_video`";
        }
        else if (!$this->processUnique) {
            $query = "SELECT *
                      FROM `sub_video`
                      WHERE `table_video` = '".$this->old['table']."' AND
                            `status_video` <> 'deleted'
                      ORDER BY `time_video`";
        }

        $result = $model->dbFetchAll($query);

        $controller->modules->operation = 'insert';

        if ($result) {
            foreach ($result as $key => $value) {
                $tag['type'] = $value['type_video'];
                $tag['code'] = $value['tag_video'];

                $dataSave['id_video'] = $value['id_video'];
                $dataSave['table_video'] = $value['table_video'];

                if ($this->new['tuple']) {
                    $dataSave['tuple_video'] = intval($this->new['tuple']);
                }
                else {
                    $dataSave['tuple_video'] = intval($value['tuple_video']);
                }

                $dataSave['tag_video'] = json_encode($tag);
                $dataSave['legend_video'] = $value['legend_video'];
                $dataSave['credit_video'] = $value['credit_video'];
                $dataSave['order_video'] = $value['order_video'];
                $dataSave['user_video'] = $value['user_video'];
                $dataSave['time_video'] = $value['time_video'];
                $dataSave['status_video'] = $value['status_video'];

                $controller->setTable('sub_video');
                $controller->setSufix('video');
                $controller->dataSave($dataSave, 'insert', false, null, false);
            }
        }
    }

    public function importGalleryAudio()
    {
        $controller = $this->controller;
        $model = new ModelDoop($controller);
        $model->connectionOpen(null, null, null, $this->old['database'], $this->old['port']);

        if ($this->processUnique && $this->old['tuple']) {
            $query = "SELECT *
                      FROM `sub_audio`
                      WHERE `table_audio` = '".$this->old['table']."' AND
                            `tuple_audio` = '".$this->old['tuple']."' AND
                            `status_audio` <> 'deleteda'
                      ORDER BY `time_audio`";
        }
        else if (!$this->processUnique) {
            $query = "SELECT *
                      FROM `sub_audio`
                      WHERE `table_audio` = '".$this->old['table']."' AND
                            `status_audio` <> 'deleteda'
                      ORDER BY `time_audio`";
        }

        $result = $model->dbFetchAll($query);

        $controller->modules->operation = 'insert';

        if (!is_dir($this->new['folder'])) {
            mkdir($this->new['folder'], 0777);
        }

        $folder = $this->new['folder'].'/audios';

        if (!is_dir($folder)) {
            mkdir($folder, 0777);
        }

        if ($result) {
            foreach ($result as $key => $value) {
                $file = null;

                $dataSave['id_audio'] = $value['id_audio'];
                $dataSave['table_audio'] = $value['table_audio'];

                if ($this->new['tuple']) {
                    $dataSave['tuple_audio'] = intval($this->new['tuple']);
                }
                else {
                    $dataSave['tuple_audio'] = intval($value['tuple_audio']);
                }

                $dataSave['legend_audio'] = $value['legend_audio'];
                $dataSave['order_audio'] = $value['order_audio'];
                $dataSave['user_audio'] = $value['user_audio'];
                $dataSave['time_audio'] = $value['time_audio'];
                $dataSave['status_audio'] = $value['status_audio'];

                if ($value['file_audio']) {
                    if (!@json_decode($value['file_audio'])) {
                        $file['name'] = $value['file_audio'];
                        $file['extension'] = 'mp3';
                        $realname = explode('.mp3', $file['name']);
                        $file['realname'] = $realname[0];
                        $file['mimetype'] = $value['mimetype_audio'];
                    }
                    else {
                        $file = json_decode($value['file_audio'], true);
                        $file['extension'] = mb_strtolower($file['extension']);
                    }

                    $dataSave['file_audio'] = json_encode($file);

                    if (file_exists($this->old['folder'].'/'.$file['name']) && !file_exists($folder.'/'.$file['name'])) {
                        copy($this->old['folder'].'/'.$file['name'], $folder.'/'.$file['name']);
                    }
                }

                $controller->setTable('sub_audio');
                $controller->setSufix('audio');
                $controller->dataSave($dataSave, 'insert', false, null, false);
            }
        }
    }

    public function imageUnique($fileString, $nameString = null, $outputs = [])
    {
        if ($fileString && $fileString != '') {
            $cover = null;

            if (!@json_decode($fileString)) {
                $cover['name'] = $fileString;
                $cover['extension'] = strtolower(pathinfo($cover['name'], PATHINFO_EXTENSION));
                $realname = explode('.'.$cover['extension'], $fileString);
                $cover['realname'] = $nameString;
            }
            else {
                $cover = json_decode($fileString, true);
            }

            $folderOld = $this->old['folder'];
            $folderNew = $this->new['folder'].'/images';

            if (!is_dir($this->new['folder'])) {
                mkdir($this->new['folder'], 0777);
            }

            if (!is_dir($folderNew)) {
                mkdir($folderNew, 0777);
            }

            if (!is_dir($folderNew.'/default')) {
                mkdir($folderNew.'/default', 0777);
            }

            if (!is_dir($folderNew.'/thumb')) {
                mkdir($folderNew.'/thumb', 0777);
            }

            foreach ($outputs as $output) {
                switch ($output) {
                    case 'default':
                    case 'original':
                        if (file_exists($folderOld.'/'.$cover['name']) && !file_exists($folderNew.'/default/'.$cover['name'])) {
                            copy($folderOld.'/'.$cover['name'], $folderNew.'/default/'.$cover['name']);

                            $cover['mimetype'] = mime_content_type($folderNew.'/default/'.$cover['name']);
                        }
                    break;

                    case 'thumb':
                        if (!is_dir($folderNew.'/thumb')) {
                            mkdir($folderNew.'/thumb', 0777);
                        }

                        if (file_exists($folderOld.'/thumb/'.$cover['name']) && !file_exists($folderNew.'/thumb/'.$cover['name'])) {
                            copy($folderOld.'/thumb/'.$cover['name'], $folderNew.'/thumb/'.$cover['name']);

                            $cover['mimetype'] = mime_content_type($folderNew.'/thumb/'.$cover['name']);
                        }
                    break;

                    case 'smaller':
                        if (!is_dir($folderNew.'/smaller')) {
                            mkdir($folderNew.'/smaller', 0777);
                        }

                        if (file_exists($folderOld.'/smaller/'.$cover['name']) && !file_exists($folderNew.'/smaller/'.$cover['name'])) {
                            copy($folderOld.'/smaller/'.$cover['name'], $folderNew.'/smaller/'.$cover['name']);

                            $cover['mimetype'] = mime_content_type($folderNew.'/smaller/'.$cover['name']);
                        }
                    break;

                    case 'larger':
                        if (!is_dir($folderNew.'/larger')) {
                            mkdir($folderNew.'/larger', 0777);
                        }

                        if (file_exists($folderOld.'/larger/'.$cover['name']) && !file_exists($folderNew.'/larger/'.$cover['name'])) {
                            copy($folderOld.'/larger/'.$cover['name'], $folderNew.'/larger/'.$cover['name']);

                            $cover['mimetype'] = mime_content_type($folderNew.'/larger/'.$cover['name']);
                        }
                    break;
                }
            }

            return json_encode($cover);
        }

        return null;
    }

    public function fileUnique($fileString, $nameString = null)
    {
        if ($fileString && $fileString != '') {
            $file = null;

            if (!@json_decode($fileString)) {
                $file['name'] = $fileString;
                $file['extension'] = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
                $realname = explode('.'.$file['extension'], $fileString);
                $file['realname'] = $nameString;
            }
            else {
                $file = json_decode($fileString, true);
            }

            $folderOld = $this->old['folder'];
            $folderNew = $this->new['folder'].'/files';

            if (!is_dir($this->new['folder'])) {
                mkdir($this->new['folder'], 0777);
            }

            if (!is_dir($folderNew)) {
                mkdir($folderNew, 0777);
            }

            if (file_exists($folderOld.'/'.$file['name']) && !file_exists($folderNew.'/'.$file['name'])) {
                copy($folderOld.'/'.$file['name'], $folderNew.'/'.$file['name']);

                $file['mimetype'] = mime_content_type($folderNew.'/'.$file['name']);
            }

            return json_encode($file);
        }

        return null;
    }
}
