<?php
// doopSites v1.9.7 - Última atualização 30/11/2023 13:58

$moduleUrl = null;
if ($controller->get('module')) {
    $moduleUrl = '&module='.$controller->get('module');
}

$dataAutomatic = '
<section class="content">
    <div class="container-fluid">
        <form name="update_form" class="form-horizontal form-validate" method="post" action="'.$controller->pathlang(null, config('app.PATH_SYSTEM').$module->dataModule['base'].'&operation='.$module->operation.$moduleUrl).'" enctype="multipart/form-data">';

if ($module->dataAutomaticInputs) {
    foreach ($module->dataAutomaticInputs as $key => $value) {
        if ($module->modules->checkPrivilege($value['privilege'])) {
            $data = null;

            if ($value['type'] != 'separator' && $value['type'] != 'divider') {
                if ($module->dataAutomatic && array_key_exists($value['key'], $module->dataAutomatic)) {
                    if (array_key_exists($value['value'], $module->dataAutomatic[$value['key']])) {
                        $data = $module->dataAutomatic[$value['key']][$value['value']];
                    }
                }
            }

            if ($value['type'] == 'separator') {
                $keyIn = 'separator-'.$key;
                $valueIn = uniqid();
            }
            else if (isset($value['key']) && isset($value['value'])) {
                $keyIn = $value['key'];
                $valueIn = $value['value'];
            }
            else if (!isset($keyIn) && !isset($valueIn)) {
                $keyIn = uniqid();
                $valueIn = uniqid();
            }

            $keyOperationUnique = $keyIn.'_'.$valueIn.'_'.$module->operation;

            if ($value['type'] == 'upload') {
                $cover = null;

                if ($data) {
                    $dataAutomatic .= '
                    <div class="row form-group">
                        <label class="col-md-3 col-form-label">'.$value['title'].'</label>
                        <div class="col-md-3">
                            '.$module->imgSerialize($data, $module->pathLang(null, config('app.PATH_SYSTEM').$module->dataModule['base'].'&operation='.$module->operation), [$value['key'], $value['value']], $module->dataModule['key']).'
                        </div>
                    </div>';
                }

                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$keyOperationUnique.'">'.$value['title'].'</label>

                    <div class="col-md-6">
                        <div class="custom-file">
                            <input type="file" id="'.$keyOperationUnique.'" name="'.$keyOperationUnique.'" class="custom-file-input" />
                            <label class="custom-file-label" for="'.$keyOperationUnique.'" data-browse="SELECIONAR">Nenhum arquivo selecionado</label>
                        </div>
                    </div>

                    <div class="col-md-3 help-inline">
                        <small><em><span class="middle">[ Extensão:'.$value['ext'].' ] - [ Formato: '.$value['width'].'x'.$value['height'].'px ]</span></em></small>
                    </div>
                </div>';
            }
            elseif ($value['type'] == 'upload-crop') {
                $cover = null;

                if ($data) {
                    $cover = $module->modules->getPhotoPageOnlyLinks(json_encode($data), 'cover');

                    if (!isset($cover['remove'])) {
                        $cover['remove'] = $module->pathLang(null, config('app.PATH_SYSTEM').$module->dataModule['base'].'&operation='.$module->operation).'&deleteImagemBaseData='.$value['key'].'-'.$value['value'];
                    }
                }

                if (isset($value['width']) && isset($value['height'])) {
                    $value['info'] = 'Clique na imagem para alterar<br>[ Extensão:'.$value['ext'].' ] - [ Formato: '.$value['width'].'x'.$value['height'].'px ]';
                }

                if (!isset($value['viewmode'])) {
                    $value['viewmode'] = 1;
                }

                if (!isset($value['autocroparea'])) {
                    $value['autocroparea'] = 1;
                }

                if (!isset($value['aspectratio'])) {
                    $value['aspectratio'] = 1;
                }

                switch ($value['aspectratio']) {
                    case '1':
                        $value['aspectratioclass'] = 'cropper--area--1';
                    break;

                    case '4/3':
                        $value['aspectratioclass'] = 'cropper--area--43';
                    break;

                    case '16/9':
                        $value['aspectratioclass'] = 'cropper--area--169';
                    break;
                }

                $value['label'] = 'Clique para alterar a imagem';
                $value['noimage'] = null;


                if (!isset($value['options']['image']['src']) && isset($cover['smaller'])) {
                    $value['options']['image']['src'] = $cover['smaller'];
                }

                if (!isset($value['options']['image']['src']) && isset($cover['larger'])) {
                    $value['options']['image']['src'] = $cover['larger'];
                }

                if (!isset($value['options']['image']['src']) && $value['noimage']) {
                    $value['options']['image']['src'] = $value['noimage'];
                }

                if (!isset($value['options']['image']['src']) && !$value['noimage']) {
                    // $value['options']['image']['src'] = 'https://via.placeholder.com/'.$value['width'].'x'.$value['height'];
                    // $value['noimage'] = true;

                    $value['options']['image']['src'] = assets_img('no-image.jpg', 'src');
                    $value['noimage'] = true;
                }

                if (!isset($cover['download'])) {
                    $cover['download'] = null;
                }

                if (!isset($cover['remove'])) {
                    $cover['remove'] = null;
                }

                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$keyOperationUnique.'">'.$value['title'].'</label>
                    <div class="col-md-9">
                        <div class="content-form-crop-box">
                            <div id="'.$keyOperationUnique.'--cropper--execute" class="content-form-crop-image" title="'.$value['label'].'" data-id="'.$keyOperationUnique.'" data-width="'.$value['width'].'" data-height="'.$value['height'].'" data-aspectratio="'.$value['aspectratio'].'" data-viewmode="'.$value['viewmode'].'" data-autocroparea="'.$value['autocroparea'].'">
                                <label for="'.$keyOperationUnique.'--cropper--input">
                                    <div class="load-upload-crop">
                                        <div class="content">
                                            <i class="fa fa-spinner fa-spin"></i>
                                            <p>Carregando...</p>
                                        </div>
                                    </div>

                                    <span class="hover-icon"><i class="fas fa-edit" aria-hidden="true"></i></span>

                                    <img id="'.$keyOperationUnique.'--cropper--active" class="img-fluid" src="'.$value['options']['image']['src'].'" alt="'.$value['label'].'">
                                </label>

                                <input type="file" id="'.$keyOperationUnique.'--cropper--input" name="cropper--input" accept="image/*">
                                <input type="hidden" id="'.$keyOperationUnique.'" name="'.$keyOperationUnique.'">
                            </div>

                            <div id="'.$keyOperationUnique.'--cropper--label" class="content-form--label">
                                <p class="small font-italic text-muted mb-0">'.$value['info'].'</p>';
                                if (!isset($value['noimage']) && isset($cover['larger']) && isset($cover['download']) && isset($cover['remove'])) {
                                    $dataAutomatic .= '
                                    <div class="btn-group mt-1">
                                        <a class="btn btn-sm btn-dark" href="'.$cover['larger'].'" title="Visualizar" data-toggle="lightbox"><i class="fa fa-eye mr-2"></i>Visualizar</a>
                                        <a class="btn btn-sm btn-dark" href="'.$cover['download'].'" title="Download"><i class="fa fa-download mr-2"></i>Download</a>
                                        <a class="btn btn-sm btn-dark" href="'.$cover['remove'].'" title="Excluir"><i class="fa fa-trash mr-2"></i>Excluir</a>
                                    </div>';
                                }
                            $dataAutomatic .= '
                            </div>
                        </div>
                    </div>
                </div>
                <div class="modal fade modal-crop" id="'.$keyOperationUnique.'--modal--cropper" tabindex="-1" role="dialog" aria-labelledby="'.$keyOperationUnique.'--modal--title" aria-hidden="true">
                    <div class="modal-dialog modal-lg" role="document">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h5 class="modal-title" id="'.$keyOperationUnique.'--modal--title">Recortar imagem</h5>

                                <button type="button" class="close" data-dismiss="modal" aria-label="Fechar">
                                    <span aria-hidden="true">&times;</span>
                                </button>
                            </div>

                            <div class="modal-body">
                                <div class="img-container-crop">
                                    <img id="'.$keyOperationUnique.'--cropper--zone" class="img-fluid">
                                </div>
                            </div>

                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger" data-dismiss="modal" title="Cancelar">
                                    <i class="ml-0 mr-2 fa fa-times"></i><span>Cancelar</span>
                                </button>

                                <button type="button" class="btn btn-primary" id="'.$keyOperationUnique.'--execute--crop" title="Recortar">
                                    <i class="ml-0 mr-2 fa fa-crop"></i><span>Recortar</span>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'upload-pdf') {
                if ($data) {
                    $dataAutomatic .= '
                    <div class="row form-group">
                        <label class="col-md-3 col-form-label">'.$value['title'].'</label>
                        <div class="col-xs-12 col-sm-6">
                            <div class="card card-body bg-light">
                                '.$module->pdfSerialize($data, $module->pathLang(null, config('app.PATH_SYSTEM').$module->dataModule['base'].'&operation='.$module->operation), array($value['key'], $value['value']), $module->dataModule['key']).'
                            </div>
                        </div>
                    </div>';
                }

                $complement = null;

                if (array_key_exists('width', $value)) {
                    $complement = ' - Tamanho: '.$value['width'].'x'.$value['height'].'px';
                }

                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-6">
                        <div class="clearfix">
                            <input type="file" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="file form-control" />
                        </div>
                    </div>
                    <span class="col-md-3 help-inline">
                        <small><span class="middle" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">[ Extensão: '.$value['ext'].$complement.' ]</span></small>
                    </span>
                </div>';
            }
            else if($value['type'] == 'input') {
                $typeInput = 'text';

                if (array_key_exists('typeInput', $value)) {
                    $typeInput = $value['typeInput'];
                }

                if (array_key_exists('valueDefault', $value) && !$data) {
                    $valueDefault = $value['valueDefault'];
                }
                else {
                    $valueDefault = $data;
                }

                $infoComplement = null;

                if (array_key_exists('info', $value)) {
                    $infoComplement = '<br><em>'.$value['info'].'</em>';
                }


                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-6">
                        <div class="clearfix">
                            <input type="'.$typeInput.'" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="form-control cont-input" maxlength="'.$value['maxlength'].'" value="'.$module->processString($data, 'unserializestring').'" />
                        </div>
                    </div>
                    <span class="col-md-3 help-inline">
                        <small><span class="middle" id="cont_'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">[ máximo '.$value['maxlength'].' caracteres ]'.$infoComplement.'</span></small>
                    </span>
                </div>';
            }
            else if ($value['type'] == 'html') {
                if (@base64_decode($data)) {
                    $data = base64_decode($data);
                }

                $textActive = $module->processString($data, 'text');

                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-9">
                        <div class="clearfix">
                            <textarea id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="'.$value['class'].'">'.$textActive.'</textarea>
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'code') {
                $textActive = $module->processString($data, 'code');

                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-9">
                        <div class="clearfix">
                            <textarea id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="form-control" rows="8">'.$textActive.'</textarea>
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'itens') {
                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label">'.$value['title'].'</label>
                    <div class="col-md-9">
                        <div class="table-responsive">
                            <table class="table table-striped table-bordered table-hover table-doop">
                                <thead>
                                    <tr>
                                        <th colspan="4">
                                            <a class="blue" href="#'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" data-command="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" onclick="$.addLine(this);">
                                                <i class="fa fa-plus"></i> '.$value['parameters']['add'].'
                                            </a>
                                        </th>
                                    </tr>
                                </thead>

                                <thead>
                                    <tr>';
                                        foreach ($value['itens'] as $keyItens => $valueItens) {
                                            $dataAutomatic .= '
                                            <th>'.$valueItens['label'].'</th>';
                                        }

                                        $dataAutomatic .= '
                                        <th width="5%"></th>
                                    </tr>
                                </thead>

                                <tbody id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">
                                    <tr id="line_1" class="d-none">';
                                        foreach ($value['itens'] as $keyItens => $valueItens) {
                                            $dataAutomatic .= '
                                            <td>
                                                <input type="'.$valueItens['type'].'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'_'.$keyItens.'[]" class="form-control" />
                                            </td>';
                                        }

                                        $dataAutomatic .= '
                                        <td width="5%">
                                            <a class="blue" href="#'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" data-command="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" title="'.$value['parameters']['delete'].'" onclick="$.removeLine(this);">
                                                <i class="fa fa-trash"></i>
                                            </a>
                                        </td>
                                    </tr>';

                                    if (is_array($data)) {
                                        foreach ($data as $keyData => $valueData) {
                                            foreach ($valueData as $keyItens => $valueItens) {
                                                $keyIn = $keyItens+2;

                                                $dataAutomatic .= '
                                                <tr id="line_'.$keyIn.'">
                                                    <td>
                                                        <input type="'.$value['itens'][$keyData]['type'].'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'_'.$keyData.'[]" class="form-control" value="'.$module->processString($valueItens).'" />
                                                    </td>

                                                    <td width="5%">
                                                        <a class="blue" href="#'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" data-command="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" title="'.$value['parameters']['delete'].'" onclick="$.removeLine(this);">
                                                            <i class="fa fa-trash"></i>
                                                        </a>
                                                    </td>
                                                </tr>';
                                            }
                                        }
                                    }

                                $dataAutomatic .= '
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'select') {
                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-6">
                        <div class="clearfix">
                            <select id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="form-control select2">';
                                foreach ($value['list'] as $key => $value) {
                                    $selected = '';

                                    if ($data == $key ) { $selected = ' selected'; }

                                    $dataAutomatic .= '
                                    <option value="'.$key.'"'.$selected.'>'.$value.'</option>';
                                }
                            $dataAutomatic .= '
                            </select>
                        </div>
                    </div>
                </div>';
            }
            else if($value['type'] == 'radio') {
                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-6">
                        <div class="clearfix mt-2">';
                            foreach ($value['list'] as $keyValue => $valueValue) {
                                $checked = '';
                                if ($data == $keyValue) { $checked = ' checked'; }

                                $dataAutomatic .= '
                                <div class="custom-control custom-checkbox custom-control-inline">
                                    <input class="custom-control-input" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'_'.$keyValue.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" type="radio" value="'.$keyValue.'"'.$checked.' />
                                    <label class="custom-control-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'_'.$keyValue.'">'.$valueValue.'</label>
                                </div>';
                            }
                        $dataAutomatic .= '
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'phone') {
                $dataAutomatic .= '
                <div class="form-group">
                    <label class="control-label col-xs-12 col-sm-3 no-padding-right" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-xs-12 col-sm-5">
                        <div class="clearfix input-group">
                            <span class="input-group-addon"><i class="fas fa-phone-alt"></i></span>
                            <input type="text" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="form-control input-mask-phone" value="'.$data.'" />
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'date') {
                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-md-6">
                        <div class="clearfix input-group">
                            <span class="input-group-addon"><i class="fas fa-calendar"></i></span>
                            <input type="text" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="form-control date-picker input-mask-date" data-date-format="dd/mm/yyyy" value="'.$module->processDate($data, 'brazil').'" />
                        </div>
                    </div>
                </div>';
            }
            else if ($value['type'] == 'video') {
                if ($data) {
                    $dataAutomatic .= '
                    <div class="row form-group">
                        <label class="col-md-3 col-form-label">'.$value['title'].'</label>
                        <div class="col-xs-12 col-sm-6">
                            <div class="card card-body bg-light">
                                <video width="500" height="240" controls>
                                  <source src="'.config('app.PATH_UPLOAD').'/'.$module->dataModule['key'].'/'.$data.'" type="video/mp4">
                                </video>
                            </div>
                        </div>
                    </div>';
                }

                $dataAutomatic .= '
                <div class="row form-group">
                    <label class="col-md-3 col-form-label" for="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">'.$value['title'].'</label>
                    <div class="col-xs-12 col-sm-3">
                        <div class="clearfix">
                            <input type="file" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" name="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'" class="file form-control" />
                        </div>
                    </div>

                    <span class="help-inline col-xs-12 col-sm-6 no-padding">
                        <small><span class="middle" id="'.$value['key'].'_'.$value['value'].'_'.$module->operation.'">[ Extensão: '.$value['ext'].' - Tamanho Máximo: 5MB ]</span></small>
                    </span>
                </div>';
            }
            else if($value['type'] == 'separator') {
                if (!array_key_exists('label', $value)) {
                    $dataAutomatic .= '
                    <div class="card card-body bg-light">
                        <h5 class="mb-0">'.$value['value'].'</h5>
                    </div>';
                }
                else {
                    $dataAutomatic .= '
                        <div class="card card-body bg-light">
                            <h5>'.$value['value'].'</h5>
                            <p class="mb-0">'.$value['label'].'</p>
                        </div>';
                }
            }
            else if ($value['type'] == 'divider') {
                $dataAutomatic .= '
                <hr>';
            }
        }
    }

    $dataAutomatic .= '
    <hr>
    <div class="text-center">
        <button id="action_'.$module->operation.'" name="action_'.$module->operation.'" class="btn btn-primary" type="submit" value="action_'.$module->operation.'" title="Editar">
            <i class="fa fa-save mr-2"></i> Editar
        </button>
    </div>';
}
else {
    $dataAutomatic .= '
    <div class="alert alert-block alert-info mb-0">
        <i class="fas fa-info-circle mr-2"></i>'.$vars['htmlNoneItens'].'
    </div>';
}

$dataAutomatic .= '
</form></div></section>';

return $dataAutomatic;
