<?php
// doopSites v1.9.7 - Última atualização 22/02/2023 16:20

class EmailsInput extends FunctionsDoop
{
    public function __construct()
    {
        parent::__construct('system');
    }

    public function prepareEmails()
    {
        $data['emails'] = parent::post('emails_string', 'array_explode_shift');
        $data['labels'] = parent::post('emails_label', 'array_explode_shift');

        return $data;
    }

    public function showHtml($dataSelect = null)
    {
        $html = '
        <div class="row form-group">
          <label class="col-md-3 col-form-label">E-mails:</label>
          <div class="col-md-9">
            <div class="table-responsive">
              <table class="table table-striped table-bordered table-hover table-doop">
                <thead>
                  <tr>
                    <th colspan="4"><a class="blue" href="#emails" data-command="emails" onclick="$.addLine(this);"><i class="fa fa-plus"></i> Adicionar E-mail</a></th>
                  </tr>
                </thead>

                <thead>
                  <tr>
                    <th>E-mail</th>
                    <th colspan="2">Detalhes</th>
                  </tr>
                </thead>

                <tbody id="emails">
                  <tr id="line_1" class="d-none">
                    <td width="55%">
                      <input type="email" name="emails_string[]" class="form-control" />
                    </td>

                    <td width="40%">
                      <input type="text" name="emails_label[]" class="form-control" />
                    </td>

                    <td width="1%">
                      <a href="#emails" data-command="emails" title="Excluir E-mail" onclick="$.removeLine(this);">
                        <i class="fa fa-trash icon-only bigger-130"></i>
                      </a>
                    </td>
                  </tr>';

                  if (is_array($dataSelect)) {
                    $emails = $dataSelect['emails'];
                    $emailsLabels = $dataSelect['labels'];

                      if ($emails) {
                    foreach ($emails as $key => $value) {

                    if(array_key_exists($key, $emailsLabels)) { $valueLabel = $emailsLabels[$key]; } else { $valueLabel = null; }
                      $line = $key+2;
        $html .= '
                <tr id="line_'.$line.'">
                  <td width="55%">
                    <input type="email" name="emails_string[]" class="form-control" value="'.parent::processString($value, 'text').'" />
                  </td>

                  <td width="40%">
                    <input type="text" name="emails_label[]" class="form-control" value="'.parent::processString($valueLabel, 'text').'" />
                  </td>

                  <td width="5%">
                    <a class="blue" href="#emails" data-command="emails" title="Excluir E-mail" onclick="$.removeLine(this);">
                      <i class="fa fa-trash icon-only bigger-130"></i>
                    </a>
                  </td>
                </tr>';
                  } }
                }
        $html .= '
                </tbody>
              </table>
            </div>
          </div>
        </div>';

       return $html;
    }
}
